/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.log.correlationid;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrelationIdStore {
    private static final Logger log = LoggerFactory.getLogger(CorrelationIdStore.class);
    public static ThreadLocal<Map<String, String>> correlationIdMap = new ThreadLocal();

    private CorrelationIdStore() {
        throw new UnsupportedOperationException("Not allowed to create an instance of this class");
    }

    public static String getCorrelationId(String id) {
        String bcid = CorrelationIdStore.getCorrelationIdMap().get(id);
        log.debug("BCID from TL: [{}:{}]", (Object)id, (Object)bcid);
        return bcid;
    }

    public static void setCorrelationId(String id, String newCorrelationId) {
        log.debug("BCID to TL: [{}:{}]", (Object)id, (Object)newCorrelationId);
        CorrelationIdStore.getCorrelationIdMap().put(id, newCorrelationId);
    }

    private static Map<String, String> getCorrelationIdMap() {
        Map<String, String> map = correlationIdMap.get();
        if (map == null) {
            map = new HashMap<String, String>();
            correlationIdMap.set(map);
        }
        return map;
    }
}

