/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.util;

import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.mule.module.xml.stax.ReversibleXMLStreamReader;
import org.mule.module.xml.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtil
extends org.mule.util.XMLUtils {
    private static Logger logger = LoggerFactory.getLogger(XmlUtil.class);
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private static XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();

    public static XMLStreamReader toXmlStreamReader(Object src) throws XMLStreamException {
        return XMLUtils.toXMLStreamReader((XMLInputFactory)xmlInputFactory, (Object)src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QName getRootElementQName(Object src) throws XMLStreamException {
        QName name;
        XMLStreamReader reader = null;
        try {
            reader = XmlUtil.toXmlStreamReader(src);
            reader.nextTag();
            name = reader.getName();
        }
        finally {
            reader.close();
        }
        return name;
    }

    public static Date convertXmlDateToDate(XMLGregorianCalendar date) {
        return date.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar convertDateToXmlDate(Date date) {
        try {
            GregorianCalendar fromDate = new GregorianCalendar();
            if (date != null) {
                fromDate.setTime(date);
            }
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(fromDate);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String convertReversibleXMLStreamReaderToString(ReversibleXMLStreamReader reader, String encoding) {
        boolean wasTrackingEnabled;
        if (logger.isDebugEnabled()) {
            logger.debug("Start read ReversibleXMLStreamReader, T={}, R={}", (Object)Thread.currentThread().getId(), (Object)reader.toString());
        }
        if (!(wasTrackingEnabled = reader.isTracking())) {
            reader.setTracking(true);
        }
        String xml = XmlUtil.convertXMLStreamReaderToString((XMLStreamReader)reader, encoding);
        if (!wasTrackingEnabled) {
            reader.setTracking(false);
        }
        reader.reset();
        if (logger.isDebugEnabled()) {
            logger.debug("Stop read ReversibleXMLStreamReader, now reset");
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertXMLStreamReaderToString(XMLStreamReader reader, String encoding) {
        String string;
        ByteArrayOutputStream os = new ByteArrayOutputStream(2048);
        XMLStreamWriter writer = xmlOutputFactory.createXMLStreamWriter(os, encoding);
        try {
            String result;
            writer.writeStartDocument();
            XMLUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
            writer.writeEndDocument();
            string = result = os.toString();
        }
        catch (Throwable throwable) {
            try {
                writer.close();
                os.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        os.close();
        return string;
    }
}

