/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.test;

import org.mule.api.MuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.test.ServletContainerWithMuleReceiverServlet;
import org.soitoolkit.commons.mule.test.StandaloneMuleServer;

public class MuleServerWithServletContainer
extends StandaloneMuleServer {
    private static Logger log = LoggerFactory.getLogger(MuleServerWithServletContainer.class);
    private static final int WAITTIME_MULE_SERVLET_TRANSPORT = 500;
    protected int httpPort = -1;
    protected String contextPath = null;
    protected String muleReceiverServletUri = null;
    ServletContainerWithMuleReceiverServlet servletContainer = null;

    public MuleServerWithServletContainer(String muleServerId, String muleConfig, int httpPort, String contextPath, String muleReceiverServletUri) {
        super(muleServerId, muleConfig, true);
        this.httpPort = httpPort;
        this.contextPath = contextPath;
        this.muleReceiverServletUri = muleReceiverServletUri;
    }

    @Override
    public void start() throws InterruptedException, Exception {
        super.start();
        boolean muleStarted = false;
        while (!muleStarted) {
            MuleContext mc = this.muleServer.getMuleContext();
            log.debug("MuleContext = {}", (Object)mc);
            if (mc != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Mule isInitialising = " + mc.isInitialising());
                    log.debug("Mule isInitialised  = " + mc.isInitialised());
                    log.debug("Mule isStarting     = " + mc.isStarting());
                    log.debug("Mule isStarted      = " + mc.isStarted());
                }
                muleStarted = mc.isStarted();
            }
            Thread.sleep(this.getWaittimeMuleServletTransport());
        }
        log.info("Startup Servlet container with Mule Receiver Servlet...");
        this.servletContainer = new ServletContainerWithMuleReceiverServlet(this.httpPort, this.contextPath, this.muleReceiverServletUri, this.muleServer.getMuleContext(), this.muleServerId);
        this.servletContainer.start();
    }

    @Override
    public void shutdown() throws Exception {
        log.info("Shutdown Servlet container...");
        this.servletContainer.shutdown();
        super.shutdown();
    }

    protected int getWaittimeMuleServletTransport() {
        return 500;
    }
}

