/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.log;

import org.mule.api.MuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.api.log.EventLogger;
import org.soitoolkit.commons.mule.log.DefaultEventLogger;

public class EventLoggerFactory {
    private static final String INIT_ERROR_MISSING_MULECONTEXT = "muleContext is not injected (is null)";
    private static final String CUSTOM_EVENT_LOGGER_BEAN_NAME = "soitoolkit.eventLogger";
    private static final EventLoggerFactory factoryInstance = new EventLoggerFactory();
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public static EventLogger getEventLogger(MuleContext muleContext) {
        return factoryInstance.getEventLoggerImpl(muleContext);
    }

    private EventLogger getEventLoggerImpl(MuleContext muleContext) {
        this.assertNotNull(INIT_ERROR_MISSING_MULECONTEXT, muleContext);
        EventLogger el = this.getCustomEventLogger(muleContext);
        if (el != null) {
            this.log.debug("returning custom eventlogger type: {}", (Object)el.getClass().getName());
            return el;
        }
        this.log.debug("returning default eventlogger");
        return this.getDefaultEventLogger(muleContext);
    }

    private EventLogger getDefaultEventLogger(MuleContext muleContext) {
        DefaultEventLogger el = new DefaultEventLogger();
        el.setMuleContext(muleContext);
        return el;
    }

    private EventLogger getCustomEventLogger(MuleContext muleContext) {
        Object obj = this.getCustomEventLoggerFromRegistry(muleContext);
        if (obj == null) {
            this.log.debug("no custom event logger defined using bean name: {}", (Object)CUSTOM_EVENT_LOGGER_BEAN_NAME);
            return null;
        }
        if (obj instanceof EventLogger) {
            this.log.debug("custom event logger defined using bean name: {}, impl class: {}", (Object)CUSTOM_EVENT_LOGGER_BEAN_NAME, (Object)obj.getClass().getName());
            return (EventLogger)obj;
        }
        String errMsg = "custom event logger defined using bean name: soitoolkit.eventLogger does not implement required interface: " + EventLogger.class.getName() + ", impl class: " + obj.getClass().getName();
        this.log.error(errMsg);
        throw new IllegalStateException(errMsg);
    }

    protected Object getCustomEventLoggerFromRegistry(MuleContext muleContext) {
        Object obj = muleContext.getRegistry().lookupObject(CUSTOM_EVENT_LOGGER_BEAN_NAME);
        return obj;
    }

    private void assertNotNull(String assertMessage, Object testee) {
        if (testee == null) {
            throw new IllegalStateException(assertMessage);
        }
    }
}

