/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.util.BOMStripperInputStream;
import org.springframework.util.StringUtils;

public class MiscUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(MiscUtil.class);
    private static final String placeholderPrefix = "${";
    private static final String placeholderSuffix = "}";

    private MiscUtil() {
        throw new UnsupportedOperationException("Not allowed to create an instance of this class");
    }

    public static String readFileAsString(String filename) {
        return MiscUtil.readFileAsString(filename, DEFAULT_CHARSET);
    }

    public static String readFileAsString(String filename, String charset) {
        try {
            return MiscUtil.convertStreamToString(new FileInputStream(filename), charset);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String convertStreamToString(InputStream is) {
        return MiscUtil.convertStreamToString(is, DEFAULT_CHARSET);
    }

    public static String convertStreamToString(InputStream is, String charset) {
        if (is == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        long linecount = 0L;
        long size = 0L;
        try {
            String line;
            boolean emptyBuffer = true;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BOMStripperInputStream(is), charset));
            while ((line = reader.readLine()) != null) {
                if (emptyBuffer) {
                    emptyBuffer = false;
                } else {
                    sb.append('\n');
                    ++size;
                }
                sb.append(line);
                size += (long)line.length();
                if (!logger.isTraceEnabled() || ++linecount % 50000L != 0L) continue;
                logger.trace("Lines read: {}, {} characters and counting...", (Object)linecount, (Object)size);
                MiscUtil.printMemUsage();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace("Lines read: {}, {} characters", (Object)linecount, (Object)size);
                MiscUtil.printMemUsage();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        return sb.toString();
    }

    private static void printMemUsage() {
        int mb = 0x100000;
        MemoryMXBean mxb = ManagementFactory.getMemoryMXBean();
        MemoryUsage hm = mxb.getHeapMemoryUsage();
        MemoryUsage nhm = mxb.getNonHeapMemoryUsage();
        logger.trace("Heap Memory:  init/used/committed/max=" + hm.getInit() / (long)mb + "/" + hm.getUsed() / (long)mb + "/" + hm.getCommitted() / (long)mb + "/" + hm.getMax() / (long)mb);
        logger.trace("Non-Heap Mem: init/used/committed/max=" + nhm.getInit() / (long)mb + "/" + nhm.getUsed() / (long)mb + "/" + nhm.getCommitted() / (long)mb + "/" + nhm.getMax() / (long)mb);
        Runtime runtime = Runtime.getRuntime();
        logger.trace("Used/Free/Total/Max:" + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb + "/" + runtime.freeMemory() / (long)mb + "/" + runtime.totalMemory() / (long)mb + "/" + runtime.maxMemory() / (long)mb);
    }

    public static String parseStringValue(String strVal, ResourceBundle bundle) {
        return MiscUtil.parseStringValue(strVal, MiscUtil.convertResourceBundleToProperties(bundle));
    }

    public static String parseStringValue(String strVal, Properties props) {
        StringBuffer buf = new StringBuffer(strVal);
        int startIndex = strVal.indexOf(placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = MiscUtil.findPlaceholderEndIndex(buf, startIndex);
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + placeholderPrefix.length(), endIndex);
                String propVal = props.getProperty(placeholder);
                if (propVal != null) {
                    propVal = MiscUtil.parseStringValue(propVal, props);
                    buf.replace(startIndex, endIndex + placeholderSuffix.length(), propVal);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Resolved placeholder '" + placeholder + "'");
                    }
                    startIndex = buf.indexOf(placeholderPrefix, startIndex + propVal.length());
                    continue;
                }
                throw new RuntimeException("Could not resolve placeholder '" + placeholder + "'");
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    public static String removeLeadingNewLines(String string) {
        if (string == null) {
            return string;
        }
        int pos = 0;
        int len = string.length();
        boolean done = false;
        while (!done) {
            char c = string.charAt(pos);
            if (c == '\n' || c == '\r') {
                ++pos;
            } else {
                done = true;
            }
            if (pos != len) continue;
            done = true;
        }
        String result = string.substring(pos);
        logger.debug("removed " + pos + " new line characters");
        return result;
    }

    public static String removeTrailingNewLines(String string) {
        if (string == null) {
            return string;
        }
        String trimmedString = org.apache.commons.lang.StringUtils.chomp((String)string);
        while (trimmedString.length() < string.length()) {
            string = trimmedString;
            trimmedString = org.apache.commons.lang.StringUtils.chomp((String)string);
        }
        return trimmedString;
    }

    private static int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + placeholderPrefix.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (StringUtils.substringMatch((CharSequence)buf, (int)index, (CharSequence)placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    ++index;
                    continue;
                }
                return index;
            }
            if (StringUtils.substringMatch((CharSequence)buf, (int)index, (CharSequence)placeholderPrefix)) {
                ++withinNestedPlaceholder;
                index += placeholderPrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    static Properties convertResourceBundleToProperties(ResourceBundle resource) {
        Properties properties = new Properties();
        Enumeration<String> keys = resource.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            properties.put(key, resource.getString(key));
        }
        return properties;
    }
}

