/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.test.sftp;

import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Arrays;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.FileSystemFactory;
import org.apache.sshd.server.FileSystemView;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.SshFile;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.filesystem.NativeFileSystemFactory;
import org.apache.sshd.server.filesystem.NativeFileSystemView;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.sftp.SftpSubsystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpServer {
    static final String TARGET_DIR = "target";
    static final String SFTP_ROOT_DIR = "target" + File.separator + "sftproot";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SshServer sshd;
    private int port = 2222;

    public static void main(String[] args) {
        SftpServer server = new SftpServer();
        server.startServer();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void startServer() {
        this.logger.info("starting server on port {} ...", (Object)this.port);
        try {
            this.sshd = SshServer.setUpDefaultServer();
            this.sshd.setPort(this.port);
            this.sshd.setSubsystemFactories(Arrays.asList(new SftpSubsystem.Factory()));
            this.sshd.setCommandFactory((CommandFactory)new ScpCommandFactory());
            this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(TARGET_DIR + File.separator + "ssh-server-key.ser"));
            this.sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

                public boolean authenticate(String username, String password, ServerSession session) {
                    SftpServer.this.logger.debug("auth using username + password");
                    return true;
                }
            });
            this.sshd.setPublickeyAuthenticator(new PublickeyAuthenticator(){

                public boolean authenticate(String username, PublicKey key, ServerSession session) {
                    SftpServer.this.logger.debug("auth using public key");
                    return true;
                }
            });
            this.sshd.setFileSystemFactory((FileSystemFactory)this.getModifiedNativeFileSystemFactory());
            this.sshd.start();
            this.logger.info("started server on port {}", (Object)this.port);
        }
        catch (IOException e) {
            String errMsg = "Failed to start";
            this.logger.error(errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
    }

    public void stopServer() {
        this.logger.info("stopping server...");
        try {
            if (this.sshd != null) {
                boolean stopImmediately = true;
                this.sshd.stop(stopImmediately);
                this.logger.info("stopped server");
            }
        }
        catch (InterruptedException e) {
            String errMsg = "Failed to stop";
            this.logger.error(errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
    }

    NativeFileSystemFactory getModifiedNativeFileSystemFactory() {
        return new NativeFileSystemFactory(){

            public FileSystemView createFileSystemView(Session session) {
                String userName = SftpServer.this.getUsername(session);
                ModifiedNativeFileSystemView nfsv = new ModifiedNativeFileSystemView(userName, this.isCaseInsensitive());
                SftpServer.this.logger.debug("creating a modified NativeFileSystemView: {}", ((Object)((Object)nfsv)).getClass());
                return nfsv;
            }
        };
    }

    String getUsername(Session session) {
        return session.getUsername();
    }

    class ModifiedNativeFileSystemView
    extends NativeFileSystemView {
        String modifiedRootDir;

        public ModifiedNativeFileSystemView(String userName, boolean caseInsensitive) {
            super(userName, caseInsensitive);
            this.modifiedRootDir = System.getProperty("user.dir") + File.separator + SFTP_ROOT_DIR;
            File rootDir = new File(this.modifiedRootDir);
            rootDir.mkdirs();
            if (!rootDir.exists() || !rootDir.isDirectory()) {
                String errMsg = "Could not create sftp-root dir: " + rootDir;
                SftpServer.this.logger.error(errMsg);
                throw new RuntimeException(errMsg);
            }
            SftpServer.this.logger.debug("Modified NativeFileSystemView created with root dir: {}", (Object)this.modifiedRootDir);
            SftpServer.this.logger.info("Using sftp-root dir: {}", (Object)this.modifiedRootDir);
        }

        public SshFile getFile(String file) {
            return this.getFile(this.modifiedRootDir, file);
        }
    }
}

