/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.test;

import java.util.ArrayList;
import org.mule.MuleServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.util.RecursiveResourceBundle;

public class StandaloneMuleServer {
    private static Logger log = LoggerFactory.getLogger(StandaloneMuleServer.class);
    protected String muleServerId = null;
    protected String muleConfig = null;
    MuleServer muleServer = null;

    public StandaloneMuleServer(String muleServerId, String muleConfig, boolean loadServices) {
        this.muleServerId = muleServerId;
        this.muleConfig = this.getConfigFileFromMuleDeployPropertyFile(loadServices);
        if (muleConfig != null && muleConfig.length() > 0) {
            this.muleConfig = this.muleConfig + ", " + muleConfig;
        }
    }

    public StandaloneMuleServer(String muleServerId, boolean loadTestServices, boolean loadServices) {
        this.muleServerId = muleServerId;
        this.muleConfig = this.getConfigFileFromMuleDeployPropertyFile(loadServices);
        if (loadTestServices) {
            System.getProperties().put("spring.profiles.active", "default,soitoolkit-teststubs");
        }
    }

    public void run() throws Exception {
        log.info("Startup...");
        this.start();
        this.sleepShortOnWindowsHostToAvoidHangDuringStart_issue222();
        log.info("Hit the RETURN - key to shutdown");
        System.in.read();
        log.info("Shutdown...");
        this.shutdown();
        log.info("Shutdown complete");
    }

    private void sleepShortOnWindowsHostToAvoidHangDuringStart_issue222() throws InterruptedException {
        int sleepTimeMillis = 2000;
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            log.info("#issue 222: Windows OS detected, sleeping for {} ms to avoid hang in Eclipse", (Object)sleepTimeMillis);
            Thread.sleep(sleepTimeMillis);
        }
    }

    public void start() throws InterruptedException, Exception {
        log.info("Startup Mule...");
        System.setProperty("mule.serverId", this.muleServerId);
        System.setProperty("org.apache.cxf.Logger", "org.apache.cxf.common.logging.Log4jLogger");
        this.muleServer = new MuleServer(this.muleConfig);
        this.muleServer.start(true, true);
    }

    public void shutdown() throws Exception {
        log.info("Shutdown Mule...");
        this.muleServer.shutdown();
    }

    protected String getConfigFileFromMuleDeployPropertyFile(boolean loadServices) {
        RecursiveResourceBundle rb = new RecursiveResourceBundle("mule-deploy");
        String allConfigFiles = rb.getString("config.resources");
        if (loadServices) {
            return allConfigFiles;
        }
        String[] allConfigFilesArr = allConfigFiles.split(",");
        ArrayList<String> configFilesList = new ArrayList<String>();
        for (String configFile : allConfigFilesArr) {
            if (configFile.endsWith("-service.xml")) continue;
            configFilesList.add(configFile);
        }
        StringBuffer configFiles = new StringBuffer();
        for (String configFile : configFilesList) {
            if (configFiles.length() == 0) {
                configFiles.append(configFile);
                continue;
            }
            configFiles.append(',').append(configFile);
        }
        return configFiles.toString();
    }
}

