/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.monitor;

import java.util.Date;
import java.util.ResourceBundle;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.xml.bind.JAXBElement;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.monitor.schema.v1.MonitorInfoType;
import org.soitoolkit.commons.monitor.schema.v1.ObjectFactory;
import org.soitoolkit.commons.mule.monitor.MonitorEndpointHelper;
import org.soitoolkit.commons.mule.util.XmlUtil;

@Path(value="/monitor")
public class MonitorService
implements MuleContextAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ObjectFactory OF = new ObjectFactory();
    private String artifactId = null;
    private MuleContext muleContext = null;

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.logger.debug("MuleContext injected");
        this.muleContext = muleContext;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="xml")
    public JAXBElement<MonitorInfoType> pingXml() {
        return this.ping();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="json")
    public JAXBElement<MonitorInfoType> pingJson() {
        return this.ping();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="services")
    public JAXBElement<MonitorInfoType> pingServicesDefault(@DefaultValue(value="false") @QueryParam(value="errorsOnly") String errorsOnly) {
        return this.pingServices(this.toBoolean(errorsOnly));
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="services/xml")
    public JAXBElement<MonitorInfoType> pingServicesXml(@DefaultValue(value="false") @QueryParam(value="errorsOnly") String errorsOnly) {
        return this.pingServices(this.toBoolean(errorsOnly));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="services/json")
    public JAXBElement<MonitorInfoType> pingServicesJson(@DefaultValue(value="false") @QueryParam(value="errorsOnly") String errorsOnly) {
        return this.pingServices(this.toBoolean(errorsOnly));
    }

    protected JAXBElement<MonitorInfoType> ping() {
        MonitorInfoType ping = new MonitorInfoType();
        ping.setName(this.artifactId);
        ping.setVersion(this.getComponentVersion(this.artifactId));
        ping.setTimestamp(XmlUtil.convertDateToXmlDate(new Date()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ping returned for {} v{} at {}", new Object[]{ping.getName(), ping.getVersion(), ping.getTimestamp()});
        }
        return OF.createMonitorInfo(ping);
    }

    protected JAXBElement<MonitorInfoType> pingServices(boolean errorsOnly) {
        JAXBElement<MonitorInfoType> result = this.ping();
        return result;
    }

    private boolean toBoolean(String errorsOnly) {
        return Boolean.parseBoolean(errorsOnly);
    }

    private String getComponentVersion(String artifactId) {
        String bundleName = artifactId + "-build";
        String unknownVersion = "[unknown version]";
        try {
            ResourceBundle rb = ResourceBundle.getBundle(bundleName);
            String version = rb.getString("soitoolkit.buildinfo.version");
            return version;
        }
        catch (Exception e) {
            this.logger.warn("Could not find resource bundle {}, return {}", (Object)(bundleName + ".properties"), (Object)unknownVersion);
            return unknownVersion;
        }
    }

    protected void addJmsEndpointInfo(JAXBElement<MonitorInfoType> result, boolean showErrorsOnly, String queueName) {
        this.addExtraInfo(result, showErrorsOnly, "jms", queueName, MonitorEndpointHelper.pingJmsEndpoint(this.muleContext, queueName));
    }

    protected void addJmsBackoutQueueInfo(JAXBElement<MonitorInfoType> result, boolean showErrorsOnly, String queueName) {
        this.addExtraInfo(result, showErrorsOnly, "jms", queueName, MonitorEndpointHelper.pingJmsBackoutQueue(this.muleContext, queueName));
    }

    protected void addJdbcEndpointInfo(JAXBElement<MonitorInfoType> result, boolean showErrorsOnly, String tableName) {
        this.addExtraInfo(result, showErrorsOnly, "jdbc", tableName, MonitorEndpointHelper.pingJdbcEndpoint(this.muleContext, tableName));
    }

    protected void addSoapHttpEndpointInfo(JAXBElement<MonitorInfoType> result, boolean showErrorsOnly, String soapHttpUrl) {
        this.addExtraInfo(result, showErrorsOnly, "soap-http", soapHttpUrl, MonitorEndpointHelper.pingSoapHttpUrl(soapHttpUrl));
    }

    private void addExtraInfo(JAXBElement<MonitorInfoType> result, boolean showErrorsOnly, String protocol, String endpointName, String endpointStatus) {
        if (showErrorsOnly && endpointStatus.startsWith("OK")) {
            return;
        }
        MonitorInfoType.ExtraInfo ei = new MonitorInfoType.ExtraInfo();
        if (protocol != null) {
            endpointName = protocol + ":" + endpointName;
        }
        ei.setName(endpointName);
        ei.setValue(endpointStatus);
        ((MonitorInfoType)result.getValue()).getExtraInfo().add(ei);
    }
}

