/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.cert;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.cert.X509CertificateUtil;

public class X509CertificateEvaluator
implements ExpressionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(X509CertificateEvaluator.class);
    public static final String NAME = "x509cert";
    public static final String EXPR_SENDERID = "sender-id";
    private String propertyName;

    public String getName() {
        return NAME;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        log.debug("propertyName = {}", (Object)propertyName);
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    public Object evaluate(String expression, MuleMessage message) {
        try {
            String value = null;
            if (EXPR_SENDERID.equals(expression)) {
                value = this.getSenderIdFromCertificate(message, "PEER_CERTIFICATES");
                if (log.isDebugEnabled()) {
                    String me = this.getSenderIdFromCertificate(message, "LOCAL_CERTIFICATES");
                    log.debug("{} validates sender id: {}", (Object)me, (Object)value);
                }
            }
            return value;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private String getSenderIdFromCertificate(MuleMessage message, String certProperty) {
        String senderId = null;
        X509Certificate cert = this.getX509Certificate(message, certProperty);
        if (cert != null) {
            senderId = X509CertificateUtil.getPropertyFromX500Principal(cert, this.propertyName);
            if (senderId == null) {
                this.logAndThrowError("No senderId found in Certificate");
            }
        } else {
            this.logAndThrowError("No senderId found in Certificate: No certificate found from client");
        }
        if (senderId.startsWith("#")) {
            return this.convertFromHexToString(senderId.substring(5));
        }
        return senderId;
    }

    private X509Certificate getX509Certificate(MuleMessage message, String certProperty) {
        X509Certificate cert = null;
        Certificate[] certificateChain = (Certificate[])message.getOutboundProperty(certProperty);
        if (certificateChain != null) {
            if (certificateChain[0] instanceof X509Certificate) {
                cert = (X509Certificate)certificateChain[0];
            } else {
                this.logAndThrowError("First certificate in chain is not X509Certificate: " + certificateChain[0]);
            }
        } else {
            this.logAndThrowError("No certificate chain found from client");
        }
        return cert;
    }

    private void logAndThrowError(String errorMessage) {
        log.error(errorMessage);
        throw new RuntimeException(errorMessage);
    }

    private String convertFromHexToString(String hexString) {
        byte[] txtInByte = new byte[hexString.length() / 2];
        int j = 0;
        for (int i = 0; i < hexString.length(); i += 2) {
            txtInByte[j++] = Byte.parseByte(hexString.substring(i, i + 2), 16);
        }
        return new String(txtInByte);
    }
}

