/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.agentx.AgentXContextPDU;
import org.snmp4j.agent.agentx.AgentXMessageHeader;
import org.snmp4j.agent.agentx.AgentXProtocol;
import org.snmp4j.smi.OctetString;

public abstract class AgentXRequestPDU
extends AgentXContextPDU {
    private static final long serialVersionUID = 4463505479247648609L;
    protected MOScope[] ranges;

    protected AgentXRequestPDU(byte type, OctetString context) {
        super(type, context);
    }

    protected AgentXRequestPDU(byte type, OctetString context, MOScope[] ranges) {
        super(type, context);
        this.ranges = ranges;
    }

    protected AgentXRequestPDU(AgentXMessageHeader header) {
        super(header);
    }

    @Override
    protected void decodeAfterContext(ByteBuffer buf, int length) throws IOException {
        this.ranges = AgentXProtocol.decodeRanges(buf);
    }

    @Override
    protected void encodeAfterContext(ByteBuffer buf) {
        AgentXProtocol.encodeRanges(buf, this.ranges);
    }

    @Override
    protected int getAfterContextLength() {
        return AgentXProtocol.getRangesLength(this.ranges);
    }

    public int size() {
        if (this.ranges != null) {
            return this.ranges.length;
        }
        return 0;
    }

    public MOScope[] getRanges() {
        return this.ranges;
    }

    @Override
    protected String toStringExtMembers() {
        return super.toStringExtMembers() + ",ranges=" + String.valueOf(Arrays.asList(this.ranges));
    }
}

