/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.agentx.AgentXMessageHeader;
import org.snmp4j.agent.agentx.AgentXProtocol;
import org.snmp4j.agent.agentx.AgentXRequestPDU;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class AgentXGetPDU
extends AgentXRequestPDU {
    private static final long serialVersionUID = -6529473376764354480L;

    public AgentXGetPDU(OctetString context, OID[] oids) {
        super((byte)5, context);
        this.setOids(oids);
    }

    public AgentXGetPDU(AgentXMessageHeader header) {
        super(header);
        if (header.getType() != 5) {
            throw new IllegalArgumentException();
        }
    }

    public void setOids(OID[] oids) {
        this.ranges = new DefaultMOScope[oids.length];
        for (int i = 0; i < oids.length; ++i) {
            this.ranges[i] = new DefaultMOScope(oids[i], true, oids[i], true);
        }
    }

    public OID[] getOids() {
        OID[] oids = new OID[this.ranges.length];
        for (int i = 0; i < this.ranges.length; ++i) {
            oids[i] = this.ranges[i].getLowerBound();
        }
        return oids;
    }

    @Override
    protected void decodeAfterContext(ByteBuffer buf, int length) throws IOException {
        this.ranges = AgentXProtocol.decodeRanges(buf, true);
    }
}

