/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.subagent;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOQueryWithSource;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.MOServerLookupEvent;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.RequestHandler;
import org.snmp4j.agent.agentx.AgentX;
import org.snmp4j.agent.agentx.AgentXAddAgentCapsPDU;
import org.snmp4j.agent.agentx.AgentXClosePDU;
import org.snmp4j.agent.agentx.AgentXCommandEvent;
import org.snmp4j.agent.agentx.AgentXCommandListener;
import org.snmp4j.agent.agentx.AgentXMessageDispatcher;
import org.snmp4j.agent.agentx.AgentXNotifyPDU;
import org.snmp4j.agent.agentx.AgentXOpenPDU;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXPeer;
import org.snmp4j.agent.agentx.AgentXPingPDU;
import org.snmp4j.agent.agentx.AgentXProtocol;
import org.snmp4j.agent.agentx.AgentXRegion;
import org.snmp4j.agent.agentx.AgentXRegisterPDU;
import org.snmp4j.agent.agentx.AgentXRemoveAgentCapsPDU;
import org.snmp4j.agent.agentx.AgentXResponseEvent;
import org.snmp4j.agent.agentx.AgentXResponsePDU;
import org.snmp4j.agent.agentx.AgentXSession;
import org.snmp4j.agent.agentx.AgentXTarget;
import org.snmp4j.agent.agentx.AgentXUnregisterPDU;
import org.snmp4j.agent.agentx.event.PingEvent;
import org.snmp4j.agent.agentx.event.PingListener;
import org.snmp4j.agent.agentx.subagent.AgentXRequest;
import org.snmp4j.agent.agentx.subagent.AgentXSharedMOTable;
import org.snmp4j.agent.agentx.subagent.AgentXSharedMOTableSupport;
import org.snmp4j.agent.agentx.subagent.AgentXSharedMutableMOTable;
import org.snmp4j.agent.agentx.subagent.RegistrationCallback;
import org.snmp4j.agent.agentx.subagent.SubagentXConfigManager;
import org.snmp4j.agent.agentx.subagent.index.AnyNewIndexOID;
import org.snmp4j.agent.agentx.subagent.index.NewIndexOID;
import org.snmp4j.agent.mo.GenericManagedObject;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.lock.LockRequest;
import org.snmp4j.agent.mo.snmp.CoexistenceInfo;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestFactory;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;
import org.snmp4j.util.WorkerTask;

public class AgentXSubagent
implements AgentXCommandListener,
NotificationOriginator,
TransportStateListener {
    private static final LogAdapter LOGGER = LogFactory.getLogger(AgentXSubagent.class);
    private final RequestFactory<AgentXCommandEvent<?>, AgentXResponsePDU, AgentXRequest> factory;
    private final AgentX agentX;
    protected final Map<RequestID, AgentXRequest> requestList;
    protected final Map<Address, AgentXPeer<?>> peers = new LinkedHashMap(2);
    protected final Map<Integer, AgentXSession<?>> sessions = new ConcurrentHashMap(2);
    protected RequestHandler<AgentXRequest> requestHandlerGet;
    protected RequestHandler<AgentXRequest> requestHandlerGetNext;
    protected RequestHandler<AgentXRequest> requestHandlerGetBulk;
    protected RequestHandler<AgentXRequest> requestHandlerTestSet;
    protected RequestHandler<AgentXRequest> requestHandlerCommitSet;
    protected RequestHandler<AgentXRequest> requestHandlerUndoSet;
    protected RequestHandler<AgentXRequest> requestHandlerCleanupSet;
    protected int nextTransactionID = 0;
    protected Map<String, AgentXSharedMOTableSupport<?, ?>> sharedMOTableSupport = new ConcurrentHashMap(5);
    private final OID subagentID;
    private final OctetString subagentDescr;
    private final long timeout = 5000L;
    private byte defaultPriority = (byte)127;
    private Timer pingTimer;
    private transient Vector<PingListener> pingListeners;
    private final SubagentXConfigManager configManager;

    public AgentXSubagent(AgentX agentX, OID subagentID, OctetString subagentDescr, SubagentXConfigManager configManager) {
        this.configManager = configManager;
        this.requestList = new ConcurrentHashMap<RequestID, AgentXRequest>(10);
        this.agentX = agentX;
        this.subagentID = subagentID;
        this.subagentDescr = subagentDescr;
        this.factory = new DefaultAgentXRequestFactory();
        this.requestHandlerGet = new GetRequestHandler();
        this.requestHandlerCleanupSet = new CleanupSetHandler();
        this.requestHandlerCommitSet = new CommitSetHandler();
        this.requestHandlerTestSet = new TestSetHandler();
        this.requestHandlerUndoSet = new UndoSetHandler();
        this.requestHandlerGetNext = new GetNextHandler();
        this.requestHandlerGetBulk = new GetBulkHandler();
        agentX.addCommandResponder(this);
    }

    public void setPingDelay(int seconds) {
        if (this.pingTimer != null) {
            this.pingTimer.cancel();
            this.pingTimer = null;
        }
        if (seconds > 0) {
            this.pingTimer = new Timer();
            this.pingTimer.schedule((TimerTask)new PingTask(), (long)seconds * 1000L, (long)seconds * 1000L);
        }
    }

    @Override
    public <A extends Address> void processCommand(AgentXCommandEvent<A> event) {
        if (event.getCommand() != null) {
            event.setProcessed(true);
            Command command = new Command(event);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Processing AgentX PDU: " + String.valueOf(event.getCommand()))));
            }
            if (this.configManager.getWorkerPool() != null) {
                this.configManager.getWorkerPool().execute((WorkerTask)command);
            } else {
                command.run();
            }
        }
    }

    protected synchronized int getNextTransactionID() {
        return this.nextTransactionID++;
    }

    protected int closeSession(int sessionID, byte reason) throws IOException {
        AgentXSession<?> session = this.removeSession(sessionID);
        if (session == null || session.isClosed()) {
            return 257;
        }
        session.setClosed(true);
        AgentXResponseEvent<?> resp = this.closeAgentXSession(session);
        if (resp == null || resp.getResponse() == null) {
            return -11;
        }
        return resp.getResponse().getErrorStatus();
    }

    private <A extends Address> AgentXResponseEvent<A> closeAgentXSession(AgentXSession<A> session) throws IOException {
        AgentXClosePDU closePDU = new AgentXClosePDU(5);
        closePDU.setSessionID(session.getSessionID());
        AgentXTarget<A> target = session.createAgentXTarget();
        return this.agentX.send(closePDU, target, session.getPeer().getTransport());
    }

    protected <A extends Address> int openSession(ConnectionOrientedTransportMapping<A> transport, A masterAddress, AgentXSession<A> session) throws IOException {
        AgentXOpenPDU openPDU = new AgentXOpenPDU(0, this.getNextTransactionID(), 0, session.getTimeout(), this.subagentID, this.subagentDescr);
        this.resumeConnecting(masterAddress, transport);
        AgentXResponseEvent<A> responseEvent = this.agentX.send(openPDU, session.createAgentXTarget(), transport);
        if (responseEvent.getResponse() == null) {
            LOGGER.error((Serializable)((Object)("Timeout on connection to master " + String.valueOf(masterAddress))));
        } else {
            if (responseEvent.getResponse() != null) {
                AgentXResponsePDU response = responseEvent.getResponse();
                if (response.getErrorStatus() == 0) {
                    session.setSessionID(response.getSessionID());
                }
                return response.getErrorStatus();
            }
            LOGGER.error((Serializable)((Object)("Received packet on open PDU is not a response AgentX PDU: " + String.valueOf(responseEvent))));
        }
        return -11;
    }

    private static int getResponseStatus(AgentXResponseEvent<?> responseEvent) {
        if (responseEvent.getResponse() == null) {
            LOGGER.error((Serializable)((Object)("Timeout on connection to master " + String.valueOf(responseEvent.getTarget()))));
            return -11;
        }
        if (responseEvent.getResponse() != null) {
            AgentXResponsePDU response = responseEvent.getResponse();
            return response.getErrorStatus();
        }
        LOGGER.error((Serializable)((Object)("Received packet on open PDU is not a response AgentX PDU: " + String.valueOf(responseEvent))));
        return -1;
    }

    public <A extends Address> void disconnect(A masterAddress) throws IOException {
        AgentXPeer<?> peer = this.peers.remove(masterAddress);
        if (peer != null) {
            ConnectionOrientedTransportMapping<?> transport = peer.getTransport();
            transport.suspendAddress(masterAddress);
            transport.close();
        }
    }

    public <A extends Address> boolean resumeConnecting(A masterAddress, ConnectionOrientedTransportMapping<A> transportMapping) {
        return transportMapping.resumeAddress(masterAddress);
    }

    public <A extends Address> boolean resetConnection(A masterAddress, boolean sendClosePdu) {
        AgentXPeer<?> peer = this.peers.get(masterAddress);
        if (peer != null) {
            ArrayList sessionsToClose = new ArrayList();
            for (AgentXSession<?> agentXSession : this.sessions.values()) {
                if (!peer.equals(agentXSession.getPeer())) continue;
                sessionsToClose.add(agentXSession);
            }
            ConnectionOrientedTransportMapping<?> transport = peer.getTransport();
            for (AgentXSession<Object> agentXSession : sessionsToClose) {
                AgentXSession<?> removedSession = this.removeSession(agentXSession.getSessionID());
                agentXSession.setClosed(true);
                if (removedSession == null) continue;
                if (sendClosePdu && transport != null && transport.isListening()) {
                    try {
                        this.closeAgentXSession(removedSession);
                    }
                    catch (IOException e) {
                        LOGGER.error((CharSequence)("IO exception while resetting AgentX session " + String.valueOf(agentXSession) + ": " + e.getMessage()), (Throwable)e);
                    }
                }
                this.sessions.remove(agentXSession.getSessionID());
            }
            try {
                this.disconnect(masterAddress);
                return true;
            }
            catch (IOException e) {
                LOGGER.error((CharSequence)("IO exception on closing connection of transport '" + String.valueOf(transport) + "' to '" + String.valueOf(masterAddress) + "': " + e.getMessage()), (Throwable)e);
            }
        }
        return false;
    }

    public <A extends Address> int connect(A masterAddress, A localAddress, AgentXSession<A> session) throws IOException {
        return this.connect(masterAddress, localAddress, session, null);
    }

    public <A extends Address> int connect(A masterAddress, A localAddress, AgentXSession<A> session, List<TransportStateListener> stateListeners) throws IOException {
        int status;
        Object transport;
        AgentXPeer<?> peer = this.peers.get(masterAddress);
        if (peer == null) {
            transport = this.addMaster(localAddress, stateListeners);
            peer = new AgentXPeer((ConnectionOrientedTransportMapping<?>)transport, masterAddress);
        } else {
            transport = peer.getTransport();
            this.agentX.removeTransportMapping((TransportMapping<?>)transport);
            this.agentX.addTransportMapping((TransportMapping<?>)transport);
            if (!transport.isListening()) {
                transport.listen();
            }
        }
        peer.setTimeout(session.getTimeout());
        session.setPeer(peer);
        try {
            status = this.openSession((ConnectionOrientedTransportMapping<A>)transport, masterAddress, session);
            if (status != -11) {
                this.peers.put(masterAddress, peer);
                LOGGER.info((CharSequence)("Added new peer address=" + String.valueOf(masterAddress) + ",peer=" + String.valueOf(peer)));
            }
        }
        catch (IOException ex) {
            LOGGER.error((Serializable)ex);
            this.removeMaster((TransportMapping<?>)transport);
            return -1;
        }
        if (status == 0) {
            this.sessions.put(session.getSessionID(), session);
            LOGGER.info((CharSequence)("Opened subagent session successfully: " + String.valueOf(session)));
        } else {
            this.removeMaster((TransportMapping<?>)transport);
        }
        return status;
    }

    public int close(AgentXSession<?> session, byte reason) throws IOException {
        return this.closeSession(session.getSessionID(), reason);
    }

    @Override
    public Map<AgentXSession<?>, Integer> closeAllSessions(byte reason) {
        HashMap result = new HashMap(this.sessions.size());
        for (AgentXSession<?> agentXSession : this.sessions.values()) {
            int status;
            try {
                status = this.close(agentXSession, reason);
            }
            catch (IOException e) {
                LOGGER.error((CharSequence)("IO exception while closing AgentX session " + String.valueOf(agentXSession) + ": " + e.getMessage()), (Throwable)e);
                status = -1;
            }
            result.put(agentXSession, status);
        }
        return result;
    }

    private AgentXSession<?> getSession(int sessionID) {
        return this.sessions.get(sessionID);
    }

    private AgentXSession<?> removeSession(int sessionID) {
        return this.sessions.remove(sessionID);
    }

    public void setDefaultPriority(byte priority) {
        this.defaultPriority = priority;
    }

    public byte getDefaultPriority() {
        return this.defaultPriority;
    }

    protected byte getPriority(ManagedObject<?> mo, AgentXRegion region) {
        return this.defaultPriority;
    }

    public void registerRegions(AgentXSession<?> session, OctetString context, TimeTicks sysUpTime, RegistrationCallback registrationCallback) {
        MOServer server = this.getServer(context);
        if (server == null) {
            LOGGER.warn((Serializable)((Object)("No MOServer found for context '" + String.valueOf(context) + "'")));
            return;
        }
        for (Map.Entry e : server) {
            ManagedObject mo = (ManagedObject)e.getValue();
            MOScope scope = (MOScope)e.getKey();
            if (context != null && scope instanceof MOContextScope && !context.equals((Object)((MOContextScope)scope).getContext())) continue;
            if (mo instanceof AgentXSharedMOTable) {
                this.registerSharedTableRows(session, context, registrationCallback, mo);
                continue;
            }
            AgentXRegion region = new AgentXRegion(scope.getLowerBound(), scope.getUpperBound());
            if (mo instanceof MOScalar) {
                region.setSingleOID(true);
            }
            region.setUpperIncluded(scope.isUpperIncluded());
            try {
                int status = this.registerRegion(session, context, region, this.getPriority(mo, region), sysUpTime);
                if (status != 0) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn((Serializable)((Object)("Failed to registered MO " + String.valueOf(scope) + " with status = " + status)));
                    }
                } else if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((CharSequence)("Registered MO " + String.valueOf(scope) + " successfully"));
                }
                if (registrationCallback == null) continue;
                registrationCallback.registrationEvent(context, mo, status);
            }
            catch (IOException ex) {
                LOGGER.warn((Serializable)((Object)("Failed to register " + String.valueOf(mo) + " in context '" + String.valueOf(context) + "' of session " + String.valueOf(session))));
                if (registrationCallback == null) continue;
                registrationCallback.registrationEvent(context, mo, -1);
            }
        }
    }

    private <A extends Address> void registerSharedTableRows(AgentXSession<A> session, OctetString context, RegistrationCallback registrationCallback, ManagedObject<? extends SubRequest<?>> mo) {
        AgentXSharedMOTableSupport<Object, ?> sharedTableSupport = null;
        if (mo instanceof AgentXSharedMutableMOTable) {
            sharedTableSupport = ((AgentXSharedMutableMOTable)mo).getAgentXSharedMOTableSupport();
        }
        String sharedTableSupportKey = session.getSessionID() + "#" + String.valueOf(context);
        if (sharedTableSupport == null) {
            sharedTableSupport = this.sharedMOTableSupport.get(sharedTableSupportKey);
        }
        if (sharedTableSupport == null) {
            sharedTableSupport = this.createSharedTableSupport(session, context);
            this.sharedMOTableSupport.put(sharedTableSupportKey, sharedTableSupport);
        }
        this.registerSharedTableRows(session, context, (AgentXSharedMOTable)mo, registrationCallback, sharedTableSupport);
    }

    protected <R extends MOTableRow, A extends Address> AgentXSharedMOTableSupport<R, ?> createSharedTableSupport(AgentXSession<A> session, OctetString context) {
        return new AgentXSharedMOTableSupport(this.agentX, session, context);
    }

    @Deprecated
    public <R extends MOTableRow, C extends MOColumn<?>, M extends MOTableModel<R>, A extends Address> void registerSharedTableRows(AgentXSession<A> session, OctetString context, AgentXSharedMOTable<R, C, M> mo, RegistrationCallback registrationCallback) {
        this.registerSharedTableRows(session, context, mo, registrationCallback, new AgentXSharedMOTableSupport(this.agentX, session, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MOTableRow, C extends MOColumn<?>, M extends MOTableModel<R>> void registerSharedTableRows(AgentXSession<?> session, OctetString context, AgentXSharedMOTable<R, C, M> mo, RegistrationCallback registrationCallback, AgentXSharedMOTableSupport<R, ?> sharedTableSupport) {
        AgentXSharedMOTable<R, C, M> agentXSharedMOTable = mo;
        synchronized (agentXSharedMOTable) {
            if (mo instanceof AgentXSharedMutableMOTable && ((AgentXSharedMutableMOTable)mo).getAgentXSharedMOTableSupport() == null) {
                ((AgentXSharedMutableMOTable)mo).setAgentXSharedMOTableSupport(sharedTableSupport);
            }
            ArrayList<MOTableRow> rows = new ArrayList<MOTableRow>(mo.getModel().getRowCount());
            Iterator it = mo.getModel().iterator();
            while (it.hasNext()) {
                rows.add((MOTableRow)it.next());
            }
            for (MOTableRow row : rows) {
                OID newIndex;
                int status;
                int retries = 0;
                do {
                    newIndex = (OID)row.getIndex().clone();
                    status = sharedTableSupport.allocateIndex(context, mo.getIndexDef(), (byte)0, newIndex);
                } while (registrationCallback != null && registrationCallback.tableRegistrationEvent(context, mo, row, true, status, retries++));
                if (status == 0) {
                    if (newIndex instanceof AnyNewIndexOID || newIndex instanceof NewIndexOID) {
                        if (!(mo instanceof AgentXSharedMutableMOTable)) break;
                        ((AgentXSharedMutableMOTable)mo).changeRowIndex(row.getIndex(), newIndex);
                        break;
                    }
                    status = sharedTableSupport.registerRow(mo, row);
                    if (status != 0) {
                        sharedTableSupport.deallocateIndex(context, mo.getIndexDef(), row.getIndex());
                        LOGGER.warn((Serializable)((Object)("Failed to register row with " + status + " for " + String.valueOf(row))));
                    }
                    if (registrationCallback == null) continue;
                    registrationCallback.tableRegistrationEvent(context, mo, row, false, status, retries);
                    continue;
                }
                LOGGER.warn((Serializable)((Object)("Failed to allocate index with " + status + " for row " + String.valueOf(row))));
            }
        }
    }

    protected <A extends Address> int registerRegion(AgentXSession<A> session, OctetString context, AgentXRegion region, byte priority, TimeTicks sysUpTime) throws IOException {
        if (session == null || session.isClosed()) {
            return 257;
        }
        long t = this.timeout == 0L ? (long)session.getTimeout() * 1000L : this.timeout;
        AgentXRegisterPDU pdu = new AgentXRegisterPDU(context, region.getLowerBound(), priority, region.getRangeSubID(), region.getUpperBoundSubID());
        pdu.setSessionAttributes(session);
        AgentXResponseEvent<A> event = this.agentX.send(pdu, new AgentXTarget<A>(session.getPeer().getAddress(), t), session.getPeer().getTransport());
        if (sysUpTime != null && event.getResponse() != null) {
            sysUpTime.setValue((long)event.getResponse().getSysUpTime() & 0xFFFFFFFFL);
        }
        return AgentXSubagent.getResponseStatus(event);
    }

    protected <A extends Address> int unregisterRegion(AgentXSession<A> session, OctetString context, AgentXRegion region, byte timeout) throws IOException {
        if (session == null || session.isClosed()) {
            return 257;
        }
        byte t = timeout == 0 ? session.getTimeout() : timeout;
        AgentXUnregisterPDU pdu = new AgentXUnregisterPDU(context, region.getLowerBound(), t, region.getRangeSubID(), region.getUpperBoundSubID());
        pdu.setSessionAttributes(session);
        AgentXResponseEvent<A> event = this.agentX.send(pdu, new AgentXTarget<A>(session.getPeer().getAddress(), this.timeout), session.getPeer().getTransport());
        return AgentXSubagent.getResponseStatus(event);
    }

    protected <A extends Address> ConnectionOrientedTransportMapping<A> addMaster(A localAddress, List<TransportStateListener> stateListeners) throws IOException {
        ConnectionOrientedTransportMapping transport = (ConnectionOrientedTransportMapping)TransportMappings.getInstance().createTransportMapping(localAddress);
        transport.setServerEnabled(false);
        transport.setConnectionTimeout(0L);
        transport.setMessageLengthDecoder((MessageLengthDecoder)new AgentXProtocol());
        if (stateListeners != null) {
            for (TransportStateListener transportStateListener : stateListeners) {
                transport.addTransportStateListener(transportStateListener);
            }
        }
        this.agentX.addTransportMapping((TransportMapping<?>)transport);
        transport.listen();
        return transport;
    }

    protected void removeMaster(TransportMapping<?> transport) {
        this.agentX.removeTransportMapping(transport);
        try {
            transport.close();
        }
        catch (IOException ex) {
            LOGGER.warn((Serializable)((Object)("Closing transport mapping " + String.valueOf(transport) + " failed with: " + ex.getMessage())));
        }
    }

    public synchronized MOServer getServer(OctetString context) {
        MOServer s = this.configManager.getServer(context);
        if (s != null && s.isContextSupported(context)) {
            return s;
        }
        return null;
    }

    public synchronized Collection<OctetString> getContexts() {
        LinkedList<OctetString> allContexts = new LinkedList<OctetString>();
        for (MOServer s : this.configManager.getServers()) {
            OctetString[] contexts = s.getContexts();
            allContexts.addAll(Arrays.asList(contexts));
        }
        return allContexts;
    }

    public void dispatchCommand(AgentXCommandEvent<?> cmd) {
        boolean pendingSessionClose = false;
        if (cmd.getCommand().isConfirmedPDU()) {
            AgentXRequest request = null;
            MOServer server = null;
            byte type = cmd.getCommand().getType();
            switch (type) {
                case 5: {
                    request = (AgentXRequest)this.factory.createRequest(cmd, null);
                    server = this.getServer(request.getContext());
                    this.requestHandlerGet.processPdu((Request)request, server);
                    break;
                }
                case 6: {
                    request = (AgentXRequest)this.factory.createRequest(cmd, null);
                    server = this.getServer(request.getContext());
                    this.requestHandlerGetNext.processPdu((Request)request, server);
                    break;
                }
                case 7: {
                    request = (AgentXRequest)this.factory.createRequest(cmd, null);
                    server = this.getServer(request.getContext());
                    this.requestHandlerGetBulk.processPdu((Request)request, server);
                    break;
                }
                case 8: {
                    request = (AgentXRequest)this.factory.createRequest(cmd, null);
                    request.setPhase(1);
                    server = this.getServer(request.getContext());
                    this.requestHandlerTestSet.processPdu((Request)request, server);
                    this.requestList.put(AgentXSubagent.createRequestID(cmd), request);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    RequestID reqID = AgentXSubagent.createRequestID(cmd);
                    request = this.requestList.get(reqID);
                    if (request == null) {
                        LOGGER.error((Serializable)((Object)("Request with ID " + String.valueOf(reqID) + " not found in request list")));
                        request = new AgentXRequest(cmd);
                        request.setErrorStatus(268);
                        break;
                    }
                    server = this.getServer(request.getContext());
                    switch (type) {
                        case 9: {
                            request.setPhase(2);
                            this.requestHandlerCommitSet.processPdu((Request)request, server);
                            break;
                        }
                        case 10: {
                            request.setPhase(3);
                            this.requestHandlerUndoSet.processPdu((Request)request, server);
                            break;
                        }
                        case 11: {
                            request.setPhase(4);
                            this.requestHandlerCleanupSet.processPdu((Request)request, server);
                            break;
                        }
                        default: {
                            LOGGER.fatal((Object)"Internal error");
                        }
                    }
                    if (cmd.getCommand().getType() == 9) break;
                    this.requestList.remove(reqID);
                    break;
                }
                case 2: {
                    AgentXSession<?> session = this.removeSession(cmd.getCommand().getSessionID());
                    if (session == null) break;
                    session.setClosed(true);
                    pendingSessionClose = true;
                    break;
                }
                default: {
                    LOGGER.error((Serializable)((Object)("Unhandled PDU type: " + String.valueOf(cmd.getCommand()))));
                    request = new AgentXRequest(cmd);
                    request.setErrorStatus(268);
                }
            }
            if (request != null) {
                if (type != 11 && request.isPhaseComplete()) {
                    this.sendResponse(cmd, request);
                }
                if (server != null) {
                    this.release(server, request);
                }
            }
            if (pendingSessionClose) {
                try {
                    this.disconnect((TcpAddress)cmd.getPeerAddress());
                }
                catch (IOException ex) {
                    LOGGER.error((CharSequence)("Failed to disconnect from master at " + String.valueOf(cmd.getPeerAddress()) + ": " + ex.getMessage()), (Throwable)ex);
                }
            }
        } else {
            this.processResponse(cmd);
        }
    }

    protected <A extends Address> void sendResponse(AgentXCommandEvent<A> cmd, AgentXRequest request) {
        AgentXMessageDispatcher dispatcher = cmd.getDispatcher();
        AgentXResponsePDU response = request.getResponsePDU();
        if (response != null) {
            AgentXPDU rpdu = cmd.getCommand();
            response.setSessionID(rpdu.getSessionID());
            response.setTransactionID(rpdu.getTransactionID());
            response.setByteOrder(rpdu.getByteOrder());
            response.setPacketID(rpdu.getPacketID());
            try {
                dispatcher.send(cmd.getPeerTransport(), cmd.getPeerAddress(), response, (PduHandleCallback<AgentXPDU>)null);
            }
            catch (IOException ex) {
                LOGGER.warn((Serializable)((Object)("Failed to send AgentX response to '" + String.valueOf(cmd.getPeerAddress()) + "' with error: " + ex.getMessage())));
            }
        }
    }

    protected void release(MOServer server, AgentXRequest req) {
        Iterator<AgentXRequest.AgentXSubRequest> it = req.iterator();
        while (it.hasNext()) {
            SubRequest sreq = it.next();
            if (sreq.getTargetMO() == null) continue;
            server.unlockNow((Object)req, sreq.getTargetMO());
        }
    }

    private static RequestID createRequestID(AgentXCommandEvent<?> cmd) {
        return new RequestID((Address)cmd.getPeerAddress(), cmd.getCommand().getSessionID(), cmd.getCommand().getTransactionID());
    }

    protected void processResponse(AgentXCommandEvent<?> cmd) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Serializable)((Object)("Received response " + String.valueOf(cmd))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNextSubRequest(AgentXRequest request, MOServer server, OctetString context, AgentXRequest.AgentXSubRequest sreq) throws NoSuchElementException {
        DefaultMOContextScope scope = (DefaultMOContextScope)sreq.getScope();
        MOQuery query = sreq.getQuery();
        if (query == null) {
            query = new MOQueryWithSource((MOContextScope)scope, false, (Object)request);
        }
        LockRequest lockRequest = new LockRequest((Object)request, ((AgentXCommandEvent)request.getSource()).createAgentXPeer().getTimeoutMillis());
        while (!sreq.getStatus().isProcessed()) {
            MOServerLookupEvent lookupEvent = new MOServerLookupEvent((Object)this, null, query, MOServerLookupEvent.IntendedUse.getNext, true);
            sreq.setLookupEvent(lookupEvent);
            GenericManagedObject mo = (GenericManagedObject)server.lookup(query, lockRequest, lookupEvent, GenericManagedObject.class);
            if (mo == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Serializable)((Object)("EndOfMibView at scope=" + String.valueOf(query.getScope()) + " and query " + String.valueOf(query))));
                }
                sreq.getVariableBinding().setVariable((Variable)Null.endOfMibView);
                sreq.getStatus().setPhaseComplete(true);
                break;
            }
            try {
                if (mo.next((SubRequest)sreq)) continue;
                sreq.getVariableBinding().setVariable((Variable)Null.instance);
                scope.subtractScope(mo.getScope());
                query.subtractScope(mo.getScope());
            }
            catch (Exception moex) {
                if (LOGGER.isDebugEnabled()) {
                    moex.printStackTrace();
                }
                LOGGER.warn((Serializable)moex);
                if (sreq.getStatus().getErrorStatus() != 0) continue;
                sreq.getStatus().setErrorStatus(5);
            }
            finally {
                lookupEvent.completedUse((Object)sreq);
                AgentXSubagent.unlockManagedObjectIfLockedByLookup(server, mo, lockRequest);
            }
        }
    }

    public Object notify(OctetString context, OID notificationID, VariableBinding[] vbs) {
        return this.notify(context, notificationID, null, vbs);
    }

    public Object notify(OctetString context, OID notificationID, TimeTicks sysUpTime, VariableBinding[] vbs) {
        AgentXSession<?> session = this.firstSession();
        try {
            AgentXResponseEvent<?> agentXResponse = this.notify(session, context, notificationID, sysUpTime, vbs);
            if (agentXResponse == null || agentXResponse.getResponse() == null) {
                LOGGER.warn((Serializable)((Object)("Timeout on sending notification in context '" + String.valueOf(context) + "' with ID '" + String.valueOf(notificationID) + "' and payload " + String.valueOf(Arrays.asList(vbs)))));
                return null;
            }
            return agentXResponse;
        }
        catch (IOException ex) {
            LOGGER.error((Serializable)((Object)("Failed to send notification in context '" + String.valueOf(context) + "' with ID '" + String.valueOf(notificationID) + "' and payload " + String.valueOf(Arrays.asList(vbs)) + ", reason is: " + ex.getMessage())));
            return null;
        }
    }

    public final AgentXSession<?> firstSession() {
        if (this.sessions.size() > 0) {
            return this.sessions.values().iterator().next();
        }
        return null;
    }

    public <A extends Address> AgentXResponseEvent<A> notify(AgentXSession<A> session, OctetString context, OID notificationID, TimeTicks sysUpTime, VariableBinding[] vbs) throws IOException {
        int offset = 1;
        if (sysUpTime != null) {
            offset = 2;
        }
        VariableBinding[] notifyVBs = new VariableBinding[vbs.length + offset];
        if (sysUpTime != null) {
            notifyVBs[0] = new VariableBinding(SnmpConstants.sysUpTime, (Variable)sysUpTime);
        }
        notifyVBs[offset - 1] = new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)notificationID);
        System.arraycopy(vbs, 0, notifyVBs, offset, vbs.length);
        AgentXNotifyPDU notifyPDU = new AgentXNotifyPDU(context, notifyVBs);
        notifyPDU.setSessionAttributes(session);
        notifyPDU.setTransactionID(this.getNextTransactionID());
        return this.agentX.send(notifyPDU, session.createAgentXTarget(), session.getPeer().getTransport());
    }

    public <A extends Address> int addAgentCaps(AgentXSession<A> session, OctetString context, OID id, OctetString descr) {
        AgentXAddAgentCapsPDU pdu = new AgentXAddAgentCapsPDU(context, id, descr);
        pdu.setSessionAttributes(session);
        try {
            AgentXResponseEvent<A> resp = this.agentX.send(pdu, session.createAgentXTarget(), session.getPeer().getTransport());
            if (resp.getResponse() == null) {
                return -11;
            }
            return resp.getResponse().getErrorStatus();
        }
        catch (IOException ex) {
            LOGGER.error((CharSequence)("Failed to send AgentX AddAgentCaps PDU " + String.valueOf(pdu) + " because: " + ex.getMessage()), (Throwable)ex);
            return 257;
        }
    }

    public <A extends Address> int removeAgentCaps(AgentXSession<A> session, OctetString context, OID id) {
        AgentXRemoveAgentCapsPDU pdu = new AgentXRemoveAgentCapsPDU(context, id);
        pdu.setSessionAttributes(session);
        try {
            AgentXResponseEvent<A> resp = this.agentX.send(pdu, session.createAgentXTarget(), session.getPeer().getTransport());
            return resp.getResponse().getErrorStatus();
        }
        catch (IOException ex) {
            LOGGER.error((CharSequence)("Failed to send AgentX RemoveAgentCaps PDU " + String.valueOf(pdu) + " because: " + ex.getMessage()), (Throwable)ex);
            return 257;
        }
    }

    public void addPingListener(PingListener l) {
        if (this.pingListeners == null) {
            this.pingListeners = new Vector();
        }
        this.pingListeners.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePingListener(PingListener l) {
        if (this.pingListeners != null) {
            Vector<PingListener> vector = this.pingListeners;
            synchronized (vector) {
                this.pingListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePinged(PingEvent<?> event) {
        Vector<PingListener> listeners = this.pingListeners;
        if (listeners != null) {
            Vector<PingListener> vector = listeners;
            synchronized (vector) {
                for (PingListener listener : listeners) {
                    listener.pinged(event);
                }
            }
        }
    }

    private static void initRequestPhase(Request<?, ?, ?> request) {
        if (request.getPhase() == -1) {
            request.nextPhase();
        }
    }

    public void connectionStateChanged(TransportStateEvent transportStateEvent) {
    }

    private ManagedObject<? super AgentXRequest.AgentXSubRequest> lookupManagedObjectFromCachedTargetMO(MOServer server, AgentXRequest.AgentXSubRequest sreq, boolean isWriteAccessIntended, MOServerLookupEvent.IntendedUse intendedUse) {
        ManagedObject mo = sreq.getTargetMO();
        if (mo == null) {
            MOQueryWithSource query = new MOQueryWithSource((MOContextScope)sreq.getScope(), isWriteAccessIntended, (Object)sreq);
            MOServerLookupEvent lookupEvent = new MOServerLookupEvent((Object)this, null, (MOQuery)query, intendedUse, true);
            sreq.setLookupEvent(lookupEvent);
            mo = server.lookup((MOQuery)query, null, lookupEvent, GenericManagedObject.class);
        }
        return mo;
    }

    private static void unlockManagedObjectIfLockedByLookup(MOServer server, ManagedObject<?> mo, LockRequest lockRequest) {
        switch (lockRequest.getLockRequestStatus()) {
            case locked: 
            case lockedAfterTimeout: {
                server.unlock(lockRequest.getLockOwner(), mo);
            }
        }
    }

    static class DefaultAgentXRequestFactory
    implements RequestFactory<AgentXCommandEvent<?>, AgentXResponsePDU, AgentXRequest> {
        DefaultAgentXRequestFactory() {
        }

        public AgentXRequest createRequest(AgentXCommandEvent<?> initiatingEvent, CoexistenceInfo cinfo) {
            AgentXRequest request = new AgentXRequest(initiatingEvent);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Creating AgentX request " + String.valueOf((Object)request) + " from " + String.valueOf(initiatingEvent))));
            }
            return request;
        }
    }

    static class GetRequestHandler
    implements RequestHandler<AgentXRequest> {
        GetRequestHandler() {
        }

        public boolean isSupported(int pduType) {
            return pduType == 5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPdu(AgentXRequest request, MOServer server) {
            AgentXSubagent.initRequestPhase(request);
            LockRequest lockRequest = new LockRequest((Object)request, ((AgentXCommandEvent)request.getSource()).createAgentXPeer().getTimeoutMillis());
            try {
                MOServerLookupEvent lookupEvent;
                AgentXRequest.AgentXSubRequest sreq;
                Iterator<AgentXRequest.AgentXSubRequest> it = request.iterator();
                while (it.hasNext()) {
                    sreq = it.next();
                    MOQueryWithSource query = new MOQueryWithSource((MOContextScope)sreq.getScope(), false, (Object)request);
                    lookupEvent = new MOServerLookupEvent((Object)this, null, (MOQuery)query, MOServerLookupEvent.IntendedUse.get, true);
                    sreq.setLookupEvent(lookupEvent);
                    ManagedObject mo = server.lookup((MOQuery)query, lockRequest, lookupEvent, GenericManagedObject.class);
                    if (mo != null) continue;
                    sreq.getVariableBinding().setVariable((Variable)Null.noSuchObject);
                    sreq.getStatus().setPhaseComplete(true);
                }
                it = request.iterator();
                while (!request.isPhaseComplete() && it.hasNext()) {
                    sreq = it.next();
                    if (sreq.isComplete()) continue;
                    ManagedObject<? super AgentXRequest.AgentXSubRequest> mo = sreq.getTargetMO();
                    lookupEvent = sreq.getLookupEvent();
                    try {
                        mo.get((SubRequest)sreq);
                    }
                    catch (Exception moex) {
                        if (LOGGER.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        LOGGER.warn((Serializable)moex);
                        if (sreq.getStatus().getErrorStatus() != 0) continue;
                        sreq.getStatus().setErrorStatus(5);
                    }
                    finally {
                        if (lookupEvent != null) {
                            lookupEvent.completedUse((Object)sreq);
                        }
                        AgentXSubagent.unlockManagedObjectIfLockedByLookup(server, mo, lockRequest);
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (LOGGER.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                LOGGER.error((Serializable)((Object)"SubRequest not found"));
                request.setErrorStatus(5);
            }
        }
    }

    class CleanupSetHandler
    implements RequestHandler<AgentXRequest> {
        CleanupSetHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPdu(AgentXRequest request, MOServer server) {
            try {
                Iterator<AgentXRequest.AgentXSubRequest> it = request.iterator();
                while (it.hasNext()) {
                    AgentXRequest.AgentXSubRequest sreq = it.next();
                    if (sreq.isComplete()) continue;
                    ManagedObject<? super AgentXRequest.AgentXSubRequest> mo = AgentXSubagent.this.lookupManagedObjectFromCachedTargetMO(server, sreq, false, MOServerLookupEvent.IntendedUse.cleanUp);
                    if (mo == null) {
                        sreq.completed();
                        continue;
                    }
                    MOServerLookupEvent lookupEvent = sreq.getLookupEvent();
                    try {
                        mo.cleanup((SubRequest)sreq);
                        sreq.getStatus().setPhaseComplete(true);
                    }
                    catch (Exception moex) {
                        if (LOGGER.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        LOGGER.error((Serializable)moex);
                    }
                    finally {
                        if (lookupEvent != null && lookupEvent.getIntendedUse() == MOServerLookupEvent.IntendedUse.cleanUp) {
                            lookupEvent.completedUse((Object)sreq);
                        }
                        server.unlock(sreq.getRequest(), mo);
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (LOGGER.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                LOGGER.warn((Serializable)((Object)("Cannot find sub-request: " + nsex.getMessage())));
            }
        }

        public boolean isSupported(int pduType) {
            return pduType == 11;
        }
    }

    class CommitSetHandler
    implements RequestHandler<AgentXRequest> {
        CommitSetHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPdu(AgentXRequest request, MOServer server) {
            try {
                ManagedObject<? super AgentXRequest.AgentXSubRequest> mo;
                AgentXRequest.AgentXSubRequest sreq;
                Iterator<AgentXRequest.AgentXSubRequest> it = request.iterator();
                while (!request.isPhaseComplete() && it.hasNext()) {
                    sreq = it.next();
                    if (sreq.isComplete() || (mo = AgentXSubagent.this.lookupManagedObjectFromCachedTargetMO(server, sreq, true, MOServerLookupEvent.IntendedUse.commit)) != null) continue;
                    sreq.getStatus().setErrorStatus(14);
                }
                it = request.iterator();
                while (!request.isPhaseComplete() && it.hasNext()) {
                    sreq = it.next();
                    if (sreq.isComplete()) continue;
                    mo = sreq.getTargetMO();
                    MOServerLookupEvent lookupEvent = sreq.getLookupEvent();
                    try {
                        mo.commit((SubRequest)sreq);
                        sreq.getStatus().setPhaseComplete(true);
                    }
                    catch (Exception moex) {
                        if (LOGGER.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        LOGGER.error((Serializable)moex);
                        if (sreq.getStatus().getErrorStatus() != 0) continue;
                        sreq.getStatus().setErrorStatus(14);
                    }
                    finally {
                        if (lookupEvent == null || lookupEvent.getIntendedUse() != MOServerLookupEvent.IntendedUse.commit) continue;
                        lookupEvent.completedUse((Object)sreq);
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (LOGGER.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                LOGGER.error((CharSequence)"Cannot find sub-request: ", (Throwable)nsex);
                request.setErrorStatus(5);
            }
        }

        public boolean isSupported(int pduType) {
            return pduType == 9;
        }
    }

    static class TestSetHandler
    implements RequestHandler<AgentXRequest> {
        TestSetHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPdu(AgentXRequest request, MOServer server) {
            try {
                MOServerLookupEvent lookupEvent;
                AgentXRequest.AgentXSubRequest sreq;
                Iterator<AgentXRequest.AgentXSubRequest> it = request.iterator();
                LockRequest lockRequest = new LockRequest((Object)request, ((AgentXCommandEvent)request.getSource()).createAgentXPeer().getTimeoutMillis());
                while (!request.isPhaseComplete() && it.hasNext()) {
                    sreq = it.next();
                    if (sreq.isComplete()) continue;
                    MOQueryWithSource query = new MOQueryWithSource((MOContextScope)sreq.getScope(), true, (Object)request);
                    lookupEvent = new MOServerLookupEvent((Object)this, null, (MOQuery)query, MOServerLookupEvent.IntendedUse.prepare, true);
                    sreq.setLookupEvent(lookupEvent);
                    ManagedObject mo = server.lookup((MOQuery)query, lockRequest, lookupEvent, GenericManagedObject.class);
                    if (mo == null) {
                        sreq.getStatus().setErrorStatus(17);
                        break;
                    }
                    sreq.setTargetMO((ManagedObject<? super AgentXRequest.AgentXSubRequest>)mo);
                    if (lockRequest.getLockRequestStatus() != LockRequest.LockStatus.lockTimedOut) continue;
                    LOGGER.warn((Serializable)((Object)("TestSet request " + String.valueOf((Object)request) + " failed because " + String.valueOf(mo) + " could not be locked")));
                    if (sreq.getStatus().getErrorStatus() != 0) continue;
                    sreq.getStatus().setErrorStatus(5);
                }
                it = request.iterator();
                while (!request.isPhaseComplete() && it.hasNext()) {
                    sreq = it.next();
                    if (sreq.isComplete()) continue;
                    ManagedObject<? super AgentXRequest.AgentXSubRequest> mo = sreq.getTargetMO();
                    lookupEvent = sreq.getLookupEvent();
                    try {
                        mo.prepare((SubRequest)sreq);
                        sreq.getStatus().setPhaseComplete(true);
                        lookupEvent.completedUse((Object)sreq);
                    }
                    catch (Exception moex) {
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(5);
                        }
                        LOGGER.error((CharSequence)("Exception occurred while preparing SET request, returning genErr: " + moex.getMessage()), (Throwable)moex);
                    }
                    finally {
                        lookupEvent.completedUse((Object)sreq);
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (LOGGER.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                LOGGER.error((CharSequence)"Cannot find sub-request: ", (Throwable)nsex);
                request.setErrorStatus(5);
            }
        }

        public boolean isSupported(int pduType) {
            return pduType == 8;
        }
    }

    class UndoSetHandler
    implements RequestHandler<AgentXRequest> {
        UndoSetHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPdu(AgentXRequest request, MOServer server) {
            try {
                ManagedObject<? super AgentXRequest.AgentXSubRequest> mo;
                AgentXRequest.AgentXSubRequest sreq;
                Iterator<AgentXRequest.AgentXSubRequest> it = request.iterator();
                while (it.hasNext()) {
                    sreq = it.next();
                    if (sreq.isComplete() || (mo = AgentXSubagent.this.lookupManagedObjectFromCachedTargetMO(server, sreq, true, MOServerLookupEvent.IntendedUse.undo)) != null) continue;
                    sreq.getStatus().setErrorStatus(15);
                }
                it = request.iterator();
                while (!request.isPhaseComplete() && it.hasNext()) {
                    sreq = it.next();
                    if (sreq.isComplete()) continue;
                    mo = sreq.getTargetMO();
                    MOServerLookupEvent lookupEvent = sreq.getLookupEvent();
                    try {
                        mo.undo((SubRequest)sreq);
                        sreq.getStatus().setPhaseComplete(true);
                    }
                    catch (Exception moex) {
                        if (LOGGER.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        LOGGER.error((Serializable)moex);
                        if (sreq.getStatus().getErrorStatus() != 0) continue;
                        sreq.getStatus().setErrorStatus(15);
                    }
                    finally {
                        if (lookupEvent == null || lookupEvent.getIntendedUse() != MOServerLookupEvent.IntendedUse.undo) continue;
                        lookupEvent.completedUse((Object)sreq);
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (LOGGER.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                LOGGER.error((CharSequence)"Cannot find sub-request: ", (Throwable)nsex);
                request.setErrorStatus(5);
            }
        }

        public boolean isSupported(int pduType) {
            return pduType == 10;
        }
    }

    class GetNextHandler
    implements RequestHandler<AgentXRequest> {
        GetNextHandler() {
        }

        public void processPdu(AgentXRequest request, MOServer server) {
            AgentXSubagent.initRequestPhase(request);
            OctetString context = request.getContext();
            try {
                Iterator<AgentXRequest.AgentXSubRequest> it = request.iterator();
                while (it.hasNext()) {
                    AgentXRequest.AgentXSubRequest sreq = it.next();
                    AgentXSubagent.this.processNextSubRequest(request, server, context, sreq);
                }
            }
            catch (NoSuchElementException nsex) {
                if (LOGGER.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                LOGGER.error((Serializable)((Object)"SubRequest not found"));
                request.setErrorStatus(5);
            }
        }

        public boolean isSupported(int pduType) {
            return pduType == -95;
        }
    }

    class GetBulkHandler
    implements RequestHandler<AgentXRequest> {
        GetBulkHandler() {
        }

        public void processPdu(AgentXRequest request, MOServer server) {
            AgentXSubagent.initRequestPhase(request);
            OctetString context = request.getContext();
            int nonRep = request.getNonRepeaters();
            try {
                AgentXRequest.AgentXSubRequest sreq;
                int i;
                Iterator<AgentXRequest.AgentXSubRequest> it = request.iterator();
                for (i = 0; i < nonRep && it.hasNext(); ++i) {
                    sreq = it.next();
                    AgentXSubagent.this.processNextSubRequest(request, server, context, sreq);
                }
                while (it.hasNext()) {
                    sreq = it.next();
                    AgentXSubagent.this.processNextSubRequest(request, server, context, sreq);
                    ++i;
                }
            }
            catch (NoSuchElementException nsex) {
                if (LOGGER.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                LOGGER.error((Serializable)((Object)"SubRequest not found"));
                request.setErrorStatus(5);
            }
        }

        public boolean isSupported(int pduType) {
            return pduType == -91;
        }
    }

    class PingTask
    extends TimerTask {
        PingTask() {
        }

        @Override
        public void run() {
            LinkedList l = new LinkedList(AgentXSubagent.this.sessions.values());
            for (AgentXSession agentXSession : l) {
                if (agentXSession.isClosed()) continue;
                for (OctetString context : AgentXSubagent.this.getContexts()) {
                    this.ping(agentXSession, context);
                }
            }
        }

        private <A extends Address> void ping(AgentXSession<A> session, OctetString context) {
            PingEvent<A> pingEvent;
            AgentXPingPDU ping = new AgentXPingPDU(context);
            ping.setSessionAttributes(session);
            ping.setTransactionID(AgentXSubagent.this.getNextTransactionID());
            try {
                AgentXPeer<A> agentXPeer = session.getPeer();
                AgentXResponseEvent<A> resp = AgentXSubagent.this.agentX.send(ping, new AgentXTarget<A>(agentXPeer.getAddress(), session.getTimeout() * 1000), agentXPeer.getTransport());
                pingEvent = new PingEvent<A>((Object)this, session, resp.getResponse());
            }
            catch (IOException ex) {
                pingEvent = new PingEvent<A>((Object)this, session, ex);
            }
            AgentXSubagent.this.firePinged(pingEvent);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Fired ping event " + String.valueOf(pingEvent))));
            }
            if (pingEvent.isCloseSession() || pingEvent.isResetSession()) {
                try {
                    AgentXSubagent.this.closeSession(session.getSessionID(), (byte)4);
                    if (pingEvent.isResetSession()) {
                        this.reopenSession(session);
                    }
                }
                catch (IOException ex1) {
                    LOGGER.warn((Serializable)((Object)("IOException while resetting AgentX session in PingTask:" + ex1.getMessage())));
                }
            }
        }

        public <A extends Address> int reopenSession(AgentXSession<A> session) throws IOException {
            return AgentXSubagent.this.openSession(session.getPeer().getTransport(), session.getPeer().getAddress(), session);
        }
    }

    class Command
    implements WorkerTask {
        private final AgentXCommandEvent<?> request;

        public Command(AgentXCommandEvent<?> event) {
            this.request = event;
        }

        public void run() {
            AgentXSubagent.this.dispatchCommand(this.request);
        }

        public void terminate() {
        }

        public void join() throws InterruptedException {
        }

        public void interrupt() {
        }
    }

    protected static class RequestID
    implements Comparable<RequestID> {
        private final Address masterAddress;
        private final int sessionID;
        private final int transactionID;

        public RequestID(Address masterAddress, int sessionID, int transactionID) {
            this.masterAddress = masterAddress;
            this.sessionID = sessionID;
            this.transactionID = transactionID;
        }

        @Override
        public int compareTo(RequestID other) {
            ByteBuffer oa;
            ByteBuffer ma = ByteBuffer.wrap(this.masterAddress.toByteArray());
            int c = ma.compareTo(oa = ByteBuffer.wrap(other.masterAddress.toByteArray()));
            if (c == 0 && (c = this.sessionID - other.sessionID) == 0) {
                c = this.transactionID - other.transactionID;
            }
            return c;
        }

        public boolean equals(Object obj) {
            return obj instanceof RequestID && this.compareTo((RequestID)obj) == 0;
        }

        public int hashCode() {
            return this.transactionID;
        }
    }
}

