/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.snmp4j.agent.agentx.AgentXAddAgentCapsPDU;
import org.snmp4j.agent.agentx.AgentXCleanupSetPDU;
import org.snmp4j.agent.agentx.AgentXClosePDU;
import org.snmp4j.agent.agentx.AgentXCommitSetPDU;
import org.snmp4j.agent.agentx.AgentXGetBulkPDU;
import org.snmp4j.agent.agentx.AgentXGetNextPDU;
import org.snmp4j.agent.agentx.AgentXGetPDU;
import org.snmp4j.agent.agentx.AgentXIndexAllocatePDU;
import org.snmp4j.agent.agentx.AgentXIndexDeallocatePDU;
import org.snmp4j.agent.agentx.AgentXMessageHeader;
import org.snmp4j.agent.agentx.AgentXNotifyPDU;
import org.snmp4j.agent.agentx.AgentXOpenPDU;
import org.snmp4j.agent.agentx.AgentXParseException;
import org.snmp4j.agent.agentx.AgentXPingPDU;
import org.snmp4j.agent.agentx.AgentXProtocol;
import org.snmp4j.agent.agentx.AgentXRegisterPDU;
import org.snmp4j.agent.agentx.AgentXRemoveAgentCapsPDU;
import org.snmp4j.agent.agentx.AgentXResponsePDU;
import org.snmp4j.agent.agentx.AgentXSession;
import org.snmp4j.agent.agentx.AgentXTestSetPDU;
import org.snmp4j.agent.agentx.AgentXUndoSetPDU;
import org.snmp4j.agent.agentx.AgentXUnregisterPDU;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;

public abstract class AgentXPDU
implements Serializable {
    private static final LogAdapter logger = LogFactory.getLogger(AgentXPDU.class);
    public static final byte RESERVED = 0;
    public static final byte AGENTX_OPEN_PDU = 1;
    public static final byte AGENTX_CLOSE_PDU = 2;
    public static final byte AGENTX_REGISTER_PDU = 3;
    public static final byte AGENTX_UNREGISTER_PDU = 4;
    public static final byte AGENTX_GET_PDU = 5;
    public static final byte AGENTX_GETNEXT_PDU = 6;
    public static final byte AGENTX_GETBULK_PDU = 7;
    public static final byte AGENTX_TESTSET_PDU = 8;
    public static final byte AGENTX_COMMITSET_PDU = 9;
    public static final byte AGENTX_UNDOSET_PDU = 10;
    public static final byte AGENTX_CLEANUPSET_PDU = 11;
    public static final byte AGENTX_NOTIFY_PDU = 12;
    public static final byte AGENTX_PING_PDU = 13;
    public static final byte AGENTX_INDEXALLOCATE_PDU = 14;
    public static final byte AGENTX_INDEXDEALLOCATE_PDU = 15;
    public static final byte AGENTX_ADDAGENTCAPS_PDU = 16;
    public static final byte AGENTX_REMOVEAGENTCAPS_PDU = 17;
    public static final byte AGENTX_RESPONSE_PDU = 18;
    private static final long serialVersionUID = -1162042633774482416L;
    protected byte type;
    protected byte version = 1;
    protected int sessionID;
    protected int transactionID;
    protected int packetID;
    protected byte flags;
    protected ByteOrder byteOrder;

    protected AgentXPDU(byte type) {
        this.type = type;
    }

    protected AgentXPDU(byte type, byte flags, int sessionID, int transactionID, int packetID) {
        this.type = type;
        this.flags = flags;
        this.sessionID = sessionID;
        this.transactionID = transactionID;
        this.packetID = packetID;
        this.byteOrder = this.isFlagSet(16) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    protected AgentXPDU(AgentXMessageHeader header) {
        this(header.getType(), header.getFlags(), header.getSessionID(), header.getTransactionID(), header.getPacketID());
    }

    public final void addFlag(byte flag) {
        this.flags = (byte)(this.flags | flag);
    }

    public final boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    public final byte getFlags() {
        return this.flags;
    }

    public final int getPacketID() {
        return this.packetID;
    }

    public final int getSessionID() {
        return this.sessionID;
    }

    public final byte getType() {
        return this.type;
    }

    public final byte getVersion() {
        return this.version;
    }

    public final ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public final int getTransactionID() {
        return this.transactionID;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public void setPacketID(int packetID) {
        this.packetID = packetID;
    }

    public void setSessionID(int sessionID) {
        this.sessionID = sessionID;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setTransactionID(int transactionID) {
        this.transactionID = transactionID;
    }

    public void setSessionAttributes(AgentXSession<?> session) {
        this.setSessionID(session.getSessionID());
        this.setByteOrder(session.getByteOrder());
    }

    protected abstract void encodePayload(ByteBuffer var1);

    public abstract int getPayloadLength();

    public final void encode(ByteBuffer buf) {
        this.beforeEncode();
        buf.put(this.version);
        buf.put(this.type);
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.nativeOrder();
        }
        this.flags = this.byteOrder == ByteOrder.BIG_ENDIAN ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
        buf.order(this.byteOrder);
        buf.put(this.flags);
        buf.put((byte)0);
        buf.putInt(this.sessionID);
        buf.putInt(this.transactionID);
        buf.putInt(this.packetID);
        buf.putInt(this.getPayloadLength());
        this.encodePayload(buf);
    }

    protected abstract void beforeEncode();

    public abstract void decodePayload(ByteBuffer var1, int var2) throws IOException;

    public static AgentXPDU decode(ByteBuffer buf) throws IOException {
        AgentXMessageHeader header = AgentXProtocol.decodeHeader(buf);
        if (buf.remaining() < header.getPayloadLength()) {
            throw new IOException("Short AgentX PDU with payload length=" + header.getPayloadLength() + "<" + buf.remaining() + " remaining length");
        }
        try {
            AgentXPDU pdu = AgentXPDU.createAgentXPDU(header);
            pdu.decodePayload(buf, header.getPayloadLength());
            return pdu;
        }
        catch (IOException iox) {
            logger.warn((Serializable)((Object)("IO Exception while parsing AgentX PDU with header " + String.valueOf((Object)header) + ", exception is: " + iox.getMessage())));
            throw new AgentXParseException(header, iox);
        }
    }

    private static AgentXPDU createAgentXPDU(AgentXMessageHeader header) {
        AgentXPDU pdu = null;
        switch (header.getType()) {
            case 1: {
                pdu = new AgentXOpenPDU(header);
                break;
            }
            case 2: {
                pdu = new AgentXClosePDU(header);
                break;
            }
            case 18: {
                pdu = new AgentXResponsePDU(header);
                break;
            }
            case 16: {
                pdu = new AgentXAddAgentCapsPDU(header);
                break;
            }
            case 11: {
                pdu = new AgentXCleanupSetPDU(header);
                break;
            }
            case 9: {
                pdu = new AgentXCommitSetPDU(header);
                break;
            }
            case 5: {
                pdu = new AgentXGetPDU(header);
                break;
            }
            case 7: {
                pdu = new AgentXGetBulkPDU(header);
                break;
            }
            case 6: {
                pdu = new AgentXGetNextPDU(header);
                break;
            }
            case 14: {
                pdu = new AgentXIndexAllocatePDU(header);
                break;
            }
            case 15: {
                pdu = new AgentXIndexDeallocatePDU(header);
                break;
            }
            case 12: {
                pdu = new AgentXNotifyPDU(header);
                break;
            }
            case 13: {
                pdu = new AgentXPingPDU(header);
                break;
            }
            case 3: {
                pdu = new AgentXRegisterPDU(header);
                break;
            }
            case 17: {
                pdu = new AgentXRemoveAgentCapsPDU(header);
                break;
            }
            case 8: {
                pdu = new AgentXTestSetPDU(header);
                break;
            }
            case 10: {
                pdu = new AgentXUndoSetPDU(header);
                break;
            }
            case 4: {
                pdu = new AgentXUnregisterPDU(header);
                break;
            }
        }
        return pdu;
    }

    public final boolean isConfirmedPDU() {
        return this.getType() != 18;
    }

    protected String toStringExtMembers() {
        return "";
    }

    public String toString() {
        return this.getClass().getName() + "[type=" + this.type + ",version=" + this.version + ",sessionID=" + this.sessionID + ",transactionID=" + this.transactionID + ",packetID=" + this.packetID + ",byteOrder=" + String.valueOf(this.byteOrder) + this.toStringExtMembers() + "]";
    }
}

