/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.snmp4j.agent.agentx.master.index.IndexRegistryEntry;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class AgentXIndexRegistry {
    private static final LogAdapter LOGGER = LogFactory.getLogger(AgentXIndexRegistry.class);
    private final Map<IndexRegistryEntry, IndexRegistryEntry> indexes = Collections.synchronizedMap(new HashMap());

    protected IndexRegistryEntry newIndexRegistryEntry(OctetString context, VariableBinding vb) {
        return new IndexRegistryEntry(context, vb);
    }

    public int allocate(int sessionID, OctetString context, VariableBinding vb, boolean testOnly) {
        try {
            vb.getVariable().toSubIndex(true);
        }
        catch (UnsupportedOperationException ex) {
            return 258;
        }
        IndexRegistryEntry newEntry = this.newIndexRegistryEntry(context, vb);
        IndexRegistryEntry oldEntry = this.indexes.get(newEntry);
        if (oldEntry == null) {
            if (!testOnly) {
                int status = newEntry.allocate(sessionID, vb.getVariable(), testOnly);
                if (status == 0) {
                    this.indexes.put(newEntry, newEntry);
                }
                return status;
            }
            return 0;
        }
        return oldEntry.allocate(sessionID, vb.getVariable(), testOnly);
    }

    public int release(int sessionID, OctetString context, VariableBinding vb, boolean testOnly) {
        IndexRegistryEntry newEntry = this.newIndexRegistryEntry(context, vb);
        IndexRegistryEntry entry = this.indexes.get(newEntry);
        if (entry == null) {
            return 261;
        }
        if (entry.getIndexType().getSyntax() != vb.getSyntax()) {
            return 261;
        }
        return entry.release(sessionID, vb.getVariable(), testOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(int sessionID) {
        Map<IndexRegistryEntry, IndexRegistryEntry> map = this.indexes;
        synchronized (map) {
            for (IndexRegistryEntry entry : this.indexes.values()) {
                entry.release(sessionID);
            }
        }
    }

    public int newIndex(int sessionID, OctetString context, VariableBinding vb, boolean testOnly) {
        Variable v;
        IndexRegistryEntry newEntry = this.newIndexRegistryEntry(context, vb);
        IndexRegistryEntry entry = this.indexes.get(newEntry);
        if (entry == null) {
            entry = this.newIndexRegistryEntry(context, vb);
        }
        if ((v = entry.newIndex(sessionID, testOnly)) == null) {
            return 260;
        }
        if (!testOnly) {
            vb.setVariable(v);
        }
        return 0;
    }

    public int anyIndex(int sessionID, OctetString context, VariableBinding vb, boolean testOnly) {
        Variable v;
        IndexRegistryEntry newEntry = this.newIndexRegistryEntry(context, vb);
        IndexRegistryEntry entry = this.indexes.get(newEntry);
        boolean newEntryCreated = false;
        if (entry == null) {
            entry = this.newIndexRegistryEntry(context, vb);
            newEntryCreated = true;
        }
        if ((v = entry.anyIndex(sessionID, testOnly)) == null) {
            return 260;
        }
        if (!testOnly) {
            vb.setVariable(v);
            if (newEntryCreated) {
                this.indexes.put(entry, entry);
            }
        }
        return 0;
    }
}

