/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master;

import java.io.Serializable;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.agentx.AgentXPeer;
import org.snmp4j.agent.agentx.AgentXSession;
import org.snmp4j.agent.agentx.master.AgentXCommandProcessor;
import org.snmp4j.agent.agentx.master.AgentXMasterEvent;
import org.snmp4j.agent.agentx.master.AgentXMasterListener;
import org.snmp4j.agent.agentx.master.AgentXMasterSession;
import org.snmp4j.agent.agentx.master.AgentXRegEntry;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModelEvent;
import org.snmp4j.agent.mo.MOTableModelListener;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactory;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactoryImpl;
import org.snmp4j.agent.mo.snmp.TimeStampScalar;
import org.snmp4j.agent.mo.snmp.smi.EnumerationConstraint;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraint;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraintValidator;
import org.snmp4j.agent.mo.snmp.tc.TruthValueTC;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.util.IndexGenerator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.ReadonlyVariableCallback;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariantVariable;
import org.snmp4j.smi.VariantVariableCallback;

public class AgentXMib
implements MOGroup,
AgentXMasterListener,
MOTableModelListener {
    private static final LogAdapter LOGGER = LogFactory.getLogger(AgentXMib.class);
    private static final MOFactory moFactory = DefaultMOFactory.getInstance();
    static final OID oidAgentxDefaultTimeout = new OID(new int[]{1, 3, 6, 1, 2, 1, 74, 1, 1, 1, 0});
    static final OID oidAgentxMasterAgentXVer = new OID(new int[]{1, 3, 6, 1, 2, 1, 74, 1, 1, 2, 0});
    static final OID oidAgentxConnTableLastChange = new OID(new int[]{1, 3, 6, 1, 2, 1, 74, 1, 2, 1, 0});
    static final OID oidAgentxSessionTableLastChange = new OID(new int[]{1, 3, 6, 1, 2, 1, 74, 1, 3, 1, 0});
    static final OID oidAgentxRegistrationTableLastChange = new OID(new int[]{1, 3, 6, 1, 2, 1, 74, 1, 4, 1, 0});
    private static final String TC_MODULE_SNMPV2_TC = "SNMPv2-TC";
    private static final String TC_TIMESTAMP = "TimeStamp";
    private final MOScalar<VariantVariable> agentxDefaultTimeout;
    private final MOScalar<Integer32> agentxMasterAgentXVer;
    private final MOScalar<TimeTicks> agentxConnTableLastChange;
    private final MOScalar<TimeTicks> agentxSessionTableLastChange;
    private final MOScalar<TimeTicks> agentxRegistrationTableLastChange;
    static final OID oidAgentxConnectionEntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 74, 1, 2, 2, 1});
    static final int colAgentxConnOpenTime = 2;
    static final int colAgentxConnTransportDomain = 3;
    static final int colAgentxConnTransportAddress = 4;
    static final int idxAgentxConnOpenTime = 0;
    static final int idxAgentxConnTransportDomain = 1;
    static final int idxAgentxConnTransportAddress = 2;
    private static final MOTableSubIndex[] agentxConnectionEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(null, 2, 1, 1)};
    private static final MOTableIndex agentxConnectionEntryIndex = moFactory.createIndex(agentxConnectionEntryIndexes, false);
    private MOTable<AgentxConnectionEntryRow, MOColumn, MOMutableTableModel<AgentxConnectionEntryRow>> agentxConnectionEntry;
    private MOMutableTableModel<AgentxConnectionEntryRow> agentxConnectionEntryModel;
    static final OID oidAgentxSessionEntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 74, 1, 3, 2, 1});
    static final int colAgentxSessionObjectID = 2;
    static final int colAgentxSessionDescr = 3;
    static final int colAgentxSessionAdminStatus = 4;
    static final int colAgentxSessionOpenTime = 5;
    static final int colAgentxSessionAgentXVer = 6;
    static final int colAgentxSessionTimeout = 7;
    static final int idxAgentxSessionObjectID = 0;
    static final int idxAgentxSessionDescr = 1;
    static final int idxAgentxSessionAdminStatus = 2;
    static final int idxAgentxSessionOpenTime = 3;
    static final int idxAgentxSessionAgentXVer = 4;
    static final int idxAgentxSessionTimeout = 5;
    private static final MOTableSubIndex[] agentxSessionEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(null, 2, 1, 1), moFactory.createSubIndex(null, 2, 1, 1)};
    private static final MOTableIndex agentxSessionEntryIndex = moFactory.createIndex(agentxSessionEntryIndexes, false);
    private MOTable<AgentxSessionEntryRow, MOColumn, MOMutableTableModel<AgentxSessionEntryRow>> agentxSessionEntry;
    private MOMutableTableModel<AgentxSessionEntryRow> agentxSessionEntryModel;
    static final OID oidAgentxRegistrationEntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 74, 1, 4, 2, 1});
    static final int colAgentxRegContext = 2;
    static final int colAgentxRegStart = 3;
    static final int colAgentxRegRangeSubId = 4;
    static final int colAgentxRegUpperBound = 5;
    static final int colAgentxRegPriority = 6;
    static final int colAgentxRegTimeout = 7;
    static final int colAgentxRegInstance = 8;
    static final int idxAgentxRegContext = 0;
    static final int idxAgentxRegStart = 1;
    static final int idxAgentxRegRangeSubId = 2;
    static final int idxAgentxRegUpperBound = 3;
    static final int idxAgentxRegPriority = 4;
    static final int idxAgentxRegTimeout = 5;
    static final int idxAgentxRegInstance = 6;
    private static final MOTableSubIndex[] agentxRegistrationEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(null, 2, 1, 1), moFactory.createSubIndex(null, 2, 1, 1), moFactory.createSubIndex(null, 2, 1, 1)};
    private static final MOTableIndex agentxRegistrationEntryIndex = moFactory.createIndex(agentxRegistrationEntryIndexes, false);
    private MOTable<AgentxRegistrationEntryRow, MOColumn, MOMutableTableModel<AgentxRegistrationEntryRow>> agentxRegistrationEntry;
    private MOMutableTableModel<AgentxRegistrationEntryRow> agentxRegistrationEntryModel;
    private AgentXCommandProcessor agentXProcessor;
    private final IndexGenerator connIndexGenerator = new IndexGenerator((Variable)new UnsignedInteger32(1));
    private final IndexGenerator regEntryIndexGenerator = new IndexGenerator((Variable)new UnsignedInteger32(1));
    private final TDomainAddressFactory addrFactory = new TDomainAddressFactoryImpl();

    protected AgentXMib() {
        this.agentxDefaultTimeout = moFactory.createScalar(oidAgentxDefaultTimeout, MOAccessImpl.ACCESS_READ_ONLY, (Variable)new VariantVariable((Variable)new Integer32()));
        this.agentxDefaultTimeout.setVolatile(true);
        this.agentxMasterAgentXVer = moFactory.createScalar(oidAgentxMasterAgentXVer, MOAccessImpl.ACCESS_READ_ONLY, (Variable)new Integer32());
        this.agentxMasterAgentXVer.setVolatile(true);
        this.agentxConnTableLastChange = moFactory.createScalar(oidAgentxConnTableLastChange, MOAccessImpl.ACCESS_READ_ONLY, (Variable)new TimeTicks(), TC_MODULE_SNMPV2_TC, TC_TIMESTAMP);
        this.agentxConnTableLastChange.setVolatile(true);
        this.agentxSessionTableLastChange = moFactory.createScalar(oidAgentxSessionTableLastChange, MOAccessImpl.ACCESS_READ_ONLY, (Variable)new TimeTicks(), TC_MODULE_SNMPV2_TC, TC_TIMESTAMP);
        this.agentxSessionTableLastChange.setVolatile(true);
        this.agentxRegistrationTableLastChange = moFactory.createScalar(oidAgentxRegistrationTableLastChange, MOAccessImpl.ACCESS_READ_ONLY, (Variable)new TimeTicks(), TC_MODULE_SNMPV2_TC, TC_TIMESTAMP);
        this.agentxRegistrationTableLastChange.setVolatile(true);
        this.createAgentxConnectionEntry();
        this.createAgentxSessionEntry();
        this.createAgentxRegistrationEntry();
    }

    public AgentXMib(AgentXCommandProcessor agentXProcessor) {
        this();
        this.agentXProcessor = agentXProcessor;
        ReadonlyVariableCallback agentxDefaultTimeoutCallback = new ReadonlyVariableCallback(){

            public void updateVariable(VariantVariable variable) {
                variable.setValue((int)AgentXMib.this.agentXProcessor.getDefaultTimeout());
            }
        };
        this.agentxDefaultTimeout.setValue((Variable)new VariantVariable((Variable)new Integer32(), (VariantVariableCallback)agentxDefaultTimeoutCallback));
        this.agentxMasterAgentXVer.setValue((Variable)new Integer32((int)agentXProcessor.getAgentXVersion()));
        ((DefaultMOMutableTableModel)this.agentxConnectionEntryModel).addMOTableModelListener((MOTableModelListener)this);
        ((DefaultMOMutableTableModel)this.agentxSessionEntryModel).addMOTableModelListener((MOTableModelListener)this);
        ((DefaultMOMutableTableModel)this.agentxRegistrationEntryModel).addMOTableModelListener((MOTableModelListener)this);
    }

    public MOTable<AgentxConnectionEntryRow, MOColumn, MOMutableTableModel<AgentxConnectionEntryRow>> getAgentxConnectionEntry() {
        return this.agentxConnectionEntry;
    }

    private void createAgentxConnectionEntry() {
        MOColumn[] agentxConnectionEntryColumns = new MOColumn[]{moFactory.createColumn(2, 67, MOAccessImpl.ACCESS_READ_ONLY), moFactory.createColumn(3, 6, MOAccessImpl.ACCESS_READ_ONLY), moFactory.createColumn(4, 4, MOAccessImpl.ACCESS_READ_ONLY)};
        this.agentxConnectionEntryModel = new DefaultMOMutableTableModel();
        this.agentxConnectionEntryModel.setRowFactory((MOTableRowFactory)new AgentxConnectionEntryRowFactory());
        this.agentxConnectionEntry = moFactory.createTable(oidAgentxConnectionEntry, agentxConnectionEntryIndex, agentxConnectionEntryColumns, this.agentxConnectionEntryModel);
        if (this.agentxConnectionEntry instanceof DefaultMOTable) {
            ((DefaultMOTable)this.agentxConnectionEntry).setVolatile(true);
        }
    }

    public MOTable<AgentxSessionEntryRow, MOColumn, MOMutableTableModel<AgentxSessionEntryRow>> getAgentxSessionEntry() {
        return this.agentxSessionEntry;
    }

    private void createAgentxSessionEntry() {
        MOColumn[] agentxSessionEntryColumns = new MOColumn[6];
        agentxSessionEntryColumns[0] = moFactory.createColumn(2, 6, MOAccessImpl.ACCESS_READ_ONLY);
        agentxSessionEntryColumns[1] = moFactory.createColumn(3, 4, MOAccessImpl.ACCESS_READ_ONLY);
        agentxSessionEntryColumns[2] = new Enumerated(4, 2, MOAccessImpl.ACCESS_READ_WRITE, null, true);
        EnumerationConstraint agentxSessionAdminStatusVC = new EnumerationConstraint(new int[]{1, 2});
        ((MOMutableColumn)agentxSessionEntryColumns[2]).addMOValueValidationListener((MOValueValidationListener)new ValueConstraintValidator((ValueConstraint)agentxSessionAdminStatusVC));
        ((MOMutableColumn)agentxSessionEntryColumns[2]).addMOValueValidationListener((MOValueValidationListener)new AgentxSessionAdminStatusValidator());
        agentxSessionEntryColumns[3] = moFactory.createColumn(5, 67, MOAccessImpl.ACCESS_READ_ONLY);
        agentxSessionEntryColumns[4] = moFactory.createColumn(6, 2, MOAccessImpl.ACCESS_READ_ONLY);
        agentxSessionEntryColumns[5] = moFactory.createColumn(7, 2, MOAccessImpl.ACCESS_READ_ONLY);
        this.agentxSessionEntryModel = new DefaultMOMutableTableModel();
        this.agentxSessionEntryModel.setRowFactory((MOTableRowFactory)new AgentxSessionEntryRowFactory());
        this.agentxSessionEntry = moFactory.createTable(oidAgentxSessionEntry, agentxSessionEntryIndex, agentxSessionEntryColumns, this.agentxSessionEntryModel);
        if (this.agentxSessionEntry instanceof DefaultMOTable) {
            ((DefaultMOTable)this.agentxSessionEntry).setVolatile(true);
        }
    }

    public MOTable<AgentxRegistrationEntryRow, MOColumn, MOMutableTableModel<AgentxRegistrationEntryRow>> getAgentxRegistrationEntry() {
        return this.agentxRegistrationEntry;
    }

    private void createAgentxRegistrationEntry() {
        MOColumn[] agentxRegistrationEntryColumns = new MOColumn[]{moFactory.createColumn(2, 4, MOAccessImpl.ACCESS_READ_ONLY), moFactory.createColumn(3, 6, MOAccessImpl.ACCESS_READ_ONLY), moFactory.createColumn(4, 66, MOAccessImpl.ACCESS_READ_ONLY), moFactory.createColumn(5, 66, MOAccessImpl.ACCESS_READ_ONLY), moFactory.createColumn(6, 66, MOAccessImpl.ACCESS_READ_ONLY), moFactory.createColumn(7, 2, MOAccessImpl.ACCESS_READ_ONLY), moFactory.createColumn(8, 2, MOAccessImpl.ACCESS_READ_ONLY)};
        this.agentxRegistrationEntryModel = new DefaultMOMutableTableModel();
        this.agentxRegistrationEntryModel.setRowFactory((MOTableRowFactory)new AgentxRegistrationEntryRowFactory());
        this.agentxRegistrationEntry = moFactory.createTable(oidAgentxRegistrationEntry, agentxRegistrationEntryIndex, agentxRegistrationEntryColumns, this.agentxRegistrationEntryModel);
        if (this.agentxRegistrationEntry instanceof DefaultMOTable) {
            ((DefaultMOTable)this.agentxRegistrationEntry).setVolatile(true);
        }
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.agentxDefaultTimeout, context);
        server.register(this.agentxMasterAgentXVer, context);
        server.register(this.agentxConnTableLastChange, context);
        server.register(this.agentxSessionTableLastChange, context);
        server.register(this.agentxRegistrationTableLastChange, context);
        server.register(this.agentxConnectionEntry, context);
        server.register(this.agentxSessionEntry, context);
        server.register(this.agentxRegistrationEntry, context);
        ((TimeStampScalar)this.agentxConnTableLastChange).setSysUpTime(SNMPv2MIB.getSysUpTime((OctetString)context));
        ((TimeStampScalar)this.agentxSessionTableLastChange).setSysUpTime(SNMPv2MIB.getSysUpTime((OctetString)context));
        ((TimeStampScalar)this.agentxRegistrationTableLastChange).setSysUpTime(SNMPv2MIB.getSysUpTime((OctetString)context));
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.agentxDefaultTimeout, context);
        server.unregister(this.agentxMasterAgentXVer, context);
        server.unregister(this.agentxConnTableLastChange, context);
        server.unregister(this.agentxSessionTableLastChange, context);
        server.unregister(this.agentxRegistrationTableLastChange, context);
        server.unregister(this.agentxConnectionEntry, context);
        server.unregister(this.agentxSessionEntry, context);
        server.unregister(this.agentxRegistrationEntry, context);
    }

    @Override
    public void masterChanged(AgentXMasterEvent event) {
        switch (event.getType()) {
            case 1: {
                AgentXPeer changedPeer = (AgentXPeer)event.getChangedObject();
                Object addr = changedPeer.getAddress();
                AgentxConnectionEntryRow row = (AgentxConnectionEntryRow)this.agentxConnectionEntry.createRow(this.connIndexGenerator.getNextSubIndex());
                this.agentxConnectionEntry.addRow((MOTableRow)row);
                row.setAgentxConnOpenTime(((TimeStampScalar)this.agentxConnTableLastChange).getSysUpTime().get());
                row.setAgentxConnTransportAddress(this.addrFactory.getAddress(addr));
                row.setAgentxConnTransportDomain(this.addrFactory.getTransportDomain(addr)[0]);
                changedPeer.setId(row.getIndex());
                break;
            }
            case 2: {
                AgentXPeer changedPeer = (AgentXPeer)event.getChangedObject();
                if (changedPeer == null) break;
                OID index = (OID)changedPeer.getId();
                OID next = index.nextPeer();
                this.agentxConnectionEntry.removeRow(index);
                ((DefaultMOMutableTableModel)this.agentxSessionEntryModel).removeRows(index, next);
                ((DefaultMOMutableTableModel)this.agentxRegistrationEntryModel).removeRows(index, next);
                break;
            }
            case 3: {
                AgentXMasterSession session = (AgentXMasterSession)event.getChangedObject();
                OID index = new OID((OID)session.getPeer().getId());
                index.append(session.getSessionID());
                AgentxSessionEntryRow row = (AgentxSessionEntryRow)this.agentxSessionEntry.createRow(index);
                row.setAgentxSessionAdminStatus(new Integer32(1));
                row.setAgentxSessionAgentXVer(new Integer32(session.getAgentXVersion()));
                row.setAgentxSessionDescr(session.getDescr());
                row.setAgentxSessionObjectID(session.getOid());
                row.setAgentxSessionOpenTime(((TimeStampScalar)this.agentxSessionTableLastChange).getSysUpTime().get());
                row.setAgentxSessionTimeout(new Integer32(session.getTimeout() & 0xFF));
                row.setSession(session);
                this.agentxSessionEntry.addRow((MOTableRow)row);
                break;
            }
            case 4: {
                AgentXMasterSession session = (AgentXMasterSession)event.getChangedObject();
                OID index = new OID((OID)session.getPeer().getId());
                index.append(session.getSessionID());
                this.agentxSessionEntry.removeRow(index);
                break;
            }
            case 5: {
                AgentXRegEntry entry = (AgentXRegEntry)event.getChangedObject();
                AgentXMasterSession session = entry.getSession();
                AgentXPeer peer = session.getPeer();
                if (peer.getId() == null) {
                    LOGGER.error((Serializable)((Object)("Peer ID is null for peer " + peer + ", cannot add registration " + entry + " to AgentXMIB")));
                    break;
                }
                OID index = new OID((OID)peer.getId());
                index.append(session.getSessionID());
                index.append(this.regEntryIndexGenerator.getNextSubIndex());
                entry.setId(index);
                AgentxRegistrationEntryRow row = (AgentxRegistrationEntryRow)this.agentxRegistrationEntry.createRow(index);
                row.setAgentxRegContext(entry.getContext());
                Integer32 singleOID = TruthValueTC.getValue((boolean)entry.getRegion().isSingleOID());
                row.setAgentxRegInstance(singleOID);
                row.setAgentxRegPriority(new UnsignedInteger32(entry.getPriority()));
                row.setAgentxRegRangeSubId(new UnsignedInteger32(entry.getRegion().getRangeSubID()));
                row.setAgentxRegStart(entry.getRegion().getLowerBound());
                row.setAgentxRegTimeout(new Integer32(entry.getTimeout()));
                row.setAgentxRegUpperBound(new UnsignedInteger32(entry.getRegion().getUpperBoundSubID()));
                this.agentxRegistrationEntry.addRow((MOTableRow)row);
                break;
            }
            case 6: {
                AgentXRegEntry entry = (AgentXRegEntry)event.getChangedObject();
                OID index = entry.getId();
                if (index == null) {
                    LOGGER.warn((Serializable)((Object)("Registration has been removed that was not previously added to the AgentXMib: " + entry)));
                    break;
                }
                this.agentxRegistrationEntry.removeRow(index);
                break;
            }
            case -5: 
            case -3: {
                break;
            }
            default: {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Serializable)((Object)("Unrecognized master change event: " + event)));
            }
        }
    }

    public void tableModelChanged(MOTableModelEvent changeEvent) {
        Object source = changeEvent.getSource();
        if (source.equals(this.agentxConnectionEntryModel)) {
            ((TimeStampScalar)this.agentxConnTableLastChange).update();
        } else if (source.equals(this.agentxSessionEntryModel)) {
            ((TimeStampScalar)this.agentxSessionTableLastChange).update();
        } else if (source.equals(this.agentxRegistrationEntryModel)) {
            ((TimeStampScalar)this.agentxRegistrationTableLastChange).update();
        }
    }

    class AgentxRegistrationEntryRow
    extends DefaultMOMutableRow2PC {
        public AgentxRegistrationEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getAgentxRegContext() {
            return (OctetString)this.getValue(0);
        }

        public void setAgentxRegContext(OctetString newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public OID getAgentxRegStart() {
            return (OID)this.getValue(1);
        }

        public void setAgentxRegStart(OID newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public UnsignedInteger32 getAgentxRegRangeSubId() {
            return (UnsignedInteger32)this.getValue(2);
        }

        public void setAgentxRegRangeSubId(UnsignedInteger32 newValue) {
            this.setValue(2, (Variable)newValue);
        }

        public UnsignedInteger32 getAgentxRegUpperBound() {
            return (UnsignedInteger32)this.getValue(3);
        }

        public void setAgentxRegUpperBound(UnsignedInteger32 newValue) {
            this.setValue(3, (Variable)newValue);
        }

        public UnsignedInteger32 getAgentxRegPriority() {
            return (UnsignedInteger32)this.getValue(4);
        }

        public void setAgentxRegPriority(UnsignedInteger32 newValue) {
            this.setValue(4, (Variable)newValue);
        }

        public Integer32 getAgentxRegTimeout() {
            return (Integer32)this.getValue(5);
        }

        public void setAgentxRegTimeout(Integer32 newValue) {
            this.setValue(5, (Variable)newValue);
        }

        public Integer32 getAgentxRegInstance() {
            return (Integer32)this.getValue(6);
        }

        public void setAgentxRegInstance(Integer32 newValue) {
            this.setValue(6, (Variable)newValue);
        }
    }

    class AgentxRegistrationEntryRowFactory
    implements MOTableRowFactory<AgentxRegistrationEntryRow> {
        AgentxRegistrationEntryRowFactory() {
        }

        public synchronized AgentxRegistrationEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            AgentxRegistrationEntryRow row = new AgentxRegistrationEntryRow(index, values);
            return row;
        }

        public synchronized void freeRow(AgentxRegistrationEntryRow row) {
        }
    }

    class AgentxSessionEntryRow
    extends DefaultMOMutableRow2PC {
        private AgentXSession<?> session;

        public AgentxSessionEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OID getAgentxSessionObjectID() {
            return (OID)this.getValue(0);
        }

        public void setAgentxSessionObjectID(OID newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public OctetString getAgentxSessionDescr() {
            return (OctetString)this.getValue(1);
        }

        public void setAgentxSessionDescr(OctetString newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public Integer32 getAgentxSessionAdminStatus() {
            return (Integer32)this.getValue(2);
        }

        public void setAgentxSessionAdminStatus(Integer32 newValue) {
            this.setValue(2, (Variable)newValue);
        }

        public TimeTicks getAgentxSessionOpenTime() {
            return (TimeTicks)this.getValue(3);
        }

        public void setAgentxSessionOpenTime(TimeTicks newValue) {
            this.setValue(3, (Variable)newValue);
        }

        public Integer32 getAgentxSessionAgentXVer() {
            return (Integer32)this.getValue(4);
        }

        public void setAgentxSessionAgentXVer(Integer32 newValue) {
            this.setValue(4, (Variable)newValue);
        }

        public Integer32 getAgentxSessionTimeout() {
            return (Integer32)this.getValue(5);
        }

        public void setAgentxSessionTimeout(Integer32 newValue) {
            this.setValue(5, (Variable)newValue);
        }

        public void setSession(AgentXSession<?> session) {
            this.session = session;
        }

        public AgentXSession<?> getSession() {
            return this.session;
        }

        public void commitRow(SubRequest<?> req, MOTableRow row) {
            Integer32 adminStatus = (Integer32)row.getValue(2);
            if (adminStatus != null && adminStatus.getValue() == 2) {
                AgentXMib.this.agentXProcessor.closeSession((AgentXMasterSession)this.session, (byte)6);
            }
        }
    }

    class AgentxSessionEntryRowFactory
    implements MOTableRowFactory<AgentxSessionEntryRow> {
        AgentxSessionEntryRowFactory() {
        }

        public synchronized AgentxSessionEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            AgentxSessionEntryRow row = new AgentxSessionEntryRow(index, values);
            return row;
        }

        public synchronized void freeRow(AgentxSessionEntryRow row) {
        }
    }

    class AgentxConnectionEntryRow
    extends DefaultMOMutableRow2PC {
        public AgentxConnectionEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public TimeTicks getAgentxConnOpenTime() {
            return (TimeTicks)this.getValue(0);
        }

        public void setAgentxConnOpenTime(TimeTicks newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public OID getAgentxConnTransportDomain() {
            return (OID)this.getValue(1);
        }

        public void setAgentxConnTransportDomain(OID newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public OctetString getAgentxConnTransportAddress() {
            return (OctetString)this.getValue(2);
        }

        public void setAgentxConnTransportAddress(OctetString newValue) {
            this.setValue(2, (Variable)newValue);
        }
    }

    class AgentxConnectionEntryRowFactory
    implements MOTableRowFactory<AgentxConnectionEntryRow> {
        AgentxConnectionEntryRowFactory() {
        }

        public synchronized AgentxConnectionEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            AgentxConnectionEntryRow row = new AgentxConnectionEntryRow(index, values);
            return row;
        }

        public synchronized void freeRow(AgentxConnectionEntryRow row) {
        }
    }

    public static final class AgentxSessionAdminStatusEnum {
        public static final int up = 1;
        public static final int down = 2;
    }

    static class AgentxSessionAdminStatusValidator
    implements MOValueValidationListener {
        AgentxSessionAdminStatusValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }
}

