/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.snmp4j.agent.agentx.AgentXContextPDU;
import org.snmp4j.agent.agentx.AgentXMessageHeader;
import org.snmp4j.agent.agentx.AgentXProtocol;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class AgentXAddAgentCapsPDU
extends AgentXContextPDU {
    private static final long serialVersionUID = 5612445856184490038L;
    private OID id;
    private OctetString descr;

    public AgentXAddAgentCapsPDU(AgentXMessageHeader header) {
        super(header);
        if (header.getType() != 16) {
            throw new IllegalArgumentException();
        }
    }

    public AgentXAddAgentCapsPDU(OctetString context, OID id, OctetString descr) {
        super((byte)16, context);
        this.id = id;
        this.descr = descr;
    }

    @Override
    public void decodeAfterContext(ByteBuffer buf, int length) throws IOException {
        this.id = new OID();
        AgentXProtocol.decodeOID(buf, this.id);
        this.descr = AgentXProtocol.decodeOctetString(buf);
    }

    @Override
    public void encodeAfterContext(ByteBuffer buf) {
        AgentXProtocol.encodeOID(buf, this.id, false);
        AgentXProtocol.encodeOctetString(buf, this.descr);
    }

    @Override
    public int getAfterContextLength() {
        return AgentXProtocol.getOIDLength(this.id) + AgentXProtocol.getOctetStringLength(this.descr.length());
    }

    public OctetString getDescr() {
        return this.descr;
    }

    public OID getId() {
        return this.id;
    }

    public void setDescr(OctetString descr) {
        this.descr = descr;
    }

    public void setId(OID id) {
        this.id = id;
    }
}

