/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mox;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public abstract class BufferedMOTableModel<R extends MOTableRow>
implements MOTableModel<R> {
    protected final SortedMap<OID, BufferedMOTableRow<R>> bufferedRows = Collections.synchronizedSortedMap(new TreeMap());
    protected final List<BufferedMOTableRow<R>> bufferedChunksList = Collections.synchronizedList(new LinkedList());
    protected BufferedMOTableRow<R> firstRow;
    protected BufferedMOTableRow<R> lastRow;
    protected MOTableRowFactory<R> rowFactory;
    protected int columnCount = 0;
    protected long bufferTimeoutNanoSeconds = 5000000000L;
    protected int chunkSize = 10;
    protected int maxBufferSize = 100;
    protected long bufferHits = 0L;
    protected long bufferMisses = 0L;

    protected BufferedMOTableModel(MOTableRowFactory<R> rowFactory) {
        this.rowFactory = rowFactory;
    }

    public void setRowFactory(MOTableRowFactory<R> rowFactory) {
        this.rowFactory = rowFactory;
    }

    public MOTableRowFactory<R> getRowFactory() {
        return this.rowFactory;
    }

    public long getBufferTimeoutNanoSeconds() {
        return this.bufferTimeoutNanoSeconds;
    }

    public void setBufferTimeoutNanoSeconds(long bufferTimeoutNanoSeconds) {
        this.bufferTimeoutNanoSeconds = bufferTimeoutNanoSeconds;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public abstract int getRowCount();

    public abstract boolean containsRow(OID var1);

    public R getRow(OID index) {
        return this.getRow(index, true);
    }

    protected R getRow(OID index, boolean putRowIntoBuffer) {
        BufferedMOTableRow row = this.getRowFromBuffer(index);
        if (row == null) {
            ++this.bufferMisses;
            Variable[] rowValues = this.fetchRow(index);
            if (rowValues != null) {
                MOTableRow r = this.rowFactory.createRow(index, rowValues);
                row = new BufferedMOTableRow(this, r);
            } else {
                row = new BufferedMOTableRow(this, null);
            }
            if (putRowIntoBuffer) {
                this.bufferedRows.put(index, row);
            }
        } else {
            ++this.bufferHits;
        }
        return row.getBufferedRow();
    }

    public Iterator<R> iterator() {
        return this.tailIterator(null);
    }

    public Iterator<R> tailIterator(OID lowerBound) {
        return new RowBufferIterator(lowerBound);
    }

    public abstract OID lastIndex();

    public abstract OID firstIndex();

    public R firstRow() {
        BufferedMOTableRow<R> firstBufferRow = this.getFirstBufferRow();
        if (firstBufferRow != null) {
            return firstBufferRow.getBufferedRow();
        }
        return null;
    }

    protected synchronized BufferedMOTableRow<R> getFirstBufferRow() {
        OID firstIndex;
        if (this.firstRow != null) {
            if (this.isRowValid(this.firstRow.getLastRefresh())) {
                return this.firstRow;
            }
            this.bufferedRows.remove(this.firstRow.getIndex());
        }
        if ((firstIndex = this.firstIndex()) != null) {
            R row = this.getRow(firstIndex, true);
            if (row != null) {
                this.firstRow = this.getRowFromBuffer(firstIndex);
            }
            return this.firstRow;
        }
        return null;
    }

    public R lastRow() {
        BufferedMOTableRow<R> lastBufferRow = this.getLastBufferRow();
        if (lastBufferRow != null) {
            return lastBufferRow.getBufferedRow();
        }
        return null;
    }

    protected synchronized BufferedMOTableRow<R> getLastBufferRow() {
        OID lastIndex;
        if (this.lastRow != null) {
            if (this.isRowValid(this.lastRow.getLastRefresh())) {
                return this.lastRow;
            }
            this.bufferedRows.remove(this.lastRow.getIndex());
        }
        if ((lastIndex = this.lastIndex()) != null) {
            R row = this.getRow(lastIndex, false);
            if (row != null) {
                this.lastRow = this.getRowFromBuffer(lastIndex);
            }
            return this.lastRow;
        }
        return null;
    }

    protected boolean isRowValid(long lastRefreshNanoTime) {
        return System.nanoTime() - lastRefreshNanoTime < this.bufferTimeoutNanoSeconds;
    }

    protected BufferedMOTableRow<R> getRowFromBuffer(OID index) {
        BufferedMOTableRow row = (BufferedMOTableRow)this.bufferedRows.get(index);
        if (row != null) {
            if (!this.isRowValid(row.getLastRefresh())) {
                this.bufferedRows.remove(index);
                return null;
            }
            return row;
        }
        return null;
    }

    protected abstract Variable[] fetchRow(OID var1);

    protected abstract List<R> fetchNextRows(OID var1, int var2);

    public R removeRow(OID index) {
        throw new UnsupportedOperationException();
    }

    protected BufferedMOTableRow<R> updateBuffer(List<R> newBufferRows, BufferedMOTableRow<R> predecessor) {
        BufferedMOTableRow firstBufferRow = null;
        BufferedMOTableRow lastBufferRow = null;
        for (MOTableRow row : newBufferRows) {
            BufferedMOTableRow bufferRow = new BufferedMOTableRow(this, row);
            this.bufferedRows.put(row.getIndex(), bufferRow);
            if (lastBufferRow != null) {
                lastBufferRow.setNextRow(bufferRow);
            }
            if (firstBufferRow == null) {
                firstBufferRow = bufferRow;
                if (predecessor != null) {
                    predecessor.setNextRow(firstBufferRow);
                }
            }
            lastBufferRow = bufferRow;
        }
        if (firstBufferRow != null) {
            this.bufferedChunksList.add(firstBufferRow);
        }
        if (this.bufferedRows.size() > this.maxBufferSize) {
            this.cleanupBuffer();
        }
        return firstBufferRow;
    }

    protected synchronized int cleanupBuffer() {
        int removed = 0;
        int oversize = this.bufferedRows.size() - this.maxBufferSize;
        if (oversize > 0) {
            for (int i = oversize; i >= 0 && !this.bufferedChunksList.isEmpty(); --i) {
                BufferedMOTableRow<R> disposeRow = this.bufferedChunksList.remove(0);
                if (disposeRow == null) continue;
                this.bufferedRows.remove(disposeRow.getIndex());
                ++removed;
                for (disposeRow = disposeRow.getNextRow(); disposeRow != null && --i > 0; disposeRow = disposeRow.getNextRow()) {
                    this.bufferedRows.remove(disposeRow.getIndex());
                    if (!this.bufferedChunksList.isEmpty() && disposeRow.getIndex().equals((Object)this.bufferedChunksList.get(0).getIndex())) {
                        this.bufferedChunksList.remove(0);
                    }
                    ++removed;
                }
            }
        }
        return removed;
    }

    public long getBufferHits() {
        return this.bufferHits;
    }

    public long getBufferMisses() {
        return this.bufferMisses;
    }

    public synchronized void resetBuffer() {
        this.bufferedRows.clear();
        this.bufferedChunksList.clear();
        this.firstRow = null;
        this.lastRow = null;
    }

    public String toString() {
        return "BufferedMOTableModel{columnCount=" + this.columnCount + ", chunkSize=" + this.chunkSize + ", bufferTimeoutNanoSeconds=" + this.bufferTimeoutNanoSeconds + ", maxBufferSize=" + this.maxBufferSize + ", bufferHits=" + this.bufferHits + ", bufferMisses=" + this.bufferMisses + ", rowFactory=" + this.rowFactory + "}";
    }

    protected static class BufferedMOTableRow<R extends MOTableRow>
    implements MOTableRow {
        private long lastRefresh;
        private R bufferedRow;
        private BufferedMOTableRow<R> nextRow;
        final /* synthetic */ BufferedMOTableModel this$0;

        public BufferedMOTableRow(R bufferedRow) {
            this.this$0 = this$0;
            this.bufferedRow = bufferedRow;
            this.lastRefresh = System.nanoTime();
        }

        public R getBufferedRow() {
            return this.bufferedRow;
        }

        public void setBufferedRow(R bufferedRow) {
            this.bufferedRow = bufferedRow;
        }

        public BufferedMOTableRow<R> getNextRow() {
            return this.nextRow;
        }

        public void setNextRow(BufferedMOTableRow<R> nextRow) {
            this.nextRow = nextRow;
        }

        public OID getIndex() {
            return this.bufferedRow == null ? null : this.bufferedRow.getIndex();
        }

        public Variable getValue(int column) {
            return this.bufferedRow.getValue(column);
        }

        public MOTableRow getBaseRow() {
            return this.bufferedRow.getBaseRow();
        }

        public void setBaseRow(MOTableRow baseRow) {
            this.bufferedRow.setBaseRow(baseRow);
        }

        public int size() {
            return this.bufferedRow.size();
        }

        public long getLastRefresh() {
            return this.lastRefresh;
        }

        public void setLastRefresh(long lastRefresh) {
            this.lastRefresh = lastRefresh;
        }
    }

    protected class RowBufferIterator
    implements Iterator<R> {
        private OID currentIndex;
        private BufferedMOTableRow<R> nextRow;

        public RowBufferIterator(OID lowerBound) {
            this.currentIndex = lowerBound;
            this.nextRow = this.currentIndex == null ? BufferedMOTableModel.this.getFirstBufferRow() : this.fetchNextBufferRow(this.currentIndex, null, true);
        }

        @Override
        public boolean hasNext() {
            return this.nextRow != null;
        }

        @Override
        public R next() {
            BufferedMOTableRow next = this.nextRow;
            if (next != null) {
                this.nextRow = this.fetchNextBufferRow(next.getIndex(), this.nextRow, false);
                return next.getBufferedRow();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            BufferedMOTableModel.this.removeRow(this.currentIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected BufferedMOTableRow<R> fetchNextBufferRow(OID lowerBound, BufferedMOTableRow<R> predecessor, boolean includeLowerBound) {
            BufferedMOTableRow next;
            if (predecessor != null && (next = predecessor.getNextRow()) != null && BufferedMOTableModel.this.isRowValid(next.getLastRefresh())) {
                while (next != null && next.getBufferedRow() == null) {
                    next = BufferedMOTableModel.this.isRowValid(next.getLastRefresh()) ? next.getNextRow() : null;
                }
                if (next != null) {
                    ++BufferedMOTableModel.this.bufferHits;
                    return next;
                }
            }
            OID lowerBoundInc = includeLowerBound ? lowerBound : lowerBound.successor();
            SortedMap sortedMap = BufferedMOTableModel.this.bufferedRows;
            synchronized (sortedMap) {
                SortedMap nextRows = BufferedMOTableModel.this.bufferedRows.tailMap(lowerBoundInc);
                if (!nextRows.isEmpty()) {
                    BufferedMOTableRow<MOTableRow> row;
                    BufferedMOTableRow<MOTableRow> bufferedRow = null;
                    Iterator iterator = nextRows.values().iterator();
                    while (iterator.hasNext() && (bufferedRow = (row = iterator.next())).getIndex() == null) {
                    }
                    if (bufferedRow != null && BufferedMOTableModel.this.isRowValid(bufferedRow.getLastRefresh())) {
                        List newBufferRows;
                        if (includeLowerBound && bufferedRow.getIndex().equals((Object)lowerBoundInc)) {
                            ++BufferedMOTableModel.this.bufferHits;
                            return bufferedRow;
                        }
                        if (bufferedRow.getNextRow() != null && (newBufferRows = BufferedMOTableModel.this.fetchNextRows(lowerBoundInc, 1)) != null && !newBufferRows.isEmpty() && ((MOTableRow)newBufferRows.get(0)).getIndex().equals((Object)bufferedRow.getIndex())) {
                            ++BufferedMOTableModel.this.bufferMisses;
                            bufferedRow.setBufferedRow((MOTableRow)newBufferRows.get(0));
                            bufferedRow.setLastRefresh(System.nanoTime());
                            return bufferedRow;
                        }
                    }
                }
            }
            ++BufferedMOTableModel.this.bufferMisses;
            List newBufferRows = BufferedMOTableModel.this.fetchNextRows(lowerBoundInc, BufferedMOTableModel.this.chunkSize);
            return BufferedMOTableModel.this.updateBuffer(newBufferRows, predecessor);
        }
    }
}

