/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class AgentXRegion
extends DefaultMOScope
implements Comparable<AgentXRegion> {
    private boolean singleOID;
    private byte rangeSubID;

    public AgentXRegion(OID lowerBound, OID upperBound) {
        super(lowerBound, true, upperBound, false);
    }

    public AgentXRegion(AgentXRegion other) {
        super(other.getLowerBound(), other.isLowerIncluded(), other.getUpperBound(), other.isUpperIncluded());
        this.singleOID = other.singleOID;
        this.rangeSubID = other.rangeSubID;
    }

    public byte getRangeSubID() {
        return this.rangeSubID;
    }

    public boolean isSingleOID() {
        return this.singleOID;
    }

    public void setRangeSubID(byte rangeSubID) {
        this.rangeSubID = rangeSubID;
    }

    public void setSingleOID(boolean singleOID) {
        this.singleOID = singleOID;
    }

    public int getUpperBoundSubID() {
        if (this.rangeSubID != 0) {
            return this.upperBound.get(this.rangeSubID - 1);
        }
        return 0;
    }

    public boolean isRange() {
        return this.rangeSubID > 0;
    }

    public boolean isEmpty() {
        return this.lowerBound.compareTo((Variable)this.upperBound) >= 0;
    }

    public int getLowerBoundSubID() {
        if (this.rangeSubID != 0) {
            return this.lowerBound.get(this.rangeSubID - 1);
        }
        return 0;
    }

    @Override
    public int compareTo(AgentXRegion other) {
        int c = this.lowerBound.compareTo((Variable)other.lowerBound);
        if (c == 0 && (c = this.upperBound.compareTo((Variable)other.upperBound)) == 0) {
            c = this.rangeSubID - other.rangeSubID;
        }
        return c;
    }

    public String toString() {
        return this.getClass().getName() + "[lowerBound=" + this.lowerBound + ",lowerIncluded=" + this.lowerIncluded + ",upperBound=" + this.upperBound + ",upperIncluded=" + this.upperIncluded + ",rangeSubID=" + this.rangeSubID + ",upperBoundSubID=" + this.getUpperBoundSubID() + "]";
    }
}

