/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.agentx.AgentXMessageHeader;
import org.snmp4j.agent.agentx.AgentXRequestPDU;
import org.snmp4j.smi.OctetString;

public class AgentXGetBulkPDU
extends AgentXRequestPDU {
    private static final long serialVersionUID = -8406339539172636681L;
    protected short maxRepetitions;
    protected short nonRepeaters;

    public AgentXGetBulkPDU(OctetString context, short maxRepetitions, short nonRepeaters, MOScope[] ranges) {
        super((byte)7, context, ranges);
        this.maxRepetitions = maxRepetitions;
        this.nonRepeaters = nonRepeaters;
    }

    public AgentXGetBulkPDU(AgentXMessageHeader header) {
        super(header);
        if (header.getType() != 7) {
            throw new IllegalArgumentException();
        }
    }

    public short getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public short getNonRepeaters() {
        return this.nonRepeaters;
    }

    public void setMaxRepetitions(short maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public void setNonRepeaters(short nonRepeaters) {
        this.nonRepeaters = nonRepeaters;
    }

    @Override
    protected void decodeAfterContext(ByteBuffer buf, int length) throws IOException {
        this.nonRepeaters = buf.getShort();
        this.maxRepetitions = buf.getShort();
        super.decodeAfterContext(buf, length);
    }

    @Override
    protected void encodeAfterContext(ByteBuffer buf) {
        buf.putShort(this.nonRepeaters);
        buf.putShort(this.maxRepetitions);
        super.encodeAfterContext(buf);
    }

    @Override
    protected int getAfterContextLength() {
        return 4 + super.getAfterContextLength();
    }

    @Override
    protected String toStringExtMembers() {
        return super.toStringExtMembers() + ",nonRepeaters=" + this.nonRepeaters + ",maxRepetitions=" + this.maxRepetitions;
    }
}

