/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.subagent.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import jetbrains.exodus.env.Environments;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.agentx.AgentX;
import org.snmp4j.agent.agentx.AgentXMessageDispatcher;
import org.snmp4j.agent.agentx.AgentXMessageDispatcherImpl;
import org.snmp4j.agent.agentx.AgentXSession;
import org.snmp4j.agent.agentx.subagent.AgentXSharedMOTable;
import org.snmp4j.agent.agentx.subagent.AgentXSubagent;
import org.snmp4j.agent.agentx.subagent.RegistrationCallback;
import org.snmp4j.agent.agentx.subagent.SubagentXConfigManager;
import org.snmp4j.agent.agentx.subagent.test.AgentppTestMib;
import org.snmp4j.agent.db.MOXodusPersistence;
import org.snmp4j.agent.db.MOXodusPersistenceProvider;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.io.prop.PropertyMOInput;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.mo.snmp4j.Snmp4jConfigMib;
import org.snmp4j.agent.mo.snmp4j.Snmp4jLogMib;
import org.snmp4j.agent.mo.util.VariableProvider;
import org.snmp4j.log.ConsoleLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class TestSubagent
implements Runnable,
TransportStateListener,
RegistrationCallback {
    private static final LogAdapter LOGGER;
    public static final OID SUBAGENT_ID;
    private AgentXSubagent subagent;
    private AgentX agentX;
    private AgentXMessageDispatcher dispatcher;
    private Address masterAddress;
    private Address localAddress;
    private AgentXSession<Address> session;
    private int sessionID = 0;
    private MOServer server;
    private AgentppTestMib agentppTestMib;
    private Snmp4jConfigMib snmp4jConfigMib;
    private Snmp4jLogMib snmp4jLogMib;
    private SNMPv2MIB.SysUpTimeImpl sessionContextUpTime = new SNMPv2MIB.SysUpTimeImpl();
    private SubagentXConfigManager configManager;
    private MOXodusPersistence moXodusPersistence;

    public TestSubagent(final Address masterAddress, final Address localAddress, String configFile) {
        this.masterAddress = masterAddress;
        this.localAddress = localAddress;
        this.dispatcher = new AgentXMessageDispatcherImpl();
        this.agentX = new AgentX(this.dispatcher){

            @Override
            public Map<AgentXSession<?>, Integer> closeAllSessions(byte reason) {
                return TestSubagent.this.subagent.closeAllSessions(reason);
            }
        };
        this.server = new DefaultMOServer();
        this.server.addContext(new OctetString());
        MOInputFactory configurationFactory = null;
        InputStream configInputStream = TestSubagent.class.getResourceAsStream("TestSubagentConfig.properties");
        if (configInputStream != null) {
            Properties props = new Properties();
            try {
                props.load(configInputStream);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            configurationFactory = () -> new PropertyMOInput(props, (VariableProvider)this.configManager);
        }
        MOXodusPersistenceProvider moXodusPersistenceProvider = null;
        if (configFile != null) {
            this.moXodusPersistence = new MOXodusPersistence(new MOServer[]{this.server}, Environments.newInstance((String)configFile));
            moXodusPersistenceProvider = new MOXodusPersistenceProvider(this.moXodusPersistence);
        }
        this.configManager = new SubagentXConfigManager(this.agentX, this.dispatcher, new MOServer[]{this.server}, (WorkerPool)ThreadPool.create((String)"AgentXSubAgent", (int)3), configurationFactory, (MOPersistenceProvider)moXodusPersistenceProvider, DefaultMOFactory.getInstance()){

            @Override
            protected void registerMIBs(OctetString context) throws DuplicateRegistrationException {
                super.registerMIBs(context);
                MOFactory factory = AgentppTestMib.getSharedTableFactory();
                DefaultMOFactory.addSNMPv2TCs((MOFactory)factory);
                TestSubagent.this.agentppTestMib = new AgentppTestMib(factory);
                TestSubagent.this.agentppTestMib.registerMOs(TestSubagent.this.server, null);
            }

            @Override
            public void launchAgentXSessions() throws IOException {
                TestSubagent.this.unregisterSessionDependent();
                TestSubagent.this.session = new AgentXSession(++TestSubagent.this.sessionID);
                int status = TestSubagent.this.subagent.connect(masterAddress, localAddress, TestSubagent.this.session);
                if (status == 0) {
                    TestSubagent.this.subagent.addAgentCaps(TestSubagent.this.session, new OctetString(), new OID("1.3.6.1.4.1.4976.10.1.1.100.4.1"), new OctetString("AgentX-Test-Subagent"));
                    TestSubagent.this.registerSessionDependent();
                    TestSubagent.this.subagent.registerRegions(TestSubagent.this.session, new OctetString(), null, TestSubagent.this);
                    TimeTicks upTime = new TimeTicks();
                    TestSubagent.this.sessionContextUpTime.setValue((Variable)upTime);
                    TestSubagent.this.subagent.setPingDelay(30);
                    TestSubagent.this.subagent.notify(null, SnmpConstants.warmStart, new VariableBinding[]{new VariableBinding(SnmpConstants.sysDescr, (Variable)new OctetString("SNMP4J-AgentX Test-Subagent"))});
                    ((ConnectionOrientedTransportMapping)TestSubagent.this.session.getPeer().getTransport()).addTransportStateListener((TransportStateListener)TestSubagent.this);
                }
            }
        };
        this.subagent = new AgentXSubagent(this.agentX, SUBAGENT_ID, new OctetString("AgentX4J Test agent"), this.configManager);
        this.configManager.registerShutdownHook();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: TestSubagent <tcpIpAddress:port> [configPath]");
            System.exit(1);
        }
        TcpAddress masterAddress = new TcpAddress(args[0]);
        TestSubagent testsubagent = new TestSubagent((Address)masterAddress, (Address)new TcpAddress(), args.length < 2 ? null : args[1]);
        testsubagent.run();
        try {
            Thread.sleep(100000000L);
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
    }

    protected void unregisterSessionDependent() {
        if (this.session != null) {
            OctetString sessionContext = TestSubagent.getSessionContext(this.session.getSessionID());
            this.server.removeContext(sessionContext);
            if (this.snmp4jConfigMib != null) {
                this.snmp4jConfigMib.unregisterMOs(this.server, sessionContext);
            }
            if (this.snmp4jLogMib != null) {
                this.snmp4jLogMib.unregisterMOs(this.server, sessionContext);
            }
        }
    }

    protected void registerSessionDependent() {
        OctetString sessionContext = TestSubagent.getSessionContext(this.session.getSessionID());
        this.server.addContext(sessionContext);
        this.snmp4jConfigMib = new Snmp4jConfigMib((SysUpTime)this.sessionContextUpTime);
        try {
            this.snmp4jConfigMib.registerMOs(this.server, sessionContext);
        }
        catch (DuplicateRegistrationException e) {
            LOGGER.error((CharSequence)("Failed to register Snmp4jConfigMib: " + e.getMessage()), (Throwable)e);
        }
        this.snmp4jLogMib = new Snmp4jLogMib();
        try {
            this.snmp4jLogMib.registerMOs(this.server, sessionContext);
        }
        catch (DuplicateRegistrationException e) {
            LOGGER.error((CharSequence)("Failed to register Snmp4jLogMib: " + e.getMessage()), (Throwable)e);
        }
    }

    private static OctetString getSessionContext(int sessionID) {
        return new OctetString("session=" + sessionID);
    }

    public void connectionStateChanged(TransportStateEvent change) {
        if (change.getNewState() == 2) {
            this.session.setClosed(true);
            this.configManager.getState().setState(35);
            Thread t = new Thread(() -> {
                Address addr = change.getPeerAddress();
                boolean reconnected = false;
                for (int i = 0; i < 10; ++i) {
                    try {
                        Thread.sleep(5000L);
                        if (this.subagent.connect(addr, this.localAddress, this.session) != 0) continue;
                        reconnected = true;
                        this.configManager.getState().advanceState(40);
                        this.registerSessionDependent();
                        TimeTicks upTime = new TimeTicks();
                        this.subagent.registerRegions(this.session, new OctetString(), upTime, this);
                        this.server.addContext(TestSubagent.getSessionContext(this.session.getSessionID()));
                        this.sessionContextUpTime.setValue((Variable)upTime);
                        break;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        continue;
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
                if (!reconnected) {
                    this.configManager.shutdown();
                    System.exit(1);
                }
            });
            t.start();
        }
    }

    @Override
    public void registrationEvent(OctetString context, ManagedObject<?> mo, int status) {
        if (status != 0) {
            // empty if block
        }
    }

    @Override
    public <R extends MOTableRow, C extends MOColumn<?>, M extends MOTableModel<R>> boolean tableRegistrationEvent(OctetString context, AgentXSharedMOTable<R, C, M> mo, R row, boolean indexAllocation, int status, int retryCount) {
        if (status != 0 && indexAllocation && (context == null || context.length() == 0) && retryCount < 2 && AgentppTestMib.oidAgentppTestSparseEntry.equals((Object)mo.getOID())) {
            OID failedIndex = row.getIndex();
            int n = failedIndex.get(1) - 48;
            if (mo.removeRow(failedIndex) != null) {
                do {
                    failedIndex.setValue(new OctetString("[" + this.session.getSessionID() + "]" + n++).toSubIndex(false).getValue());
                } while (mo.getModel().containsRow(failedIndex));
                mo.addRow(row);
                return true;
            }
        }
        return false;
    }

    @Override
    public void unregistrationEvent(OctetString context, ManagedObject<?> mo, int status) {
    }

    @Override
    public <R extends MOTableRow, C extends MOColumn<?>, M extends MOTableModel<R>> void tableUnregistrationEvent(OctetString context, AgentXSharedMOTable<R, C, M> mo, R row, boolean indexAllocation, int status) {
    }

    @Override
    public void run() {
        this.configManager.run();
    }

    static {
        LogFactory.setLogFactory((LogFactory)new ConsoleLogFactory());
        LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.ALL);
        LOGGER = LogFactory.getLogger(TestSubagent.class);
        SUBAGENT_ID = new OID();
    }
}

