/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.subagent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.agentx.AgentXCommandEvent;
import org.snmp4j.agent.agentx.AgentXContextPDU;
import org.snmp4j.agent.agentx.AgentXGetBulkPDU;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXRequestPDU;
import org.snmp4j.agent.agentx.AgentXResponsePDU;
import org.snmp4j.agent.agentx.AgentXVariableBindingPDU;
import org.snmp4j.agent.request.AbstractRequest;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.RequestStatusEvent;
import org.snmp4j.agent.request.RequestStatusListener;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.agent.request.SubRequestIteratorSupport;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class AgentXRequest
extends AbstractRequest<AgentXSubRequest, AgentXCommandEvent<?>, AgentXResponsePDU> {
    private static final LogAdapter logger = LogFactory.getLogger(AgentXRequest.class);
    public static final OctetString DEFAULT_CONTEXT = new OctetString();
    protected Map<Object, Object> processingUserObjects;
    private static int nextTransactionID = 0;

    public AgentXRequest(AgentXCommandEvent<?> request) {
        super(request);
        this.source = request;
        this.correctRequestValues();
        this.transactionID = AgentXRequest.nextTransactionID();
    }

    public static int nextTransactionID() {
        return nextTransactionID++;
    }

    public int size() {
        if (((AgentXCommandEvent)this.source).getCommand() instanceof AgentXRequestPDU) {
            return ((AgentXRequestPDU)((AgentXCommandEvent)this.source).getCommand()).size();
        }
        if (((AgentXCommandEvent)this.source).getCommand() instanceof AgentXVariableBindingPDU) {
            return ((AgentXVariableBindingPDU)((AgentXCommandEvent)this.source).getCommand()).size();
        }
        return 0;
    }

    public boolean isBulkRequest() {
        return ((AgentXCommandEvent)this.source).getCommand().getType() == 7;
    }

    private void correctRequestValues() {
        AgentXPDU request = ((AgentXCommandEvent)this.source).getCommand();
        if (request instanceof AgentXGetBulkPDU) {
            this.repeaterStartIndex = this.getNonRepeaters();
            this.repeaterRowSize = Math.max(this.size() - this.repeaterStartIndex, 0);
        } else {
            this.repeaterStartIndex = 0;
            this.repeaterRowSize = this.size();
        }
    }

    protected void setupSubRequests() {
        int capacity = this.size();
        int totalRepetitions = 0;
        if (((AgentXCommandEvent)this.source).getCommand() instanceof AgentXGetBulkPDU) {
            totalRepetitions = this.repeaterRowSize * this.getMaxRepetitions();
        }
        this.subrequests = new ArrayList(capacity + totalRepetitions);
        if (this.response == null) {
            this.response = this.createResponse();
        }
        if (((AgentXCommandEvent)this.source).getCommand() instanceof AgentXRequestPDU) {
            AgentXRequestPDU rangeRequest = (AgentXRequestPDU)((AgentXCommandEvent)this.source).getCommand();
            MOScope[] ranges = rangeRequest.getRanges();
            for (int i = 0; i < ranges.length; ++i) {
                AgentXSubRequest subReq = new AgentXSubRequest((MOScope)new DefaultMOContextScope(this.getContext(), ranges[i]), i);
                this.addSubRequest(subReq);
            }
        } else if (((AgentXCommandEvent)this.source).getCommand() instanceof AgentXVariableBindingPDU) {
            AgentXVariableBindingPDU vbRequest = (AgentXVariableBindingPDU)((AgentXCommandEvent)this.source).getCommand();
            VariableBinding[] vbs = vbRequest.getVariableBindings();
            for (int i = 0; i < vbs.length; ++i) {
                AgentXSubRequest subReq = new AgentXSubRequest(vbs[i], i);
                this.addSubRequest(subReq);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("AgentXSubRequests initialized: " + this.subrequests)));
        }
    }

    public int getMaxRepetitions() {
        if (((AgentXCommandEvent)this.source).getCommand() instanceof AgentXGetBulkPDU) {
            return ((AgentXGetBulkPDU)((AgentXCommandEvent)this.source).getCommand()).getMaxRepetitions() & 0xFFFF;
        }
        return 0;
    }

    public int getNonRepeaters() {
        if (((AgentXCommandEvent)this.source).getCommand() instanceof AgentXGetBulkPDU) {
            return ((AgentXGetBulkPDU)((AgentXCommandEvent)this.source).getCommand()).getNonRepeaters() & 0xFFFF;
        }
        return 0;
    }

    private void addSubRequest(AgentXSubRequest subReq) {
        this.subrequests.add(subReq);
        ((AgentXResponsePDU)this.response).add(subReq.getVariableBinding());
    }

    protected int getMaxPhase() {
        return this.is2PC() ? 4 : 0;
    }

    public void setRequestEvent(AgentXCommandEvent<?> source) {
        this.source = source;
    }

    protected void assignErrorStatus2Response() {
        int errStatus = this.getErrorStatus();
        ((AgentXResponsePDU)this.response).setErrorStatus((short)errStatus);
        ((AgentXResponsePDU)this.response).setErrorIndex((short)this.getErrorIndex());
    }

    private AgentXResponsePDU createResponse() {
        AgentXResponsePDU resp = new AgentXResponsePDU(0, 0, 0);
        resp.setTransactionID(this.transactionID);
        return resp;
    }

    public AgentXResponsePDU getResponsePDU() {
        return this.getResponse();
    }

    public AgentXResponsePDU getResponse() {
        if (this.response == null) {
            this.response = this.createResponse();
            this.assignErrorStatus2Response();
        } else {
            this.assignErrorStatus2Response();
        }
        if (this.is2PC()) {
            ((AgentXResponsePDU)this.response).clear();
            if (((AgentXCommandEvent)this.source).getCommand().getType() == 11 || ((AgentXCommandEvent)this.source).getCommand().getType() == 10) {
                return null;
            }
        }
        return (AgentXResponsePDU)this.response;
    }

    public Iterator<AgentXSubRequest> iterator() {
        this.initSubRequests();
        return new AgentXSubRequestIterator();
    }

    protected boolean is2PC() {
        return ((AgentXCommandEvent)this.source).getCommand().getType() >= 8 && ((AgentXCommandEvent)this.source).getCommand().getType() <= 11;
    }

    public OctetString getContext() {
        if (((AgentXCommandEvent)this.source).getCommand() instanceof AgentXContextPDU) {
            return ((AgentXContextPDU)((AgentXCommandEvent)this.source).getCommand()).getContext();
        }
        return DEFAULT_CONTEXT;
    }

    public OctetString getViewName() {
        throw new UnsupportedOperationException();
    }

    public void setViewName(OctetString viewName) {
        throw new UnsupportedOperationException();
    }

    public int getSecurityLevel() {
        throw new UnsupportedOperationException();
    }

    public int getSecurityModel() {
        throw new UnsupportedOperationException();
    }

    public OctetString getSecurityName() {
        throw new UnsupportedOperationException();
    }

    public int getViewType() {
        throw new UnsupportedOperationException();
    }

    protected synchronized void addRepeaterSubRequest() {
        int predecessorIndex = this.subrequests.size() - this.repeaterRowSize;
        AgentXSubRequest sreq = new AgentXSubRequest((AgentXSubRequest)this.subrequests.get(predecessorIndex), this.subrequests.size());
        this.addSubRequest(sreq);
    }

    private List<AgentXSubRequest> lastRow() {
        if (this.repeaterRowSize == 0) {
            return null;
        }
        int rows = (this.subrequests.size() - this.repeaterStartIndex) / this.repeaterRowSize;
        int startIndex = this.repeaterStartIndex + this.repeaterRowSize * (rows - 1);
        int endIndex = this.repeaterStartIndex + this.repeaterRowSize * rows;
        return this.subrequests.subList(startIndex, endIndex);
    }

    public int getMessageProcessingModel() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[subrequests=" + this.subrequests + ",phase=" + this.phase + ",source=" + this.source + "]";
    }

    public boolean isPhaseComplete() {
        if (this.errorStatus == 0) {
            this.initSubRequests();
            for (SubRequest subrequest : this.subrequests) {
                RequestStatus status = subrequest.getStatus();
                if (status.getErrorStatus() != 0) {
                    return true;
                }
                if (status.isPhaseComplete()) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized Object getProcessingUserObject(Object key) {
        if (this.processingUserObjects != null) {
            return this.processingUserObjects.get(key);
        }
        return null;
    }

    public synchronized Object setProcessingUserObject(Object key, Object value) {
        if (this.processingUserObjects == null) {
            this.processingUserObjects = new HashMap<Object, Object>(5);
        }
        return this.processingUserObjects.put(key, value);
    }

    public class AgentXSubRequest
    implements SubRequest<AgentXSubRequest>,
    RequestStatusListener {
        private RequestStatus status;
        private VariableBinding vb;
        private Object undoValue;
        private MOScope scope;
        private MOQuery query;
        private ManagedObject<? super AgentXSubRequest> targetMO;
        private int index;
        private volatile Object userObject;

        private AgentXSubRequest(int index) {
            this.index = index;
            this.status = new RequestStatus();
            this.status.addRequestStatusListener((RequestStatusListener)this);
        }

        protected AgentXSubRequest(MOScope searchRange, int index) {
            this(index);
            this.scope = searchRange;
            this.vb = new VariableBinding(searchRange.getLowerBound());
        }

        protected AgentXSubRequest(VariableBinding subrequest, int index) {
            this(index);
            this.vb = subrequest;
            OID oid = this.vb.getOid();
            this.scope = new DefaultMOContextScope(this$0.getContext(), oid, true, oid, true);
        }

        protected AgentXSubRequest(AgentXSubRequest predecessor, int index) {
            this(index);
            this.vb = new VariableBinding(predecessor.getVariableBinding().getOid());
            switch (((AgentXCommandEvent)this$0.source).getCommand().getType()) {
                case 6: 
                case 7: {
                    this.scope = new DefaultMOContextScope(this$0.getContext(), predecessor.getVariableBinding().getOid(), false, predecessor.getScope().getUpperBound(), predecessor.getScope().isUpperIncluded());
                    break;
                }
                default: {
                    this.scope = new DefaultMOContextScope(this$0.getContext(), predecessor.getScope());
                }
            }
        }

        public Request<?, ?, ?> getRequest() {
            return AgentXRequest.this;
        }

        public RequestStatus getStatus() {
            return this.status;
        }

        public VariableBinding getVariableBinding() {
            return this.vb;
        }

        public void setStatus(RequestStatus status) {
            this.status = status;
        }

        public Object getUndoValue() {
            return this.undoValue;
        }

        public void setUndoValue(Object undoInformation) {
            this.undoValue = undoInformation;
        }

        public void requestStatusChanged(RequestStatusEvent event) {
            int newStatus = event.getStatus().getErrorStatus();
            AgentXRequest.this.setErrorStatus(newStatus);
            if (logger.isDebugEnabled() && newStatus != 0) {
                new Exception("Error " + event.getStatus().getErrorStatus() + " generated at: " + this.vb).printStackTrace();
            }
        }

        public MOScope getScope() {
            return this.scope;
        }

        public void completed() {
            this.status.setPhaseComplete(true);
        }

        public boolean hasError() {
            return this.getStatus().getErrorStatus() != 0;
        }

        public boolean isComplete() {
            return this.status.isPhaseComplete();
        }

        public void setTargetMO(ManagedObject<? super AgentXSubRequest> managedObject) {
            this.targetMO = managedObject;
        }

        public ManagedObject<? super AgentXSubRequest> getTargetMO() {
            return this.targetMO;
        }

        public int getIndex() {
            return this.index;
        }

        public void setQuery(MOQuery query) {
            this.query = query;
        }

        public MOQuery getQuery() {
            return this.query;
        }

        public String toString() {
            return this.getClass().getName() + "[scope=" + this.scope + ",vb=" + this.vb + ",status=" + this.status + ",query=" + this.query + ",index=" + this.index + ",targetMO=" + this.targetMO + "]";
        }

        public SubRequestIterator<AgentXSubRequest> repetitions() {
            AgentXGetBulkPDU getBulk;
            int repeaters;
            AgentXRequest.this.initSubRequests();
            if (((AgentXCommandEvent)AgentXRequest.this.source).getCommand().getType() == 7 && (repeaters = (getBulk = (AgentXGetBulkPDU)((AgentXCommandEvent)AgentXRequest.this.source).getCommand()).size() - getBulk.getNonRepeaters()) > 0) {
                return new AgentXSubRequestIterator(Math.max(this.getIndex(), getBulk.getNonRepeaters()), repeaters);
            }
            return new SubRequestIteratorSupport(Collections.EMPTY_LIST.iterator());
        }

        public void updateNextRepetition() {
            SubRequestIterator<AgentXSubRequest> repetitions = this.repetitions();
            repetitions.next();
            if (repetitions.hasNext()) {
                if (this.getStatus().getErrorStatus() == 0 && !this.vb.isException()) {
                    AgentXSubRequest nsreq = (AgentXSubRequest)repetitions.next();
                    nsreq.query = null;
                    nsreq.scope = new DefaultMOContextScope(AgentXRequest.this.getContext(), this.getVariableBinding().getOid(), false, this.getScope().getUpperBound(), this.getScope().isUpperIncluded());
                } else if (this.vb.isException()) {
                    while (repetitions.hasNext()) {
                        AgentXSubRequest nsreq = (AgentXSubRequest)repetitions.next();
                        nsreq.query = null;
                        nsreq.getVariableBinding().setOid(this.vb.getOid());
                        nsreq.getVariableBinding().setVariable(this.vb.getVariable());
                        nsreq.getStatus().setPhaseComplete(true);
                    }
                }
            }
        }

        public final void setErrorStatus(int errorStatus) {
            this.getStatus().setErrorStatus(errorStatus);
        }

        public final int getErrorStatus() {
            return this.getStatus().getErrorStatus();
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }
    }

    public class AgentXSubRequestIterator
    implements SubRequestIterator<AgentXSubRequest> {
        private int cursor = 0;
        private int increment = 1;

        protected AgentXSubRequestIterator() {
        }

        protected AgentXSubRequestIterator(int offset, int increment) {
            this.cursor = offset;
            this.increment = increment;
        }

        private int getRepeaterCount() {
            AgentXPDU pdu = ((AgentXCommandEvent)AgentXRequest.this.source).getCommand();
            if (pdu instanceof AgentXGetBulkPDU) {
                AgentXGetBulkPDU bulkPDU = (AgentXGetBulkPDU)pdu;
                return Math.max(bulkPDU.size() - bulkPDU.getNonRepeaters(), 0);
            }
            return 0;
        }

        public boolean hasNext() {
            AgentXPDU reqPDU = ((AgentXCommandEvent)AgentXRequest.this.source).getCommand();
            if (reqPDU.getType() == 7) {
                AgentXGetBulkPDU bulkPDU = (AgentXGetBulkPDU)reqPDU;
                if (this.cursor < Math.min(bulkPDU.size(), bulkPDU.getNonRepeaters())) {
                    return true;
                }
                if (this.cursor < bulkPDU.getNonRepeaters() + bulkPDU.getMaxRepetitions() * this.getRepeaterCount()) {
                    List lastRow = AgentXRequest.this.lastRow();
                    if (lastRow != null) {
                        boolean allEndOfMibView = true;
                        for (SubRequest sreq : lastRow) {
                            if (sreq.getVariableBinding().getSyntax() == 130) continue;
                            allEndOfMibView = false;
                            break;
                        }
                        if (allEndOfMibView) {
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
            return this.cursor < AgentXRequest.this.size();
        }

        public AgentXSubRequest next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (AgentXRequest.this.isBulkRequest() && this.cursor >= AgentXRequest.this.subrequests.size()) {
                while (this.cursor >= AgentXRequest.this.subrequests.size()) {
                    AgentXRequest.this.addRepeaterSubRequest();
                }
            }
            AgentXSubRequest sreq = (AgentXSubRequest)AgentXRequest.this.subrequests.get(this.cursor);
            this.cursor += this.increment;
            return sreq;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported on sub-requests");
        }

        public boolean equals(Object other) {
            if (other instanceof AgentXRequest) {
                return ((AgentXRequest)((Object)other)).getTransactionID() == AgentXRequest.this.getTransactionID();
            }
            return false;
        }

        public int hashCode() {
            return AgentXRequest.this.getTransactionID();
        }
    }
}

