/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master;

import java.util.Date;
import org.snmp4j.agent.agentx.master.AgentXPending;
import org.snmp4j.agent.agentx.master.AgentXRegEntry;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.smi.Address;

public abstract class AbstractAgentXPending<A extends Address>
implements AgentXPending<A> {
    private static final long serialVersionUID = -7904568557569179078L;
    protected AgentXRegEntry<A> registration;
    private SnmpRequest request;
    private boolean pending = true;
    private long timestamp = 0L;
    private int timeout = 5;

    public AbstractAgentXPending(AgentXRegEntry<A> registration, SnmpRequest request) {
        this.registration = registration;
        this.request = request;
    }

    @Override
    public void updateTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimeout(int timeoutSeconds) {
        this.timeout = timeoutSeconds;
    }

    @Override
    public void setPending(boolean pending) {
        this.pending = pending;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public AgentXRegEntry<A> getRegistration() {
        return this.registration;
    }

    @Override
    public boolean isPending() {
        return this.pending;
    }

    @Override
    public SnmpRequest getRequest() {
        return this.request;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.toStringMembers() + "]";
    }

    protected final String toStringMembers() {
        return "registration=" + this.registration + ",request=" + this.request + ",pending=" + this.pending + ",timestamp=" + new Date(this.timestamp) + ",timeout=" + this.timeout;
    }
}

