/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.Serializable;
import java.nio.ByteOrder;
import org.snmp4j.agent.agentx.AgentXPeer;
import org.snmp4j.agent.agentx.AgentXTarget;
import org.snmp4j.smi.Address;

public class AgentXSession<A extends Address>
implements Serializable {
    private static final long serialVersionUID = 2890153102679435259L;
    private int sessionID;
    private ByteOrder byteOrder;
    private byte timeout = (byte)5;
    private volatile int consecutiveTimeouts;
    private AgentXPeer<A> peer;
    private volatile boolean closed;

    public AgentXSession(int sessionID) {
        this.sessionID = sessionID;
        this.consecutiveTimeouts = 0;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public AgentXPeer<A> getPeer() {
        return this.peer;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public byte getTimeout() {
        return this.timeout;
    }

    public void clearConsecutiveTimeouts() {
        this.consecutiveTimeouts = 0;
    }

    public synchronized void incConsecutiveTimeouts() {
        ++this.consecutiveTimeouts;
    }

    public int getConsecutiveTimeouts() {
        return this.consecutiveTimeouts;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setPeer(AgentXPeer<A> peer) {
        this.peer = peer;
    }

    public void setSessionID(int sessionID) {
        this.sessionID = sessionID;
    }

    public void setTimeout(byte timeout) {
        this.timeout = timeout;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public AgentXTarget<A> createAgentXTarget() {
        return new AgentXTarget<A>(this.getPeer().getAddress(), this.getTimeout() * 1000);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AgentXSession) {
            return ((AgentXSession)obj).sessionID == this.sessionID;
        }
        return false;
    }

    public int hashCode() {
        return this.sessionID;
    }

    public String toString() {
        return this.getClass().getName() + "[peer=" + this.peer + ",sessionID=" + this.sessionID + ",byteOrder=" + this.byteOrder + ",timeout=" + this.timeout + ",consecutiveTimeouts=" + this.consecutiveTimeouts + ",closed=" + this.closed + "]";
    }
}

