/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.subagent.test;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.agentx.AgentX;
import org.snmp4j.agent.agentx.AgentXMessageDispatcher;
import org.snmp4j.agent.agentx.AgentXMessageDispatcherImpl;
import org.snmp4j.agent.agentx.AgentXSession;
import org.snmp4j.agent.agentx.subagent.AgentXSubagent;
import org.snmp4j.agent.agentx.subagent.RegistrationCallback;
import org.snmp4j.agent.agentx.subagent.test.AgentppTestMib;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.mo.snmp4j.Snmp4jConfigMib;
import org.snmp4j.agent.mo.snmp4j.Snmp4jLogMib;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;
import org.snmp4j.util.ThreadPool;

public class TestSubagent
implements Runnable,
TransportStateListener,
RegistrationCallback {
    private static final LogAdapter LOGGER;
    public static final OID SUBAGENT_ID;
    private AgentXSubagent subagent;
    private AgentX agentX;
    private AgentXMessageDispatcher dispatcher;
    private Address masterAddress;
    private Address localAddress;
    private AgentXSession session;
    private int sessionID = 0;
    private MOServer server;
    private AgentppTestMib agentppTestMib;
    private Snmp4jConfigMib snmp4jConfigMib;
    private Snmp4jLogMib snmp4jLogMib;
    private SNMPv2MIB.SysUpTimeImpl sessionContextUpTime = new SNMPv2MIB.SysUpTimeImpl();

    public TestSubagent(Address masterAddress, Address localAddress) {
        this.masterAddress = masterAddress;
        this.localAddress = localAddress;
        this.dispatcher = new AgentXMessageDispatcherImpl();
        this.agentX = new AgentX(this.dispatcher);
        this.server = new DefaultMOServer();
        this.server.addContext(new OctetString());
        this.subagent = new AgentXSubagent(this.agentX, SUBAGENT_ID, new OctetString("AgentX4J Test agent"));
        this.subagent.setThreadPool(ThreadPool.create((String)"AgentXSubAgent", (int)3));
        this.subagent.addMOServer(this.server);
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TcpAddress masterAddress = new TcpAddress(args[0]);
        TestSubagent testsubagent = new TestSubagent((Address)masterAddress, (Address)new TcpAddress());
        testsubagent.run();
        try {
            Thread.sleep(100000000L);
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
    }

    protected void register() throws DuplicateRegistrationException {
        MOFactory factory = AgentppTestMib.getSharedTableFactory();
        DefaultMOFactory.addSNMPv2TCs((MOFactory)factory);
        this.agentppTestMib = new AgentppTestMib(factory);
        this.agentppTestMib.registerMOs(this.server, null);
    }

    protected void unregisterSessionDependent() {
        if (this.session != null) {
            OctetString sessionContext = TestSubagent.getSessionContext(this.session.getSessionID());
            this.server.removeContext(sessionContext);
            if (this.snmp4jConfigMib != null) {
                this.snmp4jConfigMib.unregisterMOs(this.server, sessionContext);
            }
            if (this.snmp4jLogMib != null) {
                this.snmp4jLogMib.unregisterMOs(this.server, sessionContext);
            }
        }
    }

    protected void registerSessionDependent() throws DuplicateRegistrationException {
        OctetString sessionContext = TestSubagent.getSessionContext(this.session.getSessionID());
        this.server.addContext(sessionContext);
        this.snmp4jConfigMib = new Snmp4jConfigMib((SysUpTime)this.sessionContextUpTime);
        this.snmp4jConfigMib.registerMOs(this.server, sessionContext);
        this.snmp4jLogMib = new Snmp4jLogMib();
        this.snmp4jLogMib.registerMOs(this.server, sessionContext);
    }

    private static OctetString getSessionContext(int sessionID) {
        return new OctetString("session=" + sessionID);
    }

    @Override
    public void run() {
        try {
            Runtime.getRuntime().addShutdownHook(new AgentShutdown());
            this.register();
            this.unregisterSessionDependent();
            this.session = new AgentXSession(++this.sessionID);
            int status = this.subagent.connect(this.masterAddress, this.localAddress, this.session);
            if (status == 0) {
                this.subagent.addAgentCaps(this.session, new OctetString(), new OID("1.3.6.1.4.1.4976.10.1.1.100.4.1"), new OctetString("AgentX-Test-Subagent"));
                this.registerSessionDependent();
                this.subagent.registerRegions(this.session, new OctetString(), null, this);
                TimeTicks upTime = new TimeTicks();
                this.sessionContextUpTime.setValue((Variable)upTime);
                this.subagent.setPingDelay(30);
                this.subagent.notify(null, SnmpConstants.warmStart, new VariableBinding[]{new VariableBinding(SnmpConstants.sysDescr, (Variable)new OctetString("SNMP4J-AgentX Test-Subagent"))});
                ((ConnectionOrientedTransportMapping)this.session.getPeer().getTransport()).addTransportStateListener((TransportStateListener)this);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void unregisterFailed(List failedRegistrations) {
        for (Object failed : failedRegistrations) {
            if (failed instanceof ManagedObject) {
                this.server.unregister((ManagedObject)failed, null);
                continue;
            }
            if (!(failed instanceof MOTableRow)) continue;
            MOTableRow r = (MOTableRow)failed;
        }
    }

    public void connectionStateChanged(final TransportStateEvent change) {
        if (change.getNewState() == 2) {
            this.session.setClosed(true);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Address addr = change.getPeerAddress();
                    for (int i = 0; i < 10; ++i) {
                        try {
                            Thread.sleep(5000L);
                            if (TestSubagent.this.subagent.connect(addr, TestSubagent.this.localAddress, TestSubagent.this.session) != 0) continue;
                            try {
                                TestSubagent.this.registerSessionDependent();
                            }
                            catch (DuplicateRegistrationException ex1) {
                                ex1.printStackTrace();
                            }
                            TimeTicks upTime = new TimeTicks();
                            TestSubagent.this.subagent.registerRegions(TestSubagent.this.session, new OctetString(), upTime, TestSubagent.this);
                            TestSubagent.this.server.addContext(TestSubagent.getSessionContext(TestSubagent.this.session.getSessionID()));
                            TestSubagent.this.sessionContextUpTime.setValue((Variable)upTime);
                            break;
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            continue;
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                }
            });
            t.start();
        }
    }

    @Override
    public void registrationEvent(OctetString context, ManagedObject mo, int status) {
        if (status != 0) {
            // empty if block
        }
    }

    @Override
    public boolean tableRegistrationEvent(OctetString context, MOTable mo, MOTableRow row, boolean indexAllocation, int status, int retryCount) {
        if (status != 0 && indexAllocation && (context == null || context.length() == 0) && retryCount < 2 && AgentppTestMib.oidAgentppTestSparseEntry.equals((Object)mo.getOID())) {
            OID failedIndex = row.getIndex();
            int n = failedIndex.get(1) - 48;
            if (mo.removeRow(failedIndex) != null) {
                do {
                    failedIndex.setValue(new OctetString("[" + this.session.getSessionID() + "]" + n++).toSubIndex(false).getValue());
                } while (mo.getModel().containsRow(failedIndex));
                mo.addRow(row);
                return true;
            }
        }
        return false;
    }

    @Override
    public void unregistrationEvent(OctetString context, ManagedObject mo, int status) {
    }

    @Override
    public void tableUnregistrationEvent(OctetString context, MOTable mo, MOTableRow row, boolean indexAllocation, int status) {
    }

    static {
        LogFactory.setLogFactory((LogFactory)new Log4jLogFactory());
        LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.ALL);
        LOGGER = LogFactory.getLogger(TestSubagent.class);
        SUBAGENT_ID = new OID();
    }

    class AgentShutdown
    extends Thread {
        AgentShutdown() {
        }

        @Override
        public void run() {
            try {
                TestSubagent.this.subagent.close(TestSubagent.this.session, (byte)5);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

