/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp.dh;

import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.dh.DHOperations;
import org.snmp4j.security.dh.DHParameters;

public class DHKeyInfo {
    private LogAdapter LOGGER = LogFactory.getLogger(DHKeyInfo.class);
    private KeyPair keyPair;
    private KeyAgreement keyAgreement;
    private DHParameters keyParameters;
    private byte[] usmKey;

    DHKeyInfo() {
    }

    KeyPair getKeyPair() {
        return this.keyPair;
    }

    KeyAgreement getKeyAgreement() {
        return this.keyAgreement;
    }

    DHParameters getKeyParameters() {
        return this.keyParameters;
    }

    public KeyPair generatePublicKey(DHParameters dhParameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.keyParameters = dhParameters;
        this.keyPair = DHOperations.generatePublicKey((DHParameters)this.keyParameters);
        return this.keyPair;
    }

    public KeyAgreement getInitializedKeyAgreement() {
        this.keyAgreement = DHOperations.getInitializedKeyAgreement((KeyPair)this.keyPair);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Serializable)((Object)("Created KeyAgreement: " + String.valueOf(this.keyAgreement))));
        }
        return this.keyAgreement;
    }

    public byte[] getSharedKey() {
        return DHOperations.computeSharedKey((KeyAgreement)this.keyAgreement, (byte[])DHOperations.keyToBytes((Key)this.keyPair.getPublic()), (DHParameters)this.keyParameters);
    }

    public byte[] getUsmKey() {
        return this.usmKey;
    }

    public void setUsmKey(byte[] usmKey) {
        this.usmKey = usmKey;
    }

    public void clearUsmKey() {
        if (this.usmKey != null) {
            Arrays.fill(this.usmKey, (byte)0);
            this.usmKey = null;
        }
    }

    public boolean isKeyChangePending() {
        return this.usmKey != null;
    }
}

