/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.NotificationLogEvent;
import org.snmp4j.agent.mo.snmp.NotificationLogListener;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.SnmpTlsTmMib;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.security.VACM;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.TransportType;

public class NotificationOriginatorImpl
implements NotificationOriginator {
    private static final LogAdapter logger = LogFactory.getLogger(NotificationOriginatorImpl.class);
    private Session session;
    private final VACM vacm;
    private final SnmpTargetMIB targetMIB;
    private final SnmpNotificationMIB notificationMIB;
    private SnmpCommunityMIB communityMIB;
    private final SysUpTime sysUpTime;
    private transient List<NotificationLogListener> notificationLogListeners;
    private long notificationEventID = 0L;
    private static final OctetString EMPTY_CONTEXT_ENGINE_ID = new OctetString();

    public NotificationOriginatorImpl(Session session, VACM vacm, SysUpTime sysUpTime, SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
        this.session = session;
        this.sysUpTime = sysUpTime;
        this.vacm = vacm;
        this.targetMIB = targetMIB;
        this.notificationMIB = notificationMIB;
    }

    public NotificationOriginatorImpl(Session session, VACM vacm, SysUpTime sysUpTime, SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB, SnmpCommunityMIB communityMIB) {
        this(session, vacm, sysUpTime, targetMIB, notificationMIB);
        this.communityMIB = communityMIB;
    }

    @Override
    public Object notify(OctetString context, OID notificationID, VariableBinding[] vbs) {
        return this.notify(context, notificationID, this.sysUpTime.get(), vbs);
    }

    private <A extends Address> ResponseEvent<A> sendNotification(A address, Integer32 timeout, Integer32 retries, SnmpTargetMIB.SnmpTargetAddrEntryRow targetAddrEntryRow, MOTableRow paramsRow, OctetString context, OID notificationID, TimeTicks sysUpTime, VariableBinding[] vbs, int type, long notificationEventID) {
        PDU pdu;
        UserTarget t;
        Integer32 mpModel = (Integer32)paramsRow.getValue(0);
        OctetString secName = (OctetString)paramsRow.getValue(2);
        Integer32 secLevel = (Integer32)paramsRow.getValue(3);
        OctetString community = secName;
        try {
            if (secName == null) {
                throw new IllegalArgumentException("Security name must not be null");
            }
            if (this.communityMIB != null) {
                community = this.communityMIB.getCommunity(secName, null, context);
            }
            if (address == null) {
                String errMessage = "Null address, notification skipped";
                logger.debug((Serializable)((Object)errMessage));
                throw new IllegalArgumentException(errMessage);
            }
            if ((mpModel.getValue() == 0 || mpModel.getValue() == 1) && community == null) {
                throw new IllegalArgumentException("Security name '" + String.valueOf(secName) + "' is not mapped to any community, notification not sent (RFC 3584 \u00a75.2.3)");
            }
        }
        catch (IllegalArgumentException iaex) {
            logger.warn((Serializable)((Object)("Notification not sent due to configuration error: " + iaex.getMessage())));
            return null;
        }
        switch (mpModel.getValue()) {
            case 0: {
                TransportMapping tm;
                t = new CommunityTarget(address, community);
                PDUv1 trap = new PDUv1();
                pdu = trap;
                if (sysUpTime != null) {
                    trap.setTimestamp(sysUpTime.getValue());
                } else {
                    trap.setTimestamp(this.sysUpTime.get().getValue());
                }
                int genericID = SnmpConstants.getGenericTrapID((OID)notificationID);
                if (genericID < 0) {
                    OID enterprise;
                    trap.setGenericTrap(6);
                    if (notificationID.size() > 2 && notificationID.get(notificationID.size() - 2) == 0) {
                        enterprise = new OID(notificationID.getValue(), 0, notificationID.size() - 2);
                        trap.setEnterprise(enterprise);
                    } else {
                        enterprise = new OID(notificationID.getValue(), 0, notificationID.size() - 1);
                        trap.setEnterprise(enterprise);
                    }
                    trap.setSpecificTrap(notificationID.last());
                } else {
                    trap.setGenericTrap(genericID);
                    trap.setEnterprise(new OID(new int[]{0, 0}));
                }
                if (!(this.session instanceof Snmp) || (tm = ((Snmp)this.session).getMessageDispatcher().getTransport(address, TransportType.sender)) == null || !(tm.getListenAddress() instanceof IpAddress)) break;
                InetAddress localAddress = ((IpAddress)tm.getListenAddress()).getInetAddress();
                if (localAddress == null) {
                    trap.setAgentAddress(new IpAddress("0.0.0.0"));
                    break;
                }
                trap.setAgentAddress(new IpAddress(localAddress));
                break;
            }
            case 1: {
                t = new CommunityTarget(address, community);
                pdu = new PDU();
                break;
            }
            default: {
                byte[] authEngineID = type == 2 ? new byte[]{} : this.targetMIB.getLocalEngineID();
                OID transportDomain = (OID)targetAddrEntryRow.getValue(0);
                t = SnmpTlsTmMib.oidSnmpTLSTCPDomain.equals((Object)transportDomain) || SnmpTlsTmMib.oidSnmpDTLSUDPDomain.equals((Object)transportDomain) ? targetAddrEntryRow.getTarget(null, context, address) : new UserTarget(address, secName, authEngineID, secLevel.getValue());
                ScopedPDU scopedPdu = new ScopedPDU();
                scopedPdu.setContextName(context);
                this.setContextEngineID(scopedPdu, context, notificationID);
                pdu = scopedPdu;
            }
        }
        if (t == null) {
            return null;
        }
        t.setVersion(mpModel.getValue());
        t.setTimeout((long)timeout.getValue() * 10L);
        t.setRetries(retries.getValue());
        if (mpModel.getValue() != 0) {
            if (sysUpTime != null) {
                pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)sysUpTime));
            } else {
                pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)this.sysUpTime.get()));
            }
            pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)notificationID));
        }
        pdu.addAll(vbs);
        pdu.setType(type == 2 ? -90 : (mpModel.getValue() == 0 ? -92 : -89));
        try {
            OctetString localEngineID = new OctetString();
            OctetString contextEngineID = new OctetString();
            if (pdu instanceof ScopedPDU) {
                localEngineID.setValue(this.targetMIB.getLocalEngineID());
                contextEngineID = ((ScopedPDU)pdu).getContextEngineID();
            }
            ResponseEvent response = this.session.send(pdu, (Target)t);
            this.fireNotificationLogEvent(new NotificationLogEvent(this, localEngineID, t, contextEngineID, context, notificationID, sysUpTime, vbs, notificationEventID, true));
            if (pdu.isConfirmedPdu()) {
                if (logger.isInfoEnabled()) {
                    if (response != null) {
                        logger.info((CharSequence)("Sent INFORM request with ID " + notificationEventID + " " + String.valueOf(pdu) + " to " + String.valueOf(t) + " successfully"));
                    } else {
                        logger.info((CharSequence)("INFORM request with ID " + notificationEventID + " " + String.valueOf(pdu) + " to " + String.valueOf(t) + " timed out"));
                    }
                }
            } else {
                logger.info((CharSequence)("Sent notification with ID " + notificationEventID + " " + String.valueOf(pdu) + " to " + String.valueOf(t)));
            }
            return response;
        }
        catch (IOException iox) {
            logger.error((CharSequence)("Failed to send notification: " + iox.getMessage()), (Throwable)iox);
            return null;
        }
    }

    protected void setContextEngineID(ScopedPDU scopedPDU, OctetString context, OID notificationID) {
        scopedPDU.setContextEngineID(new OctetString(this.targetMIB.getLocalEngineID()));
    }

    private boolean isAccessGranted(MOTableRow addr, MOTableRow paramsRow, OctetString context, OID notificationID, VariableBinding[] vbs) {
        if (!this.notificationMIB.passesFilter(paramsRow.getIndex(), notificationID, vbs)) {
            if (logger.isInfoEnabled()) {
                logger.info((CharSequence)("Notification " + String.valueOf(notificationID) + " did not pass filter " + String.valueOf(paramsRow.getIndex())));
            }
            return false;
        }
        OctetString secName = (OctetString)paramsRow.getValue(2);
        Integer32 secLevel = (Integer32)paramsRow.getValue(3);
        Integer32 secModel = (Integer32)paramsRow.getValue(1);
        int status = this.vacm.isAccessAllowed(context, secName, secModel.getValue(), secLevel.getValue(), 0, notificationID);
        for (int i = 0; status == 0 && i < vbs.length; ++i) {
            status = this.vacm.isAccessAllowed(context, secName, secModel.getValue(), secLevel.getValue(), 0, vbs[i].getOid());
            if (status == 0 || !logger.isDebugEnabled()) continue;
            logger.debug((Serializable)((Object)("Notification " + String.valueOf(notificationID) + " to target '" + String.valueOf(OctetString.fromIndex((OID)addr.getIndex(), (int)0, (boolean)true)) + "': VACM access not granted for OID " + String.valueOf(vbs[i].getOid()) + ": " + status)));
        }
        return status == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object notify(OctetString context, OID notificationID, TimeTicks sysUpTime, VariableBinding[] vbs) {
        long notificationEventIndex;
        OID notificationIDCopy = new OID(notificationID);
        if (logger.isInfoEnabled()) {
            logger.info((CharSequence)("Notification " + String.valueOf(notificationIDCopy) + " reported with " + String.valueOf(Arrays.asList(vbs)) + " for context " + String.valueOf(context)));
        }
        if (this.targetMIB == null) {
            logger.error((Serializable)((Object)("TargetMIB is null, notification cannot be sent: " + String.valueOf(notificationIDCopy))));
            return new ResponseEvent[0];
        }
        if (context == null) {
            context = new OctetString();
        }
        LinkedList<ResponseEvent<Address>> responses = new LinkedList<ResponseEvent<Address>>();
        NotificationOriginatorImpl notificationOriginatorImpl = this;
        synchronized (notificationOriginatorImpl) {
            notificationEventIndex = this.notificationEventID++;
        }
        OctetString localEngineID = null;
        if (this.targetMIB.getLocalEngineID() != null) {
            localEngineID = new OctetString(this.targetMIB.getLocalEngineID());
        }
        this.fireNotificationLogEvent(new NotificationLogEvent(this, localEngineID, null, EMPTY_CONTEXT_ENGINE_ID, context, notificationIDCopy, sysUpTime, vbs, notificationEventIndex, false));
        Iterator it = this.notificationMIB.getNotifyTable().getModel().iterator();
        while (it.hasNext()) {
            MOTableRow notifyRow = (MOTableRow)it.next();
            OctetString tag = (OctetString)notifyRow.getValue(0);
            Integer32 type = (Integer32)notifyRow.getValue(1);
            Collection<SnmpTargetMIB.SnmpTargetAddrEntryRow> addresses = this.targetMIB.getTargetAddrRowsForTag(tag);
            RowStatus.ActiveRowsFilter<SnmpTargetMIB.SnmpTargetAddrEntryRow> aFilter = new RowStatus.ActiveRowsFilter<SnmpTargetMIB.SnmpTargetAddrEntryRow>(7);
            for (SnmpTargetMIB.SnmpTargetAddrEntryRow address : addresses) {
                if (!aFilter.passesFilter(address)) continue;
                OctetString params = (OctetString)address.getValue(5);
                MOTableRow paramsRow = this.targetMIB.getTargetParamsRow(params);
                if (paramsRow != null) {
                    if (RowStatus.isRowActive(paramsRow, 5)) {
                        if (!this.isAccessGranted(address, paramsRow, context, notificationIDCopy, vbs)) continue;
                        Integer32 timeout = (Integer32)address.getValue(2);
                        Integer32 retries = (Integer32)address.getValue(3);
                        ResponseEvent<Address> response = this.sendNotification(address.getAddress(), timeout, retries, address, paramsRow, context, notificationIDCopy, sysUpTime, vbs, type.getValue(), notificationEventIndex);
                        responses.add(response);
                        continue;
                    }
                    logger.warn((Serializable)((Object)"Found active target address but corresponding params are not active"));
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn((Serializable)((Object)("Found active target address but not corresponding params row: '" + String.valueOf(params) + "'")));
            }
        }
        return responses.toArray(new ResponseEvent[0]);
    }

    public void setSession(Session snmpSession) {
        this.session = snmpSession;
    }

    public SysUpTime getSysUpTime() {
        return this.sysUpTime;
    }

    public synchronized void addNotificationLogListener(NotificationLogListener l) {
        if (this.notificationLogListeners == null) {
            this.notificationLogListeners = new ArrayList<NotificationLogListener>(2);
        }
        this.notificationLogListeners.add(l);
    }

    public synchronized void removeNotificationLogListener(NotificationLogListener l) {
        if (this.notificationLogListeners != null) {
            this.notificationLogListeners.remove(l);
        }
    }

    protected synchronized void fireNotificationLogEvent(NotificationLogEvent<?> event) {
        List<NotificationLogListener> listeners = this.notificationLogListeners;
        if (listeners != null) {
            for (NotificationLogListener listener : listeners) {
                listener.notificationLogEvent(event);
            }
        }
    }
}

