/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp.tc;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.snmp.smi.EnumerationConstraint;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraintValidator;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class TruthValueTC
implements TextualConvention<Integer32> {
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    private EnumerationConstraint constraint = new EnumerationConstraint(new int[]{1, 2});

    @Override
    public MOColumn<Integer32> createColumn(int columnID, int syntax, MOAccess access, Integer32 defaultValue, boolean mutableInService) {
        MOColumn<Integer32> c;
        if (access.isAccessibleForWrite()) {
            c = new MOMutableColumn<Integer32>(columnID, 2, access, defaultValue);
            ((MOMutableColumn)c).addMOValueValidationListener(new ValueConstraintValidator(this.constraint));
        } else {
            c = new MOColumn<Integer32>(columnID, 2, access);
        }
        return c;
    }

    @Override
    public MOScalar<Integer32> createScalar(OID oid, MOAccess access, Integer32 value) {
        MOScalar<Integer32> scalar = new MOScalar<Integer32>(oid, access, value == null ? this.createInitialValue() : value);
        if (this.constraint.validate((Variable)scalar.getValue()) != 0) {
            throw new IllegalArgumentException("Illegal TruthValue " + value);
        }
        scalar.addMOValueValidationListener(new ValueConstraintValidator(this.constraint));
        return scalar;
    }

    @Override
    public String getModuleName() {
        return "SNMPv2-TC";
    }

    @Override
    public String getName() {
        return "TruthValue";
    }

    public static Integer32 getValue(boolean b) {
        return b ? new Integer32(1) : new Integer32(2);
    }

    @Override
    public Integer32 createInitialValue() {
        return new Integer32(2);
    }

    public static boolean getBooleanValue(Integer32 truthValue) {
        return 1 == truthValue.getValue();
    }
}

