/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Session;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.AgentConfigManager;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.example.Modules;
import org.snmp4j.agent.example.Snmp4jDemoMib;
import org.snmp4j.agent.io.DefaultMOPersistenceProvider;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.prop.PropertyMOInput;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.TimeStamp;
import org.snmp4j.agent.mo.snmp.dh.DHKickstartParametersImpl;
import org.snmp4j.cfg.EngineBootsCounterFile;
import org.snmp4j.cfg.EngineBootsProvider;
import org.snmp4j.log.ConsoleLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.DtlsAddress;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DTLSTM;
import org.snmp4j.transport.TLSTM;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.SnmpConfigurator;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class SampleAgent {
    private static final LogAdapter logger;
    protected AgentConfigManager agent;
    protected MOServer server;
    private String configFile;
    private File bootCounterFile;
    protected Modules modules;
    protected Properties tableSizeLimits;

    public SampleAgent(Map<String, List<Object>> args) {
        List<Object> dtlsVersions;
        SNMP4JSettings.setReportSecurityLevelStrategy((SNMP4JSettings.ReportSecurityLevelStrategy)SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded);
        this.configFile = (String)args.get("c").get(0);
        this.bootCounterFile = new File((String)args.get("bc").get(0));
        List<Object> tlsVersions = args.get("tls-version");
        if (tlsVersions != null && tlsVersions.size() > 0) {
            System.setProperty("org.snmp4j.arg.tlsVersion", (String)tlsVersions.get(0));
        }
        if ((dtlsVersions = args.get("dtls-version")) != null && dtlsVersions.size() > 0) {
            System.setProperty("org.snmp4j.arg.dtlsVersion", (String)dtlsVersions.get(0));
        }
        this.server = new DefaultMOServer();
        MOServer[] moServers = new MOServer[]{this.server};
        InputStream configInputStream = SampleAgent.class.getResourceAsStream("SampleAgentConfig.properties");
        if (args.containsKey("cfg")) {
            String configFilename = (String)ArgumentParser.getValue(args, (String)"cfg", (int)0);
            try {
                configInputStream = new FileInputStream(configFilename);
            }
            catch (FileNotFoundException ex1) {
                logger.error((CharSequence)("Config file '" + configFilename + "' not found: " + ex1.getMessage()), (Throwable)ex1);
                throw new RuntimeException(ex1);
            }
        }
        final Properties props = new Properties();
        try {
            props.load(configInputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        MOInputFactory configurationFactory = new MOInputFactory(){

            @Override
            public MOInput createMOInput() {
                return new PropertyMOInput(props, SampleAgent.this.agent);
            }
        };
        InputStream tableSizeLimitsInputStream = SampleAgent.class.getResourceAsStream("SampleAgentTableSizeLimits.properties");
        if (args.containsKey("ts")) {
            try {
                tableSizeLimitsInputStream = new FileInputStream((String)ArgumentParser.getValue(args, (String)"ts", (int)0));
            }
            catch (FileNotFoundException ex1) {
                ex1.printStackTrace();
            }
        }
        this.tableSizeLimits = new Properties();
        try {
            this.tableSizeLimits.load(tableSizeLimitsInputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        MessageDispatcherImpl messageDispatcher = new MessageDispatcherImpl();
        try {
            messageDispatcher.addTransportMapping((TransportMapping)new TLSTM(new TlsAddress(), false));
            messageDispatcher.addTransportMapping((TransportMapping)new DTLSTM(new DtlsAddress(), false));
        }
        catch (IOException e) {
            logger.error((CharSequence)("Exception while adding (D)TLS transport mappings: " + e.getMessage()), (Throwable)e);
        }
        this.addListenAddresses((MessageDispatcher)messageDispatcher, args.get("address"));
        List<Object> dhKickstartParameters = Collections.emptyList();
        String dhKickstartInfoPath = (String)ArgumentParser.getFirstValue(args.get("dhks"));
        if (dhKickstartInfoPath != null) {
            File dhKickstartInfoFile = new File(dhKickstartInfoPath);
            if (dhKickstartInfoFile.canRead()) {
                try {
                    Properties kickstartProperties = new Properties();
                    FileInputStream fileInputStream = new FileInputStream(dhKickstartInfoFile);
                    kickstartProperties.load(fileInputStream);
                    fileInputStream.close();
                    dhKickstartParameters = DHKickstartParametersImpl.readFromProperties("org.snmp4j.", kickstartProperties);
                }
                catch (IOException iox) {
                    logger.error((CharSequence)("Failed to load Diffie Hellman kickstart parameters from '" + dhKickstartInfoPath + "': " + iox.getMessage()), (Throwable)iox);
                }
            } else {
                logger.warn((Serializable)((Object)("Diffie Hellman kickstart parameters file cannot be read: " + dhKickstartInfoFile)));
            }
        }
        EngineBootsCounterFile engineBootsCounterFile = new EngineBootsCounterFile(this.bootCounterFile);
        OctetString ownEngineId = engineBootsCounterFile.getEngineId(new OctetString(MPv3.createLocalEngineID()));
        final SnmpConfigurator snmpConfigurator = new SnmpConfigurator(true);
        this.agent = new AgentConfigManager(ownEngineId, (MessageDispatcher)messageDispatcher, null, moServers, (WorkerPool)ThreadPool.create((String)"SampleAgent", (int)3), configurationFactory, new DefaultMOPersistenceProvider(moServers, this.configFile), (EngineBootsProvider)engineBootsCounterFile, null, dhKickstartParameters, (MessageDispatcher)messageDispatcher, args){
            final /* synthetic */ MessageDispatcher val$messageDispatcher;
            final /* synthetic */ Map val$args;
            {
                this.val$messageDispatcher = messageDispatcher2;
                this.val$args = map;
                super(agentsOwnEngineID, messageDispatcher, vacm, moServers, workerPool, configurationFactory, persistenceProvider, engineBootsProvider, moFactory, diffieHellmanKickstartParameters);
            }

            @Override
            protected Session createSnmpSession(MessageDispatcher dispatcher) {
                Session session = super.createSnmpSession(dispatcher);
                snmpConfigurator.configure(session, this.getUsm(), this.val$messageDispatcher, this.val$args);
                return session;
            }
        };
        this.agent.setContext(new SecurityModels(), new SecurityProtocols(SecurityProtocols.SecurityProtocolSet.maxCompatibility), new CounterSupport());
    }

    protected void addListenAddresses(MessageDispatcher md, List<Object> addresses) {
        for (Object addressString : addresses) {
            Address address = GenericAddress.parse((String)addressString.toString());
            if (address == null) {
                logger.fatal((Object)("Could not parse address string '" + addressString + "'"));
                return;
            }
            TransportMapping tm = TransportMappings.getInstance().createTransportMapping(address);
            if (tm != null) {
                md.addTransportMapping(tm);
                continue;
            }
            logger.warn((Serializable)((Object)("No transport mapping available for address '" + address + "'.")));
        }
    }

    public void run() {
        this.server.addContext(new OctetString("context1"));
        this.agent.initialize();
        SNMPv2MIB context1SNMPv2MIB = new SNMPv2MIB(new OctetString(), new OID(), new Integer32(0));
        try {
            context1SNMPv2MIB.registerMOs(this.server, new OctetString("context1"));
        }
        catch (DuplicateRegistrationException e) {
            throw new RuntimeException(e);
        }
        this.agent.setupProxyForwarder();
        this.registerMIBs();
        this.agent.setTableSizeLimits(this.tableSizeLimits);
        this.agent.registerShutdownHook();
        this.agent.run();
    }

    protected MOFactory getFactory() {
        return DefaultMOFactory.getInstance();
    }

    protected void registerMIBs() {
        if (this.modules == null) {
            this.modules = new Modules(this.getFactory());
            this.modules.getSnmp4jDemoMib().getSnmp4jDemoEntry().addMOTableRowListener(new DemoTableRowListener());
            ((TimeStamp)this.modules.getSnmp4jDemoMib().getSnmp4jDemoEntry().getColumn(3)).setSysUpTime(this.agent.getSysUpTime());
        }
        try {
            this.modules.registerMOs(this.server, null);
        }
        catch (DuplicateRegistrationException drex) {
            logger.error((CharSequence)("Duplicate registration: " + drex.getMessage() + ". MIB object registration may be incomplete!"), (Throwable)drex);
        }
    }

    protected static List<String[]> splitArgsForMultipleAgents(String[] args, String separatorArgs) {
        ArrayList<String[]> agentsCommandLines = new ArrayList<String[]>();
        ArrayList<String> agentArgs = new ArrayList<String>();
        for (String arg : args) {
            if ("||".equals(arg)) {
                agentsCommandLines.add(agentArgs.toArray(new String[0]));
                agentArgs.clear();
                continue;
            }
            agentArgs.add(arg);
        }
        agentsCommandLines.add(agentArgs.toArray(new String[0]));
        return agentsCommandLines;
    }

    public static void main(String[] args) {
        ArgumentParser parser = new ArgumentParser("-c[s{=SampleAgent.cfg}] -bc[s{=SampleAgent.bc}] +dhks[s] +u[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2|TLSv1.3)>] +dtls-version[s{=TLSv1.2}<(TLSv1.0|TLSv1.2|TLSv1.3)>]+Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword +ts[s] +cfg[s] +x", "#address[s<(udp|tcp|tls|dtls):.*[/[0-9]+]?>] ..");
        List<String[]> multiAgentArgs = SampleAgent.splitArgsForMultipleAgents(args, "||");
        for (String[] agentArgs : multiAgentArgs) {
            try {
                Map commandLineParameters = parser.parse(agentArgs);
                if (commandLineParameters.containsKey("x")) {
                    SNMP4JSettings.setExtensibilityEnabled((boolean)true);
                }
                SampleAgent sampleAgent = new SampleAgent(commandLineParameters);
                SecurityProtocols.getInstance().addDefaultProtocols();
                sampleAgent.run();
            }
            catch (ParseException ex) {
                logger.error((CharSequence)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    static {
        LogFactory.setLogFactory((LogFactory)new ConsoleLogFactory());
        LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.ALL);
        SNMP4JSettings.setSecretLoggingEnabled((boolean)true);
        logger = LogFactory.getLogger(SampleAgent.class);
    }

    class DemoTableRowListener
    implements MOTableRowListener<Snmp4jDemoMib.Snmp4jDemoEntryRow> {
        DemoTableRowListener() {
        }

        @Override
        public void rowChanged(MOTableRowEvent<Snmp4jDemoMib.Snmp4jDemoEntryRow> event) {
            if (event.getType() == 1 || event.getType() == 4) {
                return;
            }
            Counter32 counter = (Counter32)event.getRow().getValue(2);
            if (counter == null) {
                counter = new Counter32(0L);
                ((MOMutableTableRow)event.getRow()).setValue(2, (Variable)counter);
            }
            counter.increment();
            TimeStamp timestamp = (TimeStamp)event.getTable().getColumn(3);
            timestamp.update(event.getRow(), 3);
            Integer32 type = new Integer32(2);
            switch (event.getType()) {
                case 2: {
                    type.setValue(1);
                    break;
                }
                case 3: {
                    type.setValue(3);
                }
            }
            VariableBinding[] payload = new VariableBinding[2];
            OID table = event.getTable().getOID();
            OID updateCount = new OID(table);
            updateCount.append(5);
            updateCount.append(event.getRow().getIndex());
            OID modifyType = new OID(table);
            modifyType.append(9);
            modifyType.append(event.getRow().getIndex());
            payload[0] = new VariableBinding(updateCount, (Variable)counter);
            payload[1] = new VariableBinding(modifyType, (Variable)type);
            SampleAgent.this.modules.getSnmp4jDemoMib().snmp4jDemoEvent(SampleAgent.this.agent.getNotificationOriginator(), new OctetString(), payload);
        }
    }
}

