/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.snmp4j.CommandResponder;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.ProxyForwarder;
import org.snmp4j.agent.io.DefaultMOPersistenceProvider;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.snmp.NotificationOriginatorImpl;
import org.snmp4j.agent.mo.snmp.ProxyForwarderImpl;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpFrameworkMIB;
import org.snmp4j.agent.mo.snmp.SnmpMpdMib;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpProxyMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.UsmMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.agent.mo.snmp4j.Snmp4jConfigMib;
import org.snmp4j.agent.mo.snmp4j.Snmp4jLogMib;
import org.snmp4j.cfg.EngineBootsCounterFile;
import org.snmp4j.event.CounterListener;
import org.snmp4j.event.UsmUserListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

@Deprecated
public abstract class BaseAgent
implements Runnable {
    private static final LogAdapter logger = LogFactory.getLogger(BaseAgent.class);
    public static final int STATE_CREATED = 0;
    public static final int STATE_INIT_STARTED = 10;
    public static final int STATE_INIT_FINISHED = 20;
    public static final int STATE_RUNNING = 40;
    public static final int STATE_STOPPED = 30;
    protected SNMPv2MIB snmpv2MIB;
    protected SnmpMpdMib snmpMpdMib;
    protected SnmpFrameworkMIB snmpFrameworkMIB;
    protected SnmpTargetMIB snmpTargetMIB;
    protected SnmpNotificationMIB snmpNotificationMIB;
    protected SnmpProxyMIB snmpProxyMIB;
    protected SnmpCommunityMIB snmpCommunityMIB;
    protected Snmp4jLogMib snmp4jLogMIB;
    protected Snmp4jConfigMib snmp4jConfigMIB;
    protected UsmMIB usmMIB;
    protected VacmMIB vacmMIB;
    protected DefaultMOServer server;
    protected Snmp session;
    protected TransportMapping<? extends Address>[] transportMappings;
    protected MessageDispatcherImpl dispatcher;
    protected CommandProcessor agent;
    protected MPv3 mpv3;
    protected USM usm;
    protected EngineBootsCounterFile bootCounterFile;
    protected NotificationOriginator notificationOriginator;
    protected ProxyForwarder defaultProxyForwarder;
    protected OctetString sysDescr = new OctetString("SNMP4J-Agent - " + System.getProperty("os.name", "") + " - " + System.getProperty("os.arch") + " - " + System.getProperty("os.version"));
    protected OID sysOID = new OID("1.3.6.1.4.1.4976");
    protected Integer32 sysServices = new Integer32(10);
    protected int agentState = 0;
    protected OctetString defaultContext;
    protected DefaultMOPersistenceProvider defaultPersistenceProvider;
    protected String configFileURI;

    protected BaseAgent(String configURI) {
        this.configFileURI = configURI;
        this.server = new DefaultMOServer();
        this.defaultPersistenceProvider = new DefaultMOPersistenceProvider(new MOServer[]{this.server}, configURI);
    }

    protected BaseAgent(File bootCounterFile, File configFile, CommandProcessor commandProcessor) {
        this(configFile == null ? null : configFile.getPath());
        this.bootCounterFile = new EngineBootsCounterFile(bootCounterFile);
        this.agent = commandProcessor;
    }

    public void init() throws IOException {
        this.agentState = 10;
        this.initTransportMappings();
        this.initMessageDispatcher();
        this.server.addContext(new OctetString());
        this.snmpv2MIB = new SNMPv2MIB(this.sysDescr, this.sysOID, this.sysServices);
        this.snmpMpdMib = new SnmpMpdMib(DefaultMOFactory.getInstance());
        this.dispatcher.addCounterListener((CounterListener)this.snmpv2MIB);
        this.dispatcher.addCounterListener((CounterListener)this.snmpMpdMib);
        this.mpv3.getCounterSupport().addCounterListener((CounterListener)this.snmpMpdMib);
        this.agent.addCounterListener(this.snmpv2MIB);
        this.agent.addCounterListener(this.snmpMpdMib);
        this.snmpFrameworkMIB = new SnmpFrameworkMIB(this.usm.getLocalEngineID(), (USM)this.mpv3.getSecurityModel(3), this.dispatcher.getTransportMappings());
        this.usmMIB = new UsmMIB(this.usm, SecurityProtocols.getInstance());
        this.usm.addUsmUserListener((UsmUserListener)this.usmMIB);
        this.vacmMIB = new VacmMIB(new MOServer[]{this.server});
        this.snmpTargetMIB = new SnmpTargetMIB((MessageDispatcher)this.dispatcher);
        this.snmpNotificationMIB = new SnmpNotificationMIB();
        this.snmpCommunityMIB = new SnmpCommunityMIB(this.snmpTargetMIB);
        this.initConfigMIB();
        this.snmpProxyMIB = new SnmpProxyMIB();
        this.notificationOriginator = new NotificationOriginatorImpl((Session)this.session, this.vacmMIB, this.snmpv2MIB.getSysUpTime(), this.snmpTargetMIB, this.snmpNotificationMIB, this.snmpCommunityMIB);
        this.snmpv2MIB.setNotificationOriginator(this.agent);
        this.usm.getCounterSupport().addCounterListener((CounterListener)this.snmpv2MIB);
        this.setupDefaultProxyForwarder();
        this.addUsmUser(this.usm);
        this.addCommunities(this.snmpCommunityMIB);
        this.addViews(this.vacmMIB);
        this.addNotificationTargets(this.snmpTargetMIB, this.snmpNotificationMIB);
        this.registerSnmpMIBs();
    }

    protected void initConfigMIB() {
        this.snmp4jLogMIB = new Snmp4jLogMib();
        if (this.configFileURI != null && this.defaultPersistenceProvider != null) {
            this.snmp4jConfigMIB = new Snmp4jConfigMib(this.snmpv2MIB.getSysUpTime());
            this.snmp4jConfigMIB.setSnmpCommunityMIB(this.snmpCommunityMIB);
            this.snmp4jConfigMIB.setPrimaryProvider(this.defaultPersistenceProvider);
        }
    }

    protected OctetString getContext(MOGroup mibGroup) {
        return this.getDefaultContext();
    }

    protected void registerSnmpMIBs() {
        try {
            this.snmpTargetMIB.registerMOs(this.server, this.getContext(this.snmpTargetMIB));
            this.snmpNotificationMIB.registerMOs(this.server, this.getContext(this.snmpNotificationMIB));
            this.vacmMIB.registerMOs(this.server, this.getContext(this.vacmMIB));
            this.usmMIB.registerMOs(this.server, this.getContext(this.usmMIB));
            this.snmpv2MIB.registerMOs(this.server, this.getContext(this.snmpv2MIB));
            this.snmpMpdMib.registerMOs(this.server, this.getContext(this.snmpMpdMib));
            this.snmpFrameworkMIB.registerMOs(this.server, this.getContext(this.snmpFrameworkMIB));
            this.snmpCommunityMIB.registerMOs(this.server, this.getContext(this.snmpCommunityMIB));
            this.snmp4jLogMIB.registerMOs(this.server, this.getContext(this.snmp4jLogMIB));
            if (this.snmp4jConfigMIB != null) {
                this.snmp4jConfigMIB.registerMOs(this.server, this.getContext(this.snmp4jConfigMIB));
            }
            this.snmpProxyMIB.registerMOs(this.server, this.getContext(this.snmpProxyMIB));
            this.registerManagedObjects();
        }
        catch (DuplicateRegistrationException ex) {
            ex.printStackTrace();
        }
    }

    protected void unregisterSnmpMIBs() {
        this.snmpTargetMIB.unregisterMOs(this.server, this.getContext(this.snmpTargetMIB));
        this.snmpNotificationMIB.unregisterMOs(this.server, this.getContext(this.snmpNotificationMIB));
        this.vacmMIB.unregisterMOs(this.server, this.getContext(this.vacmMIB));
        this.usmMIB.unregisterMOs(this.server, this.getContext(this.usmMIB));
        this.snmpv2MIB.unregisterMOs(this.server, this.getContext(this.snmpv2MIB));
        this.snmpFrameworkMIB.unregisterMOs(this.server, this.getContext(this.snmpFrameworkMIB));
        this.snmpCommunityMIB.unregisterMOs(this.server, this.getContext(this.snmpCommunityMIB));
        this.snmp4jLogMIB.unregisterMOs(this.server, this.getContext(this.snmp4jLogMIB));
        if (this.snmp4jConfigMIB != null) {
            this.snmp4jConfigMIB.unregisterMOs(this.server, this.getContext(this.snmp4jConfigMIB));
        }
        this.snmpProxyMIB.unregisterMOs(this.server, this.getContext(this.snmpProxyMIB));
        this.unregisterManagedObjects();
    }

    protected abstract void registerManagedObjects();

    protected abstract void unregisterManagedObjects();

    protected void setupDefaultProxyForwarder() {
        this.defaultProxyForwarder = new ProxyForwarderImpl((Session)this.session, this.snmpProxyMIB, this.snmpTargetMIB);
        this.agent.addProxyForwarder(this.defaultProxyForwarder, null, 0);
        ((ProxyForwarderImpl)this.defaultProxyForwarder).addCounterListener(this.snmpv2MIB);
    }

    public void loadConfig(int importMode) {
        try {
            this.defaultPersistenceProvider.restore(null, importMode);
        }
        catch (IOException ex) {
            logger.error((Serializable)ex);
        }
    }

    public void saveConfig() {
        try {
            this.defaultPersistenceProvider.store(this.configFileURI, this.snmp4jConfigMIB);
        }
        catch (IOException ex) {
            logger.error((Serializable)ex);
        }
    }

    protected void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BaseAgent.this.saveConfig();
            }
        });
    }

    protected void finishInit() {
        if (this.agentState < 10) {
            logger.fatal((Object)("Agent initialization finish is called before initialization, current state is " + this.agentState));
        }
        this.agent.setNotificationOriginator(this.notificationOriginator);
        this.agent.addMOServer(this.server);
        this.agent.setCoexistenceProvider(this.snmpCommunityMIB);
        this.agent.setVacm(this.vacmMIB);
        this.dispatcher.addCommandResponder((CommandResponder)this.agent);
        this.agentState = 20;
    }

    protected void sendColdStartNotification() {
        this.notificationOriginator.notify(new OctetString(), SnmpConstants.coldStart, new VariableBinding[0]);
    }

    @Override
    public void run() {
        if (this.agentState < 20) {
            logger.fatal((Object)("Agent is run uninitialized, current state is " + this.agentState));
        }
        if (this.agentState == 30) {
            this.initSnmpSession();
        }
        try {
            this.session.listen();
            this.agentState = 40;
        }
        catch (IOException iox) {
            logger.error((Serializable)iox);
        }
    }

    public void stop() {
        if (this.agentState != 40) {
            logger.error((Serializable)((Object)("Agent is stopped although it is not running, current state is " + this.agentState)));
        }
        try {
            this.session.close();
        }
        catch (IOException ex) {
            logger.warn((Serializable)((Object)("Closing agent session threw IOException: " + ex.getMessage())));
        }
        this.session = null;
        this.agentState = 30;
    }

    protected void initMessageDispatcher() {
        this.dispatcher = new MessageDispatcherImpl();
        this.mpv3 = new MPv3(this.agent.getContextEngineID().getValue());
        this.usm = new USM(SecurityProtocols.getInstance(), this.agent.getContextEngineID(), this.updateEngineBoots());
        SecurityModels.getInstance().addSecurityModel((SecurityModel)this.usm);
        SecurityProtocols.getInstance().addDefaultProtocols();
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv1());
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)this.mpv3);
        this.initSnmpSession();
    }

    protected void initSnmpSession() {
        this.session = new Snmp((MessageDispatcher)this.dispatcher);
        for (TransportMapping<? extends Address> transportMapping : this.transportMappings) {
            try {
                this.session.addTransportMapping(transportMapping);
            }
            catch (Exception ex) {
                logger.warn((Serializable)((Object)("Failed to initialize transport mapping '" + transportMapping + "' with: " + ex.getMessage())));
            }
        }
        this.updateSession((Session)this.session);
    }

    protected void updateSession(Session session) {
        if (this.notificationOriginator instanceof NotificationOriginatorImpl) {
            ((NotificationOriginatorImpl)this.notificationOriginator).setSession(session);
        }
        if (this.defaultProxyForwarder instanceof ProxyForwarderImpl) {
            ((ProxyForwarderImpl)this.defaultProxyForwarder).setSession(session);
        }
    }

    protected int updateEngineBoots() {
        return this.bootCounterFile.updateEngineBoots();
    }

    protected int getEngineBoots() {
        return this.bootCounterFile.getEngineBoots();
    }

    protected abstract void addUsmUser(USM var1);

    protected abstract void addNotificationTargets(SnmpTargetMIB var1, SnmpNotificationMIB var2);

    protected abstract void addViews(VacmMIB var1);

    protected abstract void addCommunities(SnmpCommunityMIB var1);

    protected void initTransportMappings() throws IOException {
        this.transportMappings = new DefaultUdpTransportMapping[]{new DefaultUdpTransportMapping(new UdpAddress("0.0.0.0/161"))};
    }

    public NotificationOriginator getNotificationOriginator() {
        return this.notificationOriginator;
    }

    public void setDefaultProxyForwarder(ProxyForwarder defaultProxyForwarder) {
        this.defaultProxyForwarder = defaultProxyForwarder;
    }

    public void setSysDescr(OctetString sysDescr) {
        this.sysDescr.setValue(sysDescr.getValue());
    }

    public void setSysOID(OID sysOID) {
        this.sysOID.setValue(sysOID.getValue());
    }

    public void setSysServices(Integer32 sysServices) {
        this.sysServices.setValue(sysServices.getValue());
    }

    public void setAgent(CommandProcessor agent) {
        this.agent = agent;
    }

    public void setBootCounterFile(File bootCounterFile) {
        this.bootCounterFile = new EngineBootsCounterFile(bootCounterFile);
    }

    public void setConfigFile(File configFile) {
        this.configFileURI = configFile.getPath();
    }

    public void setDefaultContext(OctetString defaultContext) {
        this.defaultContext = defaultContext;
    }

    public ProxyForwarder getDefaultProxyForwarder() {
        return this.defaultProxyForwarder;
    }

    public OctetString getSysDescr() {
        return this.sysDescr;
    }

    public OID getSysOID() {
        return this.sysOID;
    }

    public Integer32 getSysServices() {
        return this.sysServices;
    }

    public CommandProcessor getAgent() {
        return this.agent;
    }

    public File getBootCounterFile() {
        return this.bootCounterFile.getBootCounterFile();
    }

    public File getConfigFile() {
        return new File(this.configFileURI);
    }

    public Snmp4jConfigMib getSnmp4jConfigMIB() {
        return this.snmp4jConfigMIB;
    }

    public Snmp4jLogMib getSnmp4jLogMIB() {
        return this.snmp4jLogMIB;
    }

    public SnmpCommunityMIB getSnmpCommunityMIB() {
        return this.snmpCommunityMIB;
    }

    public SnmpFrameworkMIB getSnmpFrameworkMIB() {
        return this.snmpFrameworkMIB;
    }

    public SnmpNotificationMIB getSnmpNotificationMIB() {
        return this.snmpNotificationMIB;
    }

    public SnmpProxyMIB getSnmpProxyMIB() {
        return this.snmpProxyMIB;
    }

    public SnmpTargetMIB getSnmpTargetMIB() {
        return this.snmpTargetMIB;
    }

    public SNMPv2MIB getSnmpv2MIB() {
        return this.snmpv2MIB;
    }

    public SnmpMpdMib getSnmpMpdMib() {
        return this.snmpMpdMib;
    }

    public UsmMIB getUsmMIB() {
        return this.usmMIB;
    }

    public VacmMIB getVacmMIB() {
        return this.vacmMIB;
    }

    public Snmp getSession() {
        return this.session;
    }

    public DefaultMOServer getServer() {
        return this.server;
    }

    public MPv3 getMPv3() {
        return this.mpv3;
    }

    public USM getUsm() {
        return this.usm;
    }

    public int getAgentState() {
        return this.agentState;
    }

    public OctetString getDefaultContext() {
        return this.defaultContext;
    }
}

