/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.snmp4j.agent.ContextListener;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServerLookupEvent;
import org.snmp4j.agent.MOServerLookupListener;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOFilter;
import org.snmp4j.agent.mo.lock.LockRequest;
import org.snmp4j.smi.OctetString;

public interface MOServer {
    public void addContextListener(ContextListener var1);

    public void removeContextListener(ContextListener var1);

    public void addContext(OctetString var1);

    public void removeContext(OctetString var1);

    public void register(ManagedObject<?> var1, OctetString var2) throws DuplicateRegistrationException;

    default public boolean registerNew(ManagedObject<?> mo, OctetString context) {
        try {
            this.register(mo, context);
            return true;
        }
        catch (DuplicateRegistrationException drex) {
            return false;
        }
    }

    public ManagedObject<?> unregister(ManagedObject<?> var1, OctetString var2);

    default public Iterator<Map.Entry<MOScope, ManagedObject<?>>> iterator(Comparator<MOScope> comparator) {
        return this.iterator(comparator, null);
    }

    public Iterator<Map.Entry<MOScope, ManagedObject<?>>> iterator(Comparator<MOScope> var1, MOFilter var2);

    public void addLookupListener(MOServerLookupListener var1, ManagedObject<?> var2);

    public boolean removeLookupListener(MOServerLookupListener var1, ManagedObject<?> var2);

    default public ManagedObject<?> lookup(MOQuery query) {
        return this.lookup(query, null, new MOServerLookupEvent(this, null, query, MOServerLookupEvent.IntendedUse.undefined), ManagedObject.class);
    }

    default public <MO extends ManagedObject<?>> MO lookup(MOQuery query, Class<MO> managedObjectType) {
        return this.lookup(query, null, new MOServerLookupEvent(this, null, query, MOServerLookupEvent.IntendedUse.undefined), managedObjectType);
    }

    @Deprecated
    default public ManagedObject<?> lookup(MOQuery query, LockRequest lockRequest) {
        return this.lookup(query, lockRequest, new MOServerLookupEvent(this, null, query, MOServerLookupEvent.IntendedUse.undefined));
    }

    default public ManagedObject<?> lookup(MOQuery query, LockRequest lockRequest, MOServerLookupEvent lookupEvent) {
        return this.lookup(query, lockRequest, lookupEvent, ManagedObject.class);
    }

    public <MO extends ManagedObject<?>> MO lookup(MOQuery var1, LockRequest var2, MOServerLookupEvent var3, Class<MO> var4);

    public Iterator<Map.Entry<MOScope, ManagedObject<?>>> iterator();

    public boolean lock(Object var1, ManagedObject<?> var2);

    public boolean lock(Object var1, ManagedObject<?> var2, long var3);

    public boolean unlock(Object var1, ManagedObject<?> var2);

    public OctetString[] getContexts();

    public boolean isContextSupported(OctetString var1);

    public OctetString[] getRegisteredContexts(ManagedObject<?> var1);

    public Map<OctetString, MOScope> getRegisteredScopes(ManagedObject<?> var1);
}

