/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.KeyChange;
import org.snmp4j.agent.mo.snmp.UsmMIB;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.smi.OctetString;

public class UsmKeyChange
extends KeyChange {
    public static final int AUTH_KEY_CHANGE = 0;
    public static final int PRIV_KEY_CHANGE = 1;
    private int type;

    public UsmKeyChange(int columnID, MOAccess access, int type) {
        super(columnID, access, new OctetString(), true);
        this.type = type;
    }

    @Override
    public void prepare(SubRequest<?> subRequest, MOTableRow row, MOTableRow changeSet, int column) {
        super.prepare(subRequest, row, changeSet, column);
        if (!subRequest.hasError()) {
            UsmMIB.UsmTableRow usmRow = (UsmMIB.UsmTableRow)row;
            int digestLength = this.getDigestLength(usmRow, changeSet);
            if (digestLength <= 0) {
                subRequest.completed();
                return;
            }
            OctetString v = (OctetString)subRequest.getVariableBinding().getVariable();
            if (v.length() != digestLength) {
                subRequest.getStatus().setErrorStatus(10);
            }
        }
    }

    protected int getDigestLength(UsmMIB.UsmTableRow row, MOTableRow changeSet) {
        switch (this.type) {
            case 0: {
                AuthenticationProtocol a = row.getAuthProtocol(changeSet);
                if (a == null) break;
                return a.getDigestLength() * 2;
            }
            case 1: {
                PrivacyProtocol p = row.getPrivProtocol(changeSet);
                if (p == null) break;
                return p.getMaxKeyLength() * 2;
            }
        }
        return -1;
    }

    @Override
    public void commit(SubRequest<?> subRequest, MOTableRow row, MOTableRow changeSet, int column) {
        int digestLength = this.getDigestLength((UsmMIB.UsmTableRow)row, changeSet);
        if (digestLength > 0) {
            super.commit(subRequest, row, changeSet, column);
        } else {
            subRequest.completed();
        }
    }
}

