/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import org.snmp4j.agent.mo.DefaultMOTableModel;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOTableModelEvent;
import org.snmp4j.agent.mo.MOTableModelListener;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableRowFilter;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DefaultMOMutableTableModel<R extends MOTableRow>
extends DefaultMOTableModel<R>
implements MOMutableTableModel<R> {
    protected MOTableRowFactory<R> rowFactory;
    private transient List<MOTableModelListener> moTableModelListeners;

    @Override
    public MOTableRowFactory<R> getRowFactory() {
        return this.rowFactory;
    }

    public synchronized List<MOTableRow> getRows(OID lowerBound, OID upperBoundEx) {
        return new ArrayList<MOTableRow>(this.getView(lowerBound, upperBoundEx).values());
    }

    public synchronized List<R> getRows(OID lowerBound, OID upperBoundEx, MOTableRowFilter<R> filter) {
        LinkedList<MOTableRow> result = new LinkedList<MOTableRow>();
        SortedMap<OID, R> view = this.getView(lowerBound, upperBoundEx);
        for (MOTableRow row : view.values()) {
            if (!filter.passesFilter(row)) continue;
            result.add(row);
        }
        return result;
    }

    private SortedMap<OID, R> getView(OID lowerBound, OID upperBoundEx) {
        SortedMap view = lowerBound == null && upperBoundEx == null ? this.rows : (lowerBound == null ? this.rows.headMap(upperBoundEx) : (upperBoundEx == null ? this.rows.tailMap(lowerBound) : this.rows.subMap(lowerBound, upperBoundEx)));
        return view;
    }

    @Override
    public synchronized R removeRow(OID index) {
        MOTableRow row = (MOTableRow)this.rows.remove(index);
        if (row != null && this.moTableModelListeners != null) {
            MOTableModelEvent event = new MOTableModelEvent(this, 2, row);
            this.fireTableModelChanged(event);
        }
        return (R)row;
    }

    public synchronized void removeRows(OID lowerBoundIncl, OID upperBoundExcl) {
        SortedMap m = lowerBoundIncl == null ? this.rows : this.rows.tailMap(lowerBoundIncl);
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry item = it.next();
            if (upperBoundExcl != null && upperBoundExcl.compareTo((Variable)item.getKey()) <= 0) break;
            if (this.moTableModelListeners != null) {
                MOTableModelEvent event = new MOTableModelEvent(this, 2, (MOTableRow)item.getValue());
                this.fireTableModelChanged(event);
            }
            it.remove();
        }
    }

    @Override
    public synchronized void clear() {
        this.fireTableModelChanged(new MOTableModelEvent(this, 3));
        this.rows.clear();
    }

    @Override
    public synchronized List<R> clear(MOTableRowFilter<R> filter) {
        ArrayList<MOTableRow> removedRows = new ArrayList<MOTableRow>();
        Iterator it = this.rows.values().iterator();
        while (it.hasNext()) {
            MOTableRow row = (MOTableRow)it.next();
            if (filter.passesFilter(row)) continue;
            if (this.moTableModelListeners != null) {
                MOTableModelEvent event = new MOTableModelEvent(this, 2, row);
                this.fireTableModelChanged(event);
            }
            it.remove();
            removedRows.add(row);
        }
        return removedRows;
    }

    public synchronized Iterator<R> iterator(MOTableRowFilter<R> filter) {
        return new FilteredRowIterator(filter);
    }

    @Override
    public R createRow(OID index, Variable[] values) throws UnsupportedOperationException {
        if (this.rowFactory == null) {
            throw new UnsupportedOperationException("No row factory");
        }
        return this.rowFactory.createRow(index, values);
    }

    @Override
    public void setRowFactory(MOTableRowFactory<R> rowFactory) {
        this.rowFactory = rowFactory;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    @Override
    public void freeRow(R row) {
        if (this.rowFactory != null) {
            this.rowFactory.freeRow(row);
        }
    }

    public synchronized void addMOTableModelListener(MOTableModelListener l) {
        if (this.moTableModelListeners == null) {
            this.moTableModelListeners = new ArrayList<MOTableModelListener>(2);
        }
        this.moTableModelListeners.add(l);
    }

    public synchronized void removeMOTableModelListener(MOTableModelListener l) {
        if (this.moTableModelListeners != null) {
            this.moTableModelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTableModelChanged(MOTableModelEvent event) {
        List<MOTableModelListener> listeners = this.moTableModelListeners;
        if (listeners != null) {
            List<MOTableModelListener> list = listeners;
            synchronized (list) {
                for (MOTableModelListener listener : listeners) {
                    listener.tableModelChanged(event);
                }
            }
        }
    }

    @Override
    public R addRow(R row) {
        R replacedRow = super.addRow(row);
        if (this.moTableModelListeners != null) {
            MOTableModelEvent event = new MOTableModelEvent(this, 1, (MOTableRow)row);
            this.fireTableModelChanged(event);
        }
        return replacedRow;
    }

    public class FilteredRowIterator
    implements Iterator<R> {
        private Iterator<R> iterator;
        private MOTableRowFilter<R> filter;
        private R next;

        FilteredRowIterator(MOTableRowFilter<R> filter) {
            this.filter = filter;
            this.iterator = DefaultMOMutableTableModel.this.iterator();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.findNext();
            return this.next != null;
        }

        private void findNext() {
            while (this.iterator.hasNext()) {
                this.next = (MOTableRow)this.iterator.next();
                if (this.filter.passesFilter(this.next)) break;
                this.next = null;
            }
        }

        @Override
        public R next() {
            if (this.next == null) {
                this.findNext();
            }
            if (this.next != null) {
                Object retval = this.next;
                this.next = null;
                return retval;
            }
            throw new NoSuchElementException();
        }
    }
}

