/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp.dh;

import java.io.IOException;
import java.io.Serializable;
import java.security.KeyPair;
import java.util.Collection;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOFactoryAdapter;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableIndexValidator;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRelation;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.UsmMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.agent.mo.snmp.dh.DHKeyChangeImpl;
import org.snmp4j.agent.mo.snmp.dh.DHKeyInfo;
import org.snmp4j.agent.mo.snmp.dh.DHKickstartParameters;
import org.snmp4j.agent.mo.snmp.dh.UsmDHParametersImpl;
import org.snmp4j.agent.mo.snmp.tc.SnmpAdminStringTC;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.security.dh.DHOperations;
import org.snmp4j.security.dh.DHParameters;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SnmpUsmDhObjectsMib
implements MOGroup {
    private static final LogAdapter LOGGER = LogFactory.getLogger(SnmpUsmDhObjectsMib.class);
    private MOFactory moFactory = DefaultMOFactory.getInstance();
    public static final OID oidSnmpUsmDhObjectsMib = new OID(new int[]{1, 3, 6, 1, 3, 101});
    public static final OID oidUsmDHParameters = new OID(new int[]{1, 3, 6, 1, 3, 101, 1, 1, 1, 0});
    private static final String TC_MODULE_SNMP_USM_DH_OBJECTS_MIB = "SNMP-USM-DH-OBJECTS-MIB";
    private static final String TC_MODULE_SNMP_FRAMEWORK_MIB = "SNMP-FRAMEWORK-MIB";
    private static final String TC_DHKEYCHANGE = "DHKeyChangeImpl";
    private static final String TC_SNMPADMINSTRING = "SnmpAdminString";
    private UsmDHParametersImpl usmDHParameters;
    public static final OID oidUsmDHUserKeyEntry = new OID(new int[]{1, 3, 6, 1, 3, 101, 1, 1, 2, 1});
    public static final OID oidUsmUserEngineID = new OID(new int[]{1, 3, 6, 1, 6, 3, 15, 1, 2, 2, 1, 1});
    public static final OID oidUsmUserName = new OID(new int[]{1, 3, 6, 1, 6, 3, 15, 1, 2, 2, 1, 2});
    public static final String tcModuleSnmpUsmDhObjectsMib = "SNMP-USM-DH-OBJECTS-MIB";
    public static final String tcDefDHKeyChange = "DHKeyChangeImpl";
    public static final int colUsmDHUserAuthKeyChange = 1;
    public static final int colUsmDHUserOwnAuthKeyChange = 2;
    public static final int colUsmDHUserPrivKeyChange = 3;
    public static final int colUsmDHUserOwnPrivKeyChange = 4;
    public static final int idxUsmDHUserAuthKeyChange = 0;
    public static final int idxUsmDHUserOwnAuthKeyChange = 1;
    public static final int idxUsmDHUserPrivKeyChange = 2;
    public static final int idxUsmDHUserOwnPrivKeyChange = 3;
    private MOTableSubIndex[] usmDHUserKeyEntryIndexes;
    private MOTableIndex usmDHUserKeyEntryIndex;
    private MOTable<UsmDHUserKeyEntryRow, MOColumn, MOTableModel<UsmDHUserKeyEntryRow>> usmDHUserKeyEntry;
    private MOTableModel<UsmDHUserKeyEntryRow> usmDHUserKeyEntryModel;
    public static final OID oidUsmDHKickstartEntry = new OID(new int[]{1, 3, 6, 1, 3, 101, 1, 2, 1, 1});
    public static final OID oidUsmDHKickstartIndex = new OID(new int[]{1, 3, 6, 1, 3, 101, 1, 2, 1, 1, 1});
    public static final String tcModuleSnmpFrameworkMib = "SNMP-FRAMEWORK-MIB";
    public static final String tcDefSnmpAdminString = "SnmpAdminString";
    public static final int colUsmDHKickstartMyPublic = 2;
    public static final int colUsmDHKickstartMgrPublic = 3;
    public static final int colUsmDHKickstartSecurityName = 4;
    public static final int idxUsmDHKickstartMyPublic = 0;
    public static final int idxUsmDHKickstartMgrPublic = 1;
    public static final int idxUsmDHKickstartSecurityName = 2;
    private MOTableSubIndex[] usmDHKickstartEntryIndexes;
    private MOTableIndex usmDHKickstartEntryIndex;
    private MOTable<UsmDHKickstartEntryRow, MOColumn, MOTableModel<UsmDHKickstartEntryRow>> usmDHKickstartEntry;
    private MOTableModel<UsmDHKickstartEntryRow> usmDHKickstartEntryModel;
    private DefaultMOTable<UsmMIB.UsmTableRow, MOColumn, DefaultMOMutableTableModel<UsmMIB.UsmTableRow>> usmUserEntry;
    private MOTableRelation<UsmMIB.UsmTableRow, UsmDHUserKeyEntryRow> usmDHUserKeyEntryRelation;
    protected USM usm;
    protected UsmMIB usmMIB;
    protected VacmMIB vacmMIB;
    protected Collection<DHKickstartParameters> dhKickstartParameters;
    protected DHOperations dhOperations = new DHOperations();

    protected SnmpUsmDhObjectsMib() {
    }

    protected SnmpUsmDhObjectsMib(MOFactory moFactory) {
        this();
        this.moFactory = moFactory = new SnmpUsmDHObjectsMibFactoryAdapter(moFactory);
        this.createMO(moFactory);
    }

    public SnmpUsmDhObjectsMib(MOFactory moFactory, USM usm, UsmMIB usmMIB, VacmMIB vacmMIB, Collection<DHKickstartParameters> dhKickstartParameters) {
        this();
        this.usm = usm;
        this.usmMIB = usmMIB;
        this.vacmMIB = vacmMIB;
        this.dhKickstartParameters = dhKickstartParameters;
        this.moFactory = moFactory = new SnmpUsmDHObjectsMibFactoryAdapter(moFactory);
        this.createMO(moFactory);
    }

    protected void createMO(MOFactory moFactory) {
        this.addTCsToFactory(moFactory);
        this.usmDHParameters = new UsmDHParameters(oidUsmDHParameters, moFactory.createAccess(11));
        this.usmDHParameters.addMOValueValidationListener(new UsmDHParametersValidator());
        this.createUsmDHUserKeyEntry(moFactory);
        this.createUsmDHKickstartEntry(moFactory);
    }

    public UsmDHParametersImpl getUsmDHParameters() {
        return this.usmDHParameters;
    }

    public MOTable<UsmDHUserKeyEntryRow, MOColumn, MOTableModel<UsmDHUserKeyEntryRow>> getUsmDHUserKeyEntry() {
        return this.usmDHUserKeyEntry;
    }

    public void setBaseTableUsmDHUserKeyEntry(DefaultMOTable<UsmMIB.UsmTableRow, MOColumn, DefaultMOMutableTableModel<UsmMIB.UsmTableRow>> baseTable) {
        if (baseTable == null) {
            if (this.usmUserEntry != null && this.usmDHUserKeyEntryRelation != null) {
                this.usmUserEntry.removeMOTableRowListener(this.usmDHUserKeyEntryRelation.getRelationShipListener());
            }
        } else {
            this.usmUserEntry = baseTable;
            this.usmDHUserKeyEntryRelation = this.moFactory.createTableRelation(baseTable, this.usmDHUserKeyEntry);
            this.usmDHUserKeyEntryRelation.createRelationShip();
        }
    }

    private void createUsmDHUserKeyEntry(MOFactory moFactory) {
        this.usmDHUserKeyEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidUsmUserEngineID, 4, 5, 32), moFactory.createSubIndex(oidUsmUserName, 4, 1, 32)};
        this.usmDHUserKeyEntryIndex = moFactory.createIndex(this.usmDHUserKeyEntryIndexes, false, new MOTableIndexValidator(){

            @Override
            public boolean isValidIndex(OID index) {
                boolean isValidIndex = true;
                return isValidIndex;
            }
        });
        MOColumn[] usmDHUserKeyEntryColumns = new MOColumn[]{new DHKeyChangeImpl(1, moFactory.createAccess(15), null, this.usmDHParameters.getDHParamters(), this.usmMIB, DHOperations.KeyType.authKeyChange), new DHKeyChangeImpl(2, moFactory.createAccess(15), null, this.usmDHParameters.getDHParamters(), this.usmMIB, DHOperations.KeyType.authKeyChange), new DHKeyChangeImpl(3, moFactory.createAccess(15), null, this.usmDHParameters.getDHParamters(), this.usmMIB, DHOperations.KeyType.privKeyChange), new DHKeyChangeImpl(4, moFactory.createAccess(15), null, this.usmDHParameters.getDHParamters(), this.usmMIB, DHOperations.KeyType.privKeyChange)};
        this.usmDHUserKeyEntryModel = moFactory.createTableModel(oidUsmDHUserKeyEntry, this.usmDHUserKeyEntryIndex, usmDHUserKeyEntryColumns);
        ((MOMutableTableModel)this.usmDHUserKeyEntryModel).setRowFactory(new UsmDHUserKeyEntryRowFactory());
        this.usmDHUserKeyEntry = moFactory.createTable(oidUsmDHUserKeyEntry, this.usmDHUserKeyEntryIndex, usmDHUserKeyEntryColumns, this.usmDHUserKeyEntryModel);
    }

    public MOTable<UsmDHKickstartEntryRow, MOColumn, MOTableModel<UsmDHKickstartEntryRow>> getUsmDHKickstartEntry() {
        return this.usmDHKickstartEntry;
    }

    private void createUsmDHKickstartEntry(MOFactory moFactory) {
        this.usmDHKickstartEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidUsmDHKickstartIndex, 2, 1, 1)};
        this.usmDHKickstartEntryIndex = moFactory.createIndex(this.usmDHKickstartEntryIndexes, false, new MOTableIndexValidator(){

            @Override
            public boolean isValidIndex(OID index) {
                boolean isValidIndex = true;
                return isValidIndex;
            }
        });
        MOColumn[] usmDHKickstartEntryColumns = new MOColumn[]{moFactory.createColumn(2, 4, moFactory.createAccess(9)), moFactory.createColumn(3, 4, moFactory.createAccess(9)), moFactory.createColumn(4, 4, moFactory.createAccess(9), "SNMP-FRAMEWORK-MIB", "SnmpAdminString")};
        this.usmDHKickstartEntryModel = moFactory.createTableModel(oidUsmDHKickstartEntry, this.usmDHKickstartEntryIndex, usmDHKickstartEntryColumns);
        ((MOMutableTableModel)this.usmDHKickstartEntryModel).setRowFactory(new UsmDHKickstartEntryRowFactory());
        this.usmDHKickstartEntry = moFactory.createTable(oidUsmDHKickstartEntry, this.usmDHKickstartEntryIndex, usmDHKickstartEntryColumns, this.usmDHKickstartEntryModel);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.usmDHParameters, context);
        server.register(this.usmDHUserKeyEntry, context);
        server.register(this.usmDHKickstartEntry, context);
        if (this.usmMIB != null) {
            this.setBaseTableUsmDHUserKeyEntry(this.usmMIB.getUsmUserEntry());
            if (this.dhKickstartParameters != null) {
                this.initDHKickstart(this.dhKickstartParameters);
            }
        }
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.usmDHParameters, context);
        server.unregister(this.usmDHUserKeyEntry, context);
        server.unregister(this.usmDHKickstartEntry, context);
        if (this.usmMIB != null) {
            this.setBaseTableUsmDHUserKeyEntry(null);
        }
        if (this.vacmMIB != null) {
            // empty if block
        }
    }

    public DHParameters getDHParameters() {
        try {
            return DHParameters.getDHParametersFromBER((OctetString)new OctetString(this.usmDHParameters.getValue()));
        }
        catch (IOException e) {
            LOGGER.error((CharSequence)("Unable to decode usmDHParameters value '" + this.usmDHParameters.getValue().toHexString() + "'"), (Throwable)e);
            return null;
        }
    }

    protected void initDHKickstart(Collection<DHKickstartParameters> dhKickstartParametersList) {
        int kickStartRowIndex = 1;
        for (DHKickstartParameters dhKickstartParameters : dhKickstartParametersList) {
            try {
                OID authProtocol = SnmpConstants.usmHMACMD5AuthProtocol;
                if (dhKickstartParameters.getAuthenticationProtocol() != null) {
                    authProtocol = dhKickstartParameters.getAuthenticationProtocol();
                }
                OID privProtocol = SnmpConstants.usmDESPrivProtocol;
                if (dhKickstartParameters.getPrivacyProtocol() != null) {
                    privProtocol = dhKickstartParameters.getPrivacyProtocol();
                }
                DHParameters dhParameters = this.getDHParameters();
                KeyPair keyPair = DHOperations.generatePublicKey((DHParameters)dhParameters);
                KeyAgreement keyAgreement = DHOperations.getInitializedKeyAgreement((KeyPair)keyPair);
                byte[] sharedKey = DHOperations.computeSharedKey((KeyAgreement)keyAgreement, (byte[])dhKickstartParameters.getPublicKey().getValue(), (DHParameters)dhParameters);
                AuthenticationProtocol authenticationProtocol = SecurityProtocols.getInstance().getAuthenticationProtocol(authProtocol);
                if (authenticationProtocol == null) {
                    LOGGER.warn((Serializable)((Object)("Unknown authentication protocol '" + authProtocol + " for kickstart DH key exchange: " + dhKickstartParameters)));
                    continue;
                }
                OctetString authKey = new OctetString(DHOperations.deriveKeyPBKDF2((byte[])sharedKey, (int)authenticationProtocol.getDigestLength(), (SecurityProtocols.SecurityProtocolType)SecurityProtocols.SecurityProtocolType.authentication));
                PrivacyProtocol privacyProtocol = SecurityProtocols.getInstance().getPrivacyProtocol(privProtocol);
                if (privacyProtocol == null) {
                    LOGGER.warn((Serializable)((Object)("Unknown privacy protocol '" + privProtocol + " for kickstart DH key exchange: " + dhKickstartParameters)));
                    continue;
                }
                OctetString privKey = new OctetString(DHOperations.deriveKeyPBKDF2((byte[])sharedKey, (int)privacyProtocol.getMaxKeyLength(), (SecurityProtocols.SecurityProtocolType)SecurityProtocols.SecurityProtocolType.privacy));
                UsmUserEntry usmUserEntry = new UsmUserEntry(dhKickstartParameters.getSecurityName(), this.usm.getLocalEngineID(), new UsmUser(dhKickstartParameters.getSecurityName(), authProtocol, authKey, privProtocol, privKey, this.usm.getLocalEngineID()));
                usmUserEntry.setStorageType(SnmpConstants.StorageTypeEnum.permanent);
                this.usm.getUserTable().addUser(usmUserEntry);
                if (this.usm.getUserTable().getUser(dhKickstartParameters.getSecurityName()) == null || dhKickstartParameters.isResetRequested()) {
                    this.usm.addUsmUserEntry(usmUserEntry);
                    UsmDHKickstartEntryRow kickstartEntryRow = this.usmDHKickstartEntry.addNewRow(new OID(new int[]{kickStartRowIndex++}), new Variable[]{DHOperations.derivePublicKey((KeyPair)keyPair), dhKickstartParameters.getPublicKey(), dhKickstartParameters.getSecurityName()});
                    if (kickstartEntryRow == null) {
                        LOGGER.warn((Serializable)((Object)("USM kickstart row not created for '" + dhKickstartParameters.getSecurityName() + "'")));
                        continue;
                    }
                    if (dhKickstartParameters.getVacmRole() == null) continue;
                    this.vacmMIB.addGroup(3, dhKickstartParameters.getSecurityName(), this.getGroupNameForVacmRole(dhKickstartParameters.getVacmRole()), SnmpConstants.StorageTypeEnum.permanent.getSmiValue());
                    continue;
                }
                LOGGER.warn((Serializable)((Object)("USM kickstart user " + dhKickstartParameters + " not created because security name already exists")));
            }
            catch (Exception ex) {
                LOGGER.error((CharSequence)("Unable to kickstart Diffie Hellman USM key exchange for " + dhKickstartParameters), (Throwable)ex);
                ex.printStackTrace();
            }
        }
        OctetString dhKickstart = new OctetString("dhKickstart");
        OctetString dhKickstartReadView = new OctetString("dhKickRestricted");
        this.usm.getUserTable().addUser(new UsmUserEntry(dhKickstart, new UsmUser(dhKickstart, SnmpConstants.usmNoAuthProtocol, null, SnmpConstants.usmNoPrivProtocol, null)));
        this.vacmMIB.addGroup(3, dhKickstart, dhKickstart, SnmpConstants.StorageTypeEnum.permanent.getSmiValue());
        this.vacmMIB.addAccess(dhKickstart, null, 3, 1, 2, dhKickstartReadView, null, dhKickstartReadView, SnmpConstants.StorageTypeEnum.permanent.getSmiValue());
        this.vacmMIB.addViewTreeFamily(dhKickstartReadView, SnmpConstants.system, new OctetString(), 1, SnmpConstants.StorageTypeEnum.permanent.getSmiValue());
        this.vacmMIB.addViewTreeFamily(dhKickstartReadView, oidUsmDHKickstartEntry, new OctetString(), 1, SnmpConstants.StorageTypeEnum.permanent.getSmiValue());
    }

    protected OctetString getGroupNameForVacmRole(String role) {
        return new OctetString(role);
    }

    protected void addTCsToFactory(MOFactory moFactory) {
        moFactory.addTextualConvention(new DHKeyChange());
    }

    public void addImportedTCsToFactory(MOFactory moFactory) {
        moFactory.addTextualConvention(new SnmpAdminStringTC());
    }

    private class SnmpUsmDHObjectsMibFactoryAdapter
    extends MOFactoryAdapter {
        public SnmpUsmDHObjectsMibFactoryAdapter(MOFactory moFactory) {
            super(moFactory);
        }

        @Override
        public <BaseRow extends MOTableRow, DependentRow extends MOTableRow> MOTableRelation<BaseRow, DependentRow> createTableRelation(MOTable<BaseRow, ? extends MOColumn, ? extends MOTableModel<BaseRow>> baseTable, MOTable<DependentRow, ? extends MOColumn, ? extends MOTableModel<DependentRow>> dependentTable) {
            return new MOTableRelation<BaseRow, DependentRow>(baseTable, dependentTable){

                @Override
                public boolean hasDependentRow(BaseRow baseTableRow) {
                    return true;
                }
            };
        }
    }

    public class DHKeyChange
    implements TextualConvention<OctetString> {
        @Override
        public String getModuleName() {
            return "SNMP-USM-DH-OBJECTS-MIB";
        }

        @Override
        public String getName() {
            return "DHKeyChangeImpl";
        }

        @Override
        public OctetString createInitialValue() {
            OctetString v = new OctetString();
            return v;
        }

        @Override
        public MOScalar<OctetString> createScalar(OID oid, MOAccess access, OctetString value) {
            MOScalar<OctetString> scalar = SnmpUsmDhObjectsMib.this.moFactory.createScalar(oid, access, value);
            return scalar;
        }

        @Override
        public MOColumn<OctetString> createColumn(int columnID, int syntax, MOAccess access, OctetString defaultValue, boolean mutableInService) {
            DHKeyChangeImpl col = SnmpUsmDhObjectsMib.this.moFactory.createColumn(columnID, syntax, access, defaultValue, mutableInService);
            DHOperations.KeyType keyType = DHOperations.KeyType.authKeyChange;
            if (columnID >= 3) {
                keyType = DHOperations.KeyType.privKeyChange;
            }
            col = new DHKeyChangeImpl(columnID, access, defaultValue, SnmpUsmDhObjectsMib.this.getDHParameters(), SnmpUsmDhObjectsMib.this.usmMIB, keyType);
            return col;
        }
    }

    class UsmDHKickstartEntryRowFactory
    implements MOTableRowFactory<UsmDHKickstartEntryRow> {
        UsmDHKickstartEntryRowFactory() {
        }

        @Override
        public synchronized UsmDHKickstartEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            UsmDHKickstartEntryRow row = new UsmDHKickstartEntryRow(index, values);
            return row;
        }

        @Override
        public synchronized void freeRow(UsmDHKickstartEntryRow row) {
        }
    }

    public class UsmDHKickstartEntryRow
    extends DefaultMOMutableRow2PC {
        public UsmDHKickstartEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getUsmDHKickstartMyPublic() {
            return (OctetString)super.getValue(0);
        }

        public void setUsmDHKickstartMyPublic(OctetString newColValue) {
            super.setValue(0, (Variable)newColValue);
        }

        public OctetString getUsmDHKickstartMgrPublic() {
            return (OctetString)super.getValue(1);
        }

        public void setUsmDHKickstartMgrPublic(OctetString newColValue) {
            super.setValue(1, (Variable)newColValue);
        }

        public OctetString getUsmDHKickstartSecurityName() {
            return (OctetString)super.getValue(2);
        }

        public void setUsmDHKickstartSecurityName(OctetString newColValue) {
            super.setValue(2, (Variable)newColValue);
        }

        @Override
        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return this.getUsmDHKickstartMyPublic();
                }
                case 1: {
                    return this.getUsmDHKickstartMgrPublic();
                }
                case 2: {
                    return this.getUsmDHKickstartSecurityName();
                }
            }
            return super.getValue(column);
        }

        @Override
        public void setValue(int column, Variable value) {
            switch (column) {
                case 0: {
                    this.setUsmDHKickstartMyPublic((OctetString)value);
                    break;
                }
                case 1: {
                    this.setUsmDHKickstartMgrPublic((OctetString)value);
                    break;
                }
                case 2: {
                    this.setUsmDHKickstartSecurityName((OctetString)value);
                    break;
                }
                default: {
                    super.setValue(column, value);
                }
            }
        }
    }

    class UsmDHUserKeyEntryRowFactory
    implements MOTableRowFactory<UsmDHUserKeyEntryRow> {
        UsmDHUserKeyEntryRowFactory() {
        }

        @Override
        public synchronized UsmDHUserKeyEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            UsmDHUserKeyEntryRow row = new UsmDHUserKeyEntryRow(index, values);
            return row;
        }

        @Override
        public synchronized void freeRow(UsmDHUserKeyEntryRow row) {
        }
    }

    public class UsmDHUserKeyEntryRow
    extends DefaultMOMutableRow2PC {
        private DHKeyInfo authKeyChange;
        private DHKeyInfo ownAuthKeyChange;
        private DHKeyInfo privKeyChange;
        private DHKeyInfo ownPrivKeyChange;

        public UsmDHUserKeyEntryRow(OID index, Variable[] values) {
            super(index, values);
            this.authKeyChange = new DHKeyInfo();
            this.ownAuthKeyChange = new DHKeyInfo();
            this.privKeyChange = new DHKeyInfo();
            this.ownPrivKeyChange = new DHKeyInfo();
        }

        public OctetString getUsmDHUserAuthKeyChange() {
            try {
                this.setValue(0, (Variable)new OctetString(((DHPublicKey)this.getAuthKeyChange().getKeyPair().getPublic()).getY().toByteArray()));
            }
            catch (NullPointerException npe) {
                this.setValue(0, (Variable)new OctetString());
            }
            return (OctetString)super.getValue(0);
        }

        public void setUsmDHUserAuthKeyChange(OctetString newColValue) {
            super.setValue(0, (Variable)newColValue);
        }

        public OctetString getUsmDHUserOwnAuthKeyChange() {
            try {
                this.setValue(1, (Variable)new OctetString(((DHPublicKey)this.getOwnAuthKeyChange().getKeyPair().getPublic()).getY().toByteArray()));
            }
            catch (NullPointerException npe) {
                this.setValue(1, (Variable)new OctetString());
            }
            return (OctetString)super.getValue(1);
        }

        public void setUsmDHUserOwnAuthKeyChange(OctetString newColValue) {
            super.setValue(1, (Variable)newColValue);
        }

        public OctetString getUsmDHUserPrivKeyChange() {
            try {
                this.setValue(2, (Variable)new OctetString(((DHPublicKey)this.getPrivKeyChange().getKeyPair().getPublic()).getY().toByteArray()));
            }
            catch (NullPointerException npe) {
                this.setValue(2, (Variable)new OctetString());
            }
            return (OctetString)super.getValue(2);
        }

        public void setUsmDHUserPrivKeyChange(OctetString newColValue) {
            super.setValue(2, (Variable)newColValue);
        }

        public OctetString getUsmDHUserOwnPrivKeyChange() {
            try {
                this.setValue(3, (Variable)new OctetString(((DHPublicKey)this.getOwnPrivKeyChange().getKeyPair().getPublic()).getY().toByteArray()));
            }
            catch (NullPointerException npe) {
                this.setValue(3, (Variable)new OctetString());
            }
            return (OctetString)super.getValue(3);
        }

        public void setUsmDHUserOwnPrivKeyChange(OctetString newColValue) {
            super.setValue(3, (Variable)newColValue);
        }

        @Override
        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return this.getUsmDHUserAuthKeyChange();
                }
                case 1: {
                    return this.getUsmDHUserOwnAuthKeyChange();
                }
                case 2: {
                    return this.getUsmDHUserPrivKeyChange();
                }
                case 3: {
                    return this.getUsmDHUserOwnPrivKeyChange();
                }
            }
            return super.getValue(column);
        }

        @Override
        public void setValue(int column, Variable value) {
            switch (column) {
                case 0: {
                    this.setUsmDHUserAuthKeyChange((OctetString)value);
                    break;
                }
                case 1: {
                    this.setUsmDHUserOwnAuthKeyChange((OctetString)value);
                    break;
                }
                case 2: {
                    this.setUsmDHUserPrivKeyChange((OctetString)value);
                    break;
                }
                case 3: {
                    this.setUsmDHUserOwnPrivKeyChange((OctetString)value);
                    break;
                }
                default: {
                    super.setValue(column, value);
                }
            }
        }

        public MOTableIndex getIndexDef() {
            return SnmpUsmDhObjectsMib.this.usmUserEntry.getIndexDef();
        }

        public AuthenticationProtocol getAuthProtocol(MOTableRow changeSet) {
            OID authOID = ((UsmMIB.UsmTableRow)this.getBaseRow()).getAuthProtocolOID(changeSet);
            return SnmpUsmDhObjectsMib.this.usmMIB.getSecurityProtocols().getAuthenticationProtocol(authOID);
        }

        public PrivacyProtocol getPrivProtocol(MOTableRow changeSet) {
            OID privOID = ((UsmMIB.UsmTableRow)this.getBaseRow()).getPrivProtocolOID(changeSet);
            return SnmpUsmDhObjectsMib.this.usmMIB.getSecurityProtocols().getPrivacyProtocol(privOID);
        }

        @Override
        public void commitRow(SubRequest<?> subRequest, MOTableRow changeSet) {
            MOTableRow baseRow;
            super.commitRow(subRequest, changeSet);
            if (subRequest.getErrorStatus() == 0 && (baseRow = this.getBaseRow()) instanceof UsmMIB.UsmTableRow) {
                UsmMIB.UsmTableRow usmTableRow = (UsmMIB.UsmTableRow)baseRow;
                if (this.isKeyChangePending()) {
                    DefaultMOMutableRow2PC changeSetBaseRow = new DefaultMOMutableRow2PC(baseRow.getIndex(), new Variable[SnmpUsmDhObjectsMib.this.usmMIB.getUsmUserEntry().getColumnCount()]);
                    usmTableRow.commitRow(subRequest, (MOTableRow)changeSetBaseRow);
                    usmTableRow.clearKeyChangeObjects();
                }
            }
        }

        public DHKeyInfo getAuthKeyChange() {
            return this.authKeyChange;
        }

        public DHKeyInfo getOwnAuthKeyChange() {
            return this.ownAuthKeyChange;
        }

        public DHKeyInfo getPrivKeyChange() {
            return this.privKeyChange;
        }

        public DHKeyInfo getOwnPrivKeyChange() {
            return this.ownPrivKeyChange;
        }

        public byte[] getNewAuthKey() {
            if (this.authKeyChange.getUsmKey() != null) {
                return this.authKeyChange.getUsmKey();
            }
            if (this.ownAuthKeyChange.getUsmKey() != null) {
                return this.ownAuthKeyChange.getUsmKey();
            }
            return null;
        }

        public byte[] getNewPrivKey() {
            if (this.privKeyChange.getUsmKey() != null) {
                return this.privKeyChange.getUsmKey();
            }
            if (this.ownPrivKeyChange.getUsmKey() != null) {
                return this.ownPrivKeyChange.getUsmKey();
            }
            return null;
        }

        public void clearDHKeyChange() {
            this.authKeyChange.clearUsmKey();
            this.ownAuthKeyChange.clearUsmKey();
            this.privKeyChange.clearUsmKey();
            this.ownPrivKeyChange.clearUsmKey();
        }

        public boolean isKeyChangePending() {
            return this.authKeyChange.isKeyChangePending() || this.ownAuthKeyChange.isKeyChangePending() || this.privKeyChange.isKeyChangePending() || this.ownPrivKeyChange.isKeyChangePending();
        }
    }

    static class UsmDHParametersValidator
    implements MOValueValidationListener {
        UsmDHParametersValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            if (newValue instanceof OctetString) {
                try {
                    DHParameters.getDHParametersFromBER((OctetString)((OctetString)newValue));
                }
                catch (IOException e) {
                    validationEvent.setValidationStatus(9);
                }
            } else {
                validationEvent.setValidationStatus(7);
            }
        }
    }

    public class UsmDHParameters
    extends UsmDHParametersImpl {
        UsmDHParameters(OID oid, MOAccess access) {
            super(oid, access, new OctetString());
        }

        @Override
        public int isValueOK(SubRequest<?> request) {
            Variable newValue = request.getVariableBinding().getVariable();
            int valueOK = super.isValueOK(request);
            if (valueOK != 0) {
                return valueOK;
            }
            return valueOK;
        }

        @Override
        public OctetString getValue() {
            return super.getValue();
        }

        @Override
        public int setValue(OctetString newValue) {
            try {
                this.decodeBER(newValue);
            }
            catch (IOException e) {
                return 14;
            }
            return super.setValue(newValue);
        }
    }
}

