/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp4j;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.DisplayString;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.EnumeratedScalar;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class Snmp4jConfigMib
implements MOGroup {
    private static final LogAdapter logger = LogFactory.getLogger(Snmp4jConfigMib.class);
    private static MOFactory moFactory = DefaultMOFactory.getInstance();
    public static final OID oidSnmp4jCfgSecSrcAddrValidation = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 2, 1, 1, 1, 0});
    private MOScalar<Integer32> snmp4jCfgSecSrcAddrValidation;
    public static final OID oidSnmp4jCfgStorageEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 2, 1, 2, 1, 1});
    public static final int colSnmp4jCfgStoragePath = 2;
    public static final int colSnmp4jCfgStorageID = 10;
    public static final int colSnmp4jCfgStorageLastStore = 4;
    public static final int colSnmp4jCfgStorageLastRestore = 5;
    public static final int colSnmp4jCfgStorageRestoreMode = 6;
    public static final int colSnmp4jCfgStorageOperation = 7;
    public static final int colSnmp4jCfgStorageStorageType = 8;
    public static final int colSnmp4jCfgStorageStatus = 9;
    public static final int idxSnmp4jCfgStoragePath = 0;
    public static final int idxSnmp4jCfgStorageID = 7;
    public static final int idxSnmp4jCfgStorageLastStore = 1;
    public static final int idxSnmp4jCfgStorageLastRestore = 2;
    public static final int idxSnmp4jCfgStorageRestoreMode = 3;
    public static final int idxSnmp4jCfgStorageOperation = 4;
    public static final int idxSnmp4jCfgStorageStorageType = 5;
    public static final int idxSnmp4jCfgStorageStatus = 6;
    private static MOTableSubIndex[] snmp4jCfgStorageEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(null, 4, 0, 255)};
    private static MOTableIndex snmp4jCfgStorageEntryIndex = moFactory.createIndex(snmp4jCfgStorageEntryIndexes, false);
    private MOTable<Snmp4jCfgStorageEntryRow, MOColumn, MOMutableTableModel<Snmp4jCfgStorageEntryRow>> snmp4jCfgStorageEntry;
    private MOMutableTableModel<Snmp4jCfgStorageEntryRow> snmp4jCfgStorageEntryModel;
    public static final OID PRIMARY_INDEX = new OctetString("primary").toSubIndex(false);
    protected SnmpCommunityMIB snmpCommunityMIB;
    protected Map<CharSequence, MOPersistenceProvider> persistenceProvider = new LinkedHashMap<CharSequence, MOPersistenceProvider>();
    protected MOPersistenceProvider primaryPersistence;
    protected SysUpTime sysUpTime;
    private File configPathRoot;

    public Snmp4jConfigMib(SysUpTime sysUpTime) {
        this.sysUpTime = sysUpTime;
        this.snmp4jCfgSecSrcAddrValidation = new Snmp4jCfgSecSrcAddrValidation(oidSnmp4jCfgSecSrcAddrValidation, MOAccessImpl.ACCESS_READ_WRITE);
        this.createSnmp4jCfgStorageEntry();
        this.configPathRoot = new File(System.getProperty("user.dir", ""));
    }

    public MOTable<Snmp4jCfgStorageEntryRow, MOColumn, MOMutableTableModel<Snmp4jCfgStorageEntryRow>> getSnmp4jCfgStorageEntry() {
        return this.snmp4jCfgStorageEntry;
    }

    public MOPersistenceProvider getPrimaryPersistence() {
        return this.primaryPersistence;
    }

    private void createSnmp4jCfgStorageEntry() {
        MOColumn[] snmp4jCfgStorageEntryColumns = new MOColumn[8];
        snmp4jCfgStorageEntryColumns[0] = new DisplayString<Object>(2, MOAccessImpl.ACCESS_READ_CREATE, null, true, 0, 255);
        ((MOMutableColumn)snmp4jCfgStorageEntryColumns[0]).addMOValueValidationListener(new Snmp4jCfgStoragePathValidator());
        snmp4jCfgStorageEntryColumns[7] = new MOMutableColumn<OctetString>(10, 4, MOAccessImpl.ACCESS_READ_CREATE, new OctetString("default"));
        ((MOMutableColumn)snmp4jCfgStorageEntryColumns[7]).addMOValueValidationListener(new Snmp4jCfgStorageFormatValidator());
        snmp4jCfgStorageEntryColumns[1] = new MOColumn(4, 67, MOAccessImpl.ACCESS_READ_ONLY);
        snmp4jCfgStorageEntryColumns[2] = new MOColumn(5, 67, MOAccessImpl.ACCESS_READ_ONLY);
        snmp4jCfgStorageEntryColumns[3] = new Enumerated<Integer32>(6, 2, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, new int[]{1, 2, 3, 4});
        snmp4jCfgStorageEntryColumns[4] = new Enumerated<Integer32>(7, 2, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, new int[]{1, 2, 3, 4});
        ((MOMutableColumn)snmp4jCfgStorageEntryColumns[4]).addMOValueValidationListener(new Snmp4jCfgStorageOperationValidator());
        snmp4jCfgStorageEntryColumns[5] = new StorageType(8, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true);
        snmp4jCfgStorageEntryColumns[6] = new RowStatus(9);
        this.snmp4jCfgStorageEntryModel = new DefaultMOMutableTableModel<Snmp4jCfgStorageEntryRow>();
        this.snmp4jCfgStorageEntryModel.setRowFactory(new Snmp4jCfgStorageEntryRowFactory());
        this.snmp4jCfgStorageEntry = moFactory.createTable(oidSnmp4jCfgStorageEntry, snmp4jCfgStorageEntryIndex, snmp4jCfgStorageEntryColumns, this.snmp4jCfgStorageEntryModel);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmp4jCfgSecSrcAddrValidation, context);
        server.register(this.snmp4jCfgStorageEntry, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmp4jCfgSecSrcAddrValidation, context);
        server.unregister(this.snmp4jCfgStorageEntry, context);
    }

    public void setSnmpCommunityMIB(SnmpCommunityMIB snmpCommunityMIB) {
        this.snmpCommunityMIB = snmpCommunityMIB;
    }

    public void setPrimaryProvider(MOPersistenceProvider persistenceProvider) {
        this.primaryPersistence = persistenceProvider;
        Snmp4jCfgStorageEntryRow primary = (Snmp4jCfgStorageEntryRow)this.snmp4jCfgStorageEntryModel.getRow(PRIMARY_INDEX);
        if (primary == null) {
            Variable[] vbs = this.snmp4jCfgStorageEntry.getDefaultValues();
            vbs[6] = new Integer32(1);
            primary = this.snmp4jCfgStorageEntry.createRow(PRIMARY_INDEX, vbs);
            primary.setSnmp4jCfgStorageID(new OctetString(persistenceProvider.getPersistenceProviderID()));
            primary.setSnmp4jCfgStorageStorageType(new Integer32(4));
            primary.setSnmp4jCfgStorageOperation(new Integer32(1));
            this.snmp4jCfgStorageEntry.addRow(primary);
        }
        primary.setSnmp4jCfgStoragePath(new OctetString(this.primaryPersistence.getDefaultURI()));
        this.addPersistenceProvider(persistenceProvider);
    }

    public void addPersistenceProvider(MOPersistenceProvider provider) {
        this.persistenceProvider.put(provider.getPersistenceProviderID(), provider);
    }

    public MOPersistenceProvider getPersistenceProvider(String id) {
        return this.persistenceProvider.get(id);
    }

    public SnmpCommunityMIB getCoexistenceInfoProvider() {
        return this.snmpCommunityMIB;
    }

    private class Operation
    extends Thread {
        private Snmp4jCfgStorageEntryRow row;
        private int operation;
        private int restoreType;
        private MOPersistenceProvider provider;

        public Operation(Snmp4jCfgStorageEntryRow row, MOPersistenceProvider provider, int restoreType, int operation) {
            this.operation = operation;
            this.provider = provider;
            this.restoreType = restoreType;
            this.row = row;
        }

        @Override
        public void run() {
            switch (this.operation) {
                case 3: {
                    String path = this.row.getValue(0).toString();
                    try {
                        this.provider.store(path);
                        this.row.setValue(1, (Variable)Snmp4jConfigMib.this.sysUpTime.get());
                        this.row.setValue(4, (Variable)new Integer32(1));
                    }
                    catch (Exception iox) {
                        logger.error((CharSequence)("Failed to store config to '" + path + "': " + iox.getMessage()), (Throwable)iox);
                        this.row.setValue(4, (Variable)new Integer32(1));
                    }
                    break;
                }
                case 4: {
                    String f = this.row.getValue(0).toString();
                    try {
                        this.provider.restore(f, this.restoreType);
                        this.row.setValue(2, (Variable)Snmp4jConfigMib.this.sysUpTime.get());
                        this.row.setValue(4, (Variable)new Integer32(1));
                    }
                    catch (Exception iox) {
                        logger.error((CharSequence)("Failed to restore config from '" + f + "': " + iox.getMessage()), (Throwable)iox);
                        this.row.setValue(4, (Variable)new Integer32(1));
                    }
                    break;
                }
            }
        }
    }

    public class Snmp4jCfgStorageEntryRow
    extends DefaultMOMutableRow2PC {
        public Snmp4jCfgStorageEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getSnmp4jCfgStoragePath() {
            return (OctetString)this.getValue(0);
        }

        public void setSnmp4jCfgStoragePath(OctetString newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public OctetString getSnmp4jCfgStorageID() {
            return (OctetString)this.getValue(7);
        }

        public void setSnmp4jCfgStorageID(OctetString newValue) {
            this.setValue(7, (Variable)newValue);
        }

        public TimeTicks getSnmp4jCfgStorageLastStore() {
            return (TimeTicks)this.getValue(1);
        }

        public void setSnmp4jCfgStorageLastStore(TimeTicks newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public TimeTicks getSnmp4jCfgStorageLastRestore() {
            return (TimeTicks)this.getValue(2);
        }

        public void setSnmp4jCfgStorageLastRestore(TimeTicks newValue) {
            this.setValue(2, (Variable)newValue);
        }

        public Integer32 getSnmp4jCfgStorageRestoreMode() {
            return (Integer32)this.getValue(3);
        }

        public void setSnmp4jCfgStorageRestoreMode(Integer32 newValue) {
            this.setValue(3, (Variable)newValue);
        }

        public Integer32 getSnmp4jCfgStorageOperation() {
            return (Integer32)this.getValue(4);
        }

        public void setSnmp4jCfgStorageOperation(Integer32 newValue) {
            this.setValue(4, (Variable)newValue);
        }

        public Integer32 getSnmp4jCfgStorageStorageType() {
            return (Integer32)this.getValue(5);
        }

        public void setSnmp4jCfgStorageStorageType(Integer32 newValue) {
            this.setValue(5, (Variable)newValue);
        }

        public Integer32 getSnmp4jCfgStorageStatus() {
            return (Integer32)this.getValue(6);
        }

        public void setSnmp4jCfgStorageStatus(Integer32 newValue) {
            this.setValue(6, (Variable)newValue);
        }

        @Override
        public void prepareRow(SubRequest<?> subRequest, MOTableRow changeSet) {
            if (PRIMARY_INDEX.equals((Object)changeSet.getIndex()) && Snmp4jConfigMib.this.snmp4jCfgStorageEntryModel.getRow(PRIMARY_INDEX) == null) {
                subRequest.getRequest().setErrorStatus(11);
            }
        }

        @Override
        public void commitRow(SubRequest<?> subRequest, MOTableRow changeSet) {
            Integer32 operation = this.getSnmp4jCfgStorageOperation();
            OctetString providerID = this.getSnmp4jCfgStorageID();
            MOPersistenceProvider provider = Snmp4jConfigMib.this.getPersistenceProvider(providerID.toString());
            if (provider == null) {
                subRequest.getRequest().setErrorStatus(14);
            } else {
                Operation op = new Operation(this, provider, this.getSnmp4jCfgStorageRestoreMode().getValue(), operation.getValue());
                this.setValue(4, (Variable)new Integer32(2));
                op.start();
            }
        }
    }

    class Snmp4jCfgStorageEntryRowFactory
    implements MOTableRowFactory<Snmp4jCfgStorageEntryRow> {
        @Override
        public Snmp4jCfgStorageEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            Snmp4jCfgStorageEntryRow row = new Snmp4jCfgStorageEntryRow(index, values);
            ((Integer32)values[4]).setValue(1);
            return row;
        }

        @Override
        public void freeRow(Snmp4jCfgStorageEntryRow row) {
        }
    }

    public static final class Snmp4jCfgStorageOperationEnum {
        public static final int idle = 1;
        public static final int inProgress = 2;
        public static final int store = 3;
        public static final int restore = 4;
    }

    public static final class Snmp4jCfgStorageRestoreModeEnum {
        public static final int replaceAndCreate = 1;
        public static final int updateAndCreate = 2;
        public static final int updateOnly = 3;
        public static final int createOnly = 4;
    }

    public static final class Snmp4jCfgStorageFormatEnum {
        public static final int binary = 1;
        public static final int xml = 2;
    }

    public static final class Snmp4jCfgSecSrcAddrValidationEnum {
        public static final int enabled = 1;
        public static final int disabled = 2;
        public static final int notAvailable = 3;
    }

    static class Snmp4jCfgStorageOperationValidator
    implements MOValueValidationListener {
        Snmp4jCfgStorageOperationValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            switch (newValue.toInt()) {
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    validationEvent.setValidationStatus(10);
                }
            }
        }
    }

    static class Snmp4jCfgStorageFormatValidator
    implements MOValueValidationListener {
        Snmp4jCfgStorageFormatValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            if (((Integer32)newValue).getValue() != 1) {
                validationEvent.setValidationStatus(10);
            }
        }
    }

    static class Snmp4jCfgStoragePathValidator
    implements MOValueValidationListener {
        Snmp4jCfgStoragePathValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    public class Snmp4jCfgSecSrcAddrValidation
    extends EnumeratedScalar<Integer32> {
        Snmp4jCfgSecSrcAddrValidation(OID oid, MOAccess access) {
            super(oid, access, new Integer32(), new int[]{1, 2, 3});
        }

        @Override
        public Integer32 getValue() {
            if (Snmp4jConfigMib.this.snmpCommunityMIB != null) {
                if (Snmp4jConfigMib.this.snmpCommunityMIB.isSourceAddressFiltering()) {
                    this.setValue(new Integer32(1));
                } else {
                    this.setValue(new Integer32(2));
                }
            } else {
                this.setValue(new Integer32(3));
            }
            return (Integer32)((Integer32)super.getValue()).clone();
        }

        @Override
        public void commit(SubRequest<?> request) {
            Integer32 newValue = (Integer32)request.getVariableBinding().getVariable();
            switch (newValue.getValue()) {
                case 2: {
                    Snmp4jConfigMib.this.snmpCommunityMIB.setSourceAddressFiltering(false);
                    break;
                }
                case 1: {
                    Snmp4jConfigMib.this.snmpCommunityMIB.setSourceAddressFiltering(true);
                    break;
                }
                default: {
                    request.getRequest().setErrorStatus(14);
                }
            }
            super.commit(request);
        }

        @Override
        public void cleanup(SubRequest<?> request) {
            super.cleanup(request);
        }

        @Override
        public int isValueOK(SubRequest<?> request) {
            block5: {
                Variable newValue;
                block4: {
                    newValue = request.getVariableBinding().getVariable();
                    if (Snmp4jConfigMib.this.snmpCommunityMIB == null) break block4;
                    switch (((Integer32)newValue).getValue()) {
                        case 1: 
                        case 2: {
                            break block5;
                        }
                        default: {
                            return 10;
                        }
                    }
                }
                if (((Integer32)newValue).getValue() != 3) {
                    return 12;
                }
                return 10;
            }
            return super.isValueOK(request);
        }
    }
}

