/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.security;

import org.snmp4j.agent.security.MutableVACM;
import org.snmp4j.agent.security.VacmConfigurator;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class BasicVacmConfigurator
implements VacmConfigurator {
    protected OctetString rootViewName = new OctetString("rootView");
    protected OID rootOID = new OID(new int[]{1});
    protected SecurityModel securityModel;
    protected SecurityLevel securityLevel;
    protected OctetString contextPrefix = new OctetString();
    protected int contextMatch = 1;

    @Override
    public VacmConfigurator.VacmConfigResult addUser(MutableVACM vacm, OctetString securityName, String role) {
        OctetString groupName = new OctetString(role);
        if (vacm.hasSecurityToGroupMapping(this.securityModel.getID(), securityName)) {
            return VacmConfigurator.VacmConfigResult.userExists;
        }
        vacm.addGroup(this.securityModel.getID(), securityName, groupName, 3);
        VacmConfigurator.VacmConfigResult vacmConfigResult = VacmConfigurator.VacmConfigResult.userAddedToRole;
        if (vacm.viewTreeFamilyEntryCount(this.rootViewName) == 0) {
            vacm.addViewTreeFamily(this.rootViewName, this.rootOID, new OctetString(), 1, 3);
            vacmConfigResult = VacmConfigurator.VacmConfigResult.userAndRoleAdded;
        }
        if (vacm.accessEntryCount(groupName) == 0) {
            vacm.addAccess(groupName, this.contextPrefix, this.securityModel.getID(), this.securityLevel.getSnmpValue(), this.contextMatch, this.rootViewName, Roles.admin.getRoleName().equals(role) ? this.rootViewName : null, this.rootViewName, 3);
            vacmConfigResult = VacmConfigurator.VacmConfigResult.userAndRoleAdded;
        }
        return vacmConfigResult;
    }

    @Override
    public VacmConfigurator.VacmConfigResult removeUser(MutableVACM vacm, OctetString securityName, String role) {
        if (vacm.hasSecurityToGroupMapping(this.securityModel.getID(), securityName) && vacm.removeGroup(this.securityModel.getID(), securityName)) {
            return VacmConfigurator.VacmConfigResult.userRemovedFromRole;
        }
        return VacmConfigurator.VacmConfigResult.userDoesNotExist;
    }

    @Override
    public VacmConfigurator.VacmConfigResult removeRole(MutableVACM vacm, String role) {
        if (this.isRoleSupported(role)) {
            OctetString groupName = new OctetString(role);
            if (!vacm.removeAccess(groupName, this.contextPrefix, this.securityModel.getID(), this.securityLevel.getSnmpValue())) {
                return VacmConfigurator.VacmConfigResult.roleDoesNotExist;
            }
            if (vacm.removeViewTreeFamily(this.rootViewName, this.rootOID)) {
                return VacmConfigurator.VacmConfigResult.roleRemoved;
            }
        }
        return VacmConfigurator.VacmConfigResult.roleNotSupported;
    }

    @Override
    public String[] getSupportedRoles() {
        return new String[]{Roles.admin.getRoleName(), Roles.monitor.getRoleName()};
    }

    protected boolean isRoleSupported(String role) {
        for (String r : this.getSupportedRoles()) {
            if (!r.equals(role)) continue;
            return true;
        }
        return false;
    }

    public static enum Roles {
        admin("admin"),
        monitor("monitor");

        private String roleName;

        private Roles(String roleName) {
            this.roleName = roleName;
        }

        public String getRoleName() {
            return this.roleName;
        }
    }
}

