/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.snmp.tc.SnmpAdminStringTC;
import org.snmp4j.agent.mo.snmp.tc.SnmpEngineIDTC;
import org.snmp4j.agent.mo.snmp.tc.TCModule;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class SnmpFrameworkMIB
implements MOGroup,
TCModule {
    public static final String MODULE_NAME = "SNMP-FRAMEWORK-MIB";
    private USM usm;
    private Collection<TransportMapping> transportMappings;
    private MOScalar<OctetString> snmpEngineID;
    private MOScalar<Integer32> snmpEngineBoots;
    private MOScalar<Integer32> snmpEngineTime;
    private MOScalar<Integer32> snmpEngineMaxMessageSize;
    private boolean updateUsmFromMIB;
    public static final String SNMPADMINSTRING = "SnmpAdminString";
    public static final String SNMPENGINEID = "SnmpEngineID";
    private Object[][] tcMapping;
    private Map<String, TextualConvention> textualConventions;

    public SnmpFrameworkMIB(USM usm, Collection<TransportMapping> transportMappings) {
        this(usm, transportMappings, false);
    }

    public SnmpFrameworkMIB(USM usm, Collection<TransportMapping> transportMappings, boolean updateUsmFromMIB) {
        this.usm = usm;
        this.transportMappings = transportMappings;
        this.updateUsmFromMIB = updateUsmFromMIB;
        this.createMOs();
        this.tcMapping = new Object[][]{{SNMPADMINSTRING, new SnmpAdminStringTC()}, {SNMPENGINEID, new SnmpEngineIDTC(this.snmpEngineID.getValue())}};
        this.textualConventions = new HashMap<String, TextualConvention>(this.tcMapping.length);
        for (Object[] aTcMapping : this.tcMapping) {
            this.textualConventions.put((String)aTcMapping[0], (TextualConvention)aTcMapping[1]);
        }
    }

    private void createMOs() {
        this.snmpEngineID = new MOScalar<OctetString>(new OID("1.3.6.1.6.3.10.2.1.1.0"), MOAccessImpl.ACCESS_READ_ONLY, null){

            @Override
            public OctetString getValue() {
                return new OctetString(SnmpFrameworkMIB.this.getUSM().getLocalEngineID());
            }

            @Override
            public int setValue(OctetString value) {
                int updateResult = super.setValue(value);
                if (SnmpFrameworkMIB.this.updateUsmFromMIB) {
                    SnmpFrameworkMIB.this.getUSM().setLocalEngine(value, ((Integer32)SnmpFrameworkMIB.this.snmpEngineBoots.getValue()).toInt(), ((Integer32)SnmpFrameworkMIB.this.snmpEngineTime.getValue()).toInt());
                }
                return updateResult;
            }
        };
        this.snmpEngineBoots = new MOScalar<Integer32>(new OID("1.3.6.1.6.3.10.2.1.2.0"), MOAccessImpl.ACCESS_READ_ONLY, null){

            @Override
            public Integer32 getValue() {
                return new Integer32(SnmpFrameworkMIB.this.getUSM().getEngineBoots());
            }

            @Override
            public int setValue(Integer32 value) {
                Integer32 newBoots = new Integer32(value.getValue() + 1);
                int updateResult = super.setValue(newBoots);
                if (SnmpFrameworkMIB.this.updateUsmFromMIB) {
                    SnmpFrameworkMIB.this.getUSM().setLocalEngine((OctetString)SnmpFrameworkMIB.this.snmpEngineID.getValue(), newBoots.toInt(), ((Integer32)SnmpFrameworkMIB.this.snmpEngineTime.getValue()).toInt());
                }
                return updateResult;
            }
        };
        this.snmpEngineTime = new MOScalar<Integer32>(new OID("1.3.6.1.6.3.10.2.1.3.0"), MOAccessImpl.ACCESS_READ_ONLY, null){

            @Override
            public Integer32 getValue() {
                return new Integer32(SnmpFrameworkMIB.this.getUSM().getEngineTime());
            }

            @Override
            public int setValue(Integer32 value) {
                int updateResult = super.setValue(value);
                if (SnmpFrameworkMIB.this.updateUsmFromMIB) {
                    SnmpFrameworkMIB.this.getUSM().setLocalEngine((OctetString)SnmpFrameworkMIB.this.snmpEngineID.getValue(), ((Integer32)SnmpFrameworkMIB.this.snmpEngineBoots.getValue()).toInt(), value.toInt());
                }
                return updateResult;
            }
        };
        if (this.updateUsmFromMIB) {
            this.snmpEngineID.setVolatile(false);
            this.snmpEngineBoots.setVolatile(false);
            this.snmpEngineTime.setVolatile(false);
        }
        Integer32 maxMsgSize = new Integer32(this.getMaxMessageSize());
        this.snmpEngineMaxMessageSize = new MOScalar<Integer32>(new OID("1.3.6.1.6.3.10.2.1.4.0"), MOAccessImpl.ACCESS_READ_ONLY, maxMsgSize);
    }

    private int getMaxMessageSize() {
        int totalMaxMessageSize = Integer.MAX_VALUE;
        for (TransportMapping transportMapping : this.transportMappings) {
            int maxMsgSize = transportMapping.getMaxInboundMessageSize();
            totalMaxMessageSize = Math.min(totalMaxMessageSize, maxMsgSize);
        }
        return totalMaxMessageSize;
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        if (this.usm != null) {
            server.register(this.snmpEngineID, context);
            server.register(this.snmpEngineBoots, context);
            server.register(this.snmpEngineTime, context);
        }
        server.register(this.snmpEngineMaxMessageSize, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmpEngineID, context);
        server.unregister(this.snmpEngineBoots, context);
        server.unregister(this.snmpEngineTime, context);
        server.unregister(this.snmpEngineMaxMessageSize, context);
    }

    public MOScalar getSnmpEngineBoots() {
        return this.snmpEngineBoots;
    }

    public MOScalar getSnmpEngineID() {
        return this.snmpEngineID;
    }

    public MOScalar getSnmpEngineMaxMessageSize() {
        return this.snmpEngineMaxMessageSize;
    }

    public MOScalar getSnmpEngineTime() {
        return this.snmpEngineTime;
    }

    public USM getUSM() {
        return this.usm;
    }

    public boolean isUpdateUsmFromMIB() {
        return this.updateUsmFromMIB;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public TextualConvention getTextualConvention(String name) {
        return this.textualConventions.get(name);
    }

    @Override
    public Collection<TextualConvention> getTextualConventions() {
        return this.textualConventions.values();
    }
}

