/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.io.prop;

import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snmp4j.agent.io.Context;
import org.snmp4j.agent.io.IndexedVariables;
import org.snmp4j.agent.io.MOInfo;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.Sequence;
import org.snmp4j.agent.mo.util.VariableProvider;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.util.OIDTextFormat;
import org.snmp4j.util.SimpleOIDTextFormat;

public class PropertyMOInput
implements MOInput {
    private static final LogAdapter logger = LogFactory.getLogger(PropertyMOInput.class);
    public static final String CONFIG_PREFIX = "snmp4j.agent.cfg.";
    public static final String CONTEXTS_ID = "contexts";
    public static final String OID_ID = "oid.";
    public static final String INDEX_ID = "index.";
    public static final String VERSION_ID = "version.";
    public static final String CTX_ID = "ctx.";
    public static final String VALUE_ID = "value.";
    private static final int STATE_ALL_CTX_DATA_SEQ = 0;
    private static final int STATE_ALL_CTX_DATA = 1;
    private static final int STATE_CTX_SEQ = 2;
    private static final int STATE_CTX_DATA_SEQ = 3;
    private static final int STATE_CTX_DATA = 4;
    private int importMode = 1;
    private int state = 0;
    private SortedMap<String, String> properties;
    private ContextInfo contexts;
    private OIDInfo oids;
    private DataInfo<?> data;
    private VariableProvider variables;
    private OIDTextFormat oidTextFormat = new SimpleOIDTextFormat();

    public PropertyMOInput(Properties props) {
        this.properties = PropertyMOInput.scanProperties(props);
        this.contexts = this.scanContexts(this.properties);
    }

    public PropertyMOInput(Properties props, VariableProvider variables) {
        this(props);
        this.variables = variables;
    }

    public PropertyMOInput(Properties props, VariableProvider variables, OIDTextFormat oidTextFormat) {
        this(props, variables);
        this.oidTextFormat = oidTextFormat;
    }

    private ContextInfo scanContexts(Map properties) {
        String ctx = (String)properties.get("snmp4j.agent.cfg.contexts");
        StringTokenizer st = new StringTokenizer(ctx, ",");
        ArrayList<Context> l = new ArrayList<Context>(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            OctetString s = (OctetString)this.createVariableFromString(token, OctetString.class);
            l.add(new Context(s));
        }
        return new ContextInfo(l.size(), l.iterator());
    }

    private OIDInfo scanOIDs(SortedMap<String, String> properties, OctetString ctx) {
        Map.Entry<String, String> stringStringEntry;
        Map.Entry<String, String> e;
        String k;
        String prefix = "snmp4j.agent.cfg.oid.";
        String ctxSuffix = "";
        if (ctx != null) {
            ctxSuffix = CTX_ID + ctx.toString() + ".";
        }
        prefix = prefix + ctxSuffix;
        SortedMap<String, String> oids = properties.tailMap(prefix);
        ArrayList<MOInfo> l = new ArrayList<MOInfo>();
        Iterator<Map.Entry<String, String>> iterator = oids.entrySet().iterator();
        while (iterator.hasNext() && (k = (e = (stringStringEntry = iterator.next())).getKey()).startsWith(prefix)) {
            String oid = k.substring(prefix.length());
            String version = (String)properties.get("snmp4j.agent.cfg.version." + ctxSuffix);
            l.add(new MOInfo(this.parseOID(oid), version));
        }
        return new OIDInfo(ctx, l.size(), l.iterator());
    }

    private OID parseOID(String oid) {
        try {
            return new OID(this.oidTextFormat.parse(oid));
        }
        catch (ParseException pex) {
            throw new RuntimeException("OID '" + oid + "' cannot be parsed", pex);
        }
    }

    private void scanDataVariable(SortedMap properties, OID oid, DataInfo<Variable> dataInfo) {
        String prefix = CONFIG_PREFIX;
        String ctxSuffix = "";
        if (dataInfo.context != null) {
            ctxSuffix = CTX_ID + dataInfo.context;
        }
        prefix = prefix + ctxSuffix;
        prefix = prefix + OID_ID + oid.toDottedString();
        String value = (String)properties.get(prefix);
        Variable v = this.createVariableFromString(value, Variable.class);
        dataInfo.add(v);
    }

    private void scanDataIndexVariables(SortedMap properties, OID oid, DataInfo<IndexedVariables> dataInfo) {
        String prefix = CONFIG_PREFIX;
        String ctxSuffix = "";
        if (dataInfo.context != null) {
            ctxSuffix = CTX_ID + dataInfo.context;
        }
        prefix = prefix + ctxSuffix;
        String dimension = (String)properties.get(prefix = prefix + OID_ID + oid.toDottedString());
        if (dimension == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(dimension, ": ");
        int rows = Integer.parseInt(st.nextToken());
        int cols = Integer.parseInt(st.nextToken());
        String indexPrefix = CONFIG_PREFIX + ctxSuffix + INDEX_ID + oid.toDottedString();
        String valuePrefix = CONFIG_PREFIX + ctxSuffix + VALUE_ID + oid.toDottedString();
        for (int i = 0; i < rows; ++i) {
            String indexString = (String)properties.get(indexPrefix + "." + i);
            OID index = (OID)this.createVariableFromString(indexString, OID.class);
            Variable[] v = new Variable[cols];
            for (int j = 0; j < cols; ++j) {
                String val = (String)properties.get(valuePrefix + "." + i + "." + j);
                if (val == null) continue;
                v[j] = this.createVariableFromString(val, Variable.class);
            }
            dataInfo.add(new IndexedVariables(index, v));
        }
    }

    private static SortedMap<String, String> scanProperties(Properties props) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> objectObjectEntry : props.entrySet()) {
            Map.Entry<Object, Object> e = objectObjectEntry;
            if (!e.getKey().toString().startsWith(CONFIG_PREFIX)) continue;
            map.put(e.getKey().toString(), e.getValue().toString());
        }
        return map;
    }

    @Override
    public int getImportMode() {
        return this.importMode;
    }

    @Override
    public Context readContext() throws IOException {
        if (this.state <= 2 && this.contexts != null) {
            if (this.state < 2) {
                this.state = 2;
            }
            return (Context)this.contexts.iterator.next();
        }
        throw new IOException();
    }

    @Override
    public IndexedVariables readIndexedVariables() throws IOException {
        if (this.data == null) {
            DataInfo<IndexedVariables> indexedVariablesDataInfo = new DataInfo<IndexedVariables>(this.oids.curContext);
            this.data = indexedVariablesDataInfo;
            this.scanDataIndexVariables(this.properties, this.oids.curOID.getOID(), indexedVariablesDataInfo);
        }
        IndexedVariables ivar = (IndexedVariables)this.data.next();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Read indexed variables " + ivar + " for OID " + this.oids.curOID.getOID() + " in context " + this.oids.curContext)));
        }
        return ivar;
    }

    @Override
    public MOInfo readManagedObject() throws IOException {
        MOInfo info = (MOInfo)this.oids.next();
        this.data = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Read MO " + info)));
        }
        return info;
    }

    @Override
    public Sequence readSequence() throws IOException {
        switch (this.state) {
            case 0: {
                ++this.state;
                this.oids = this.scanOIDs(this.properties, null);
                return new Sequence(this.oids.numElements);
            }
            case 1: {
                if (this.data != null && !this.oids.iterator.hasNext()) {
                    ++this.state;
                } else {
                    DataInfo<IndexedVariables> indexedVariablesDataInfo = new DataInfo<IndexedVariables>(this.oids.curContext);
                    this.data = indexedVariablesDataInfo;
                    this.scanDataIndexVariables(this.properties, this.oids.curOID.getOID(), indexedVariablesDataInfo);
                    return new Sequence(this.data.size());
                }
            }
            case 2: {
                ++this.state;
                return new Sequence(this.contexts.numContexts);
            }
        }
        return null;
    }

    @Override
    public Variable readVariable() throws IOException {
        if (this.data == null) {
            DataInfo<Variable> variableDataInfo = new DataInfo<Variable>(this.oids.curContext);
            this.data = variableDataInfo;
            this.scanDataVariable(this.properties, this.oids.curOID.getOID(), variableDataInfo);
        }
        Variable v = (Variable)this.data.next();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Read variable " + v + " for OID " + this.oids.curOID.getOID() + " in context " + this.oids.curContext)));
        }
        return v;
    }

    @Override
    public void skipContext(Context context) throws IOException {
    }

    @Override
    public void skipManagedObject(MOInfo mo) throws IOException {
    }

    public Variable createVariableFromString(String value, Class<? extends Variable> returnType) {
        if (value != null) {
            Null variable;
            char type = ' ';
            String varName = null;
            if (value.length() >= 3) {
                type = value.charAt(1);
                int pos = value.indexOf(125);
                if (type == '$') {
                    varName = value.substring(2, pos);
                }
                value = value.substring(pos + 1);
            }
            switch (type) {
                case 'i': {
                    variable = new Integer32(Integer.parseInt(value));
                    break;
                }
                case 'u': {
                    variable = new UnsignedInteger32(Long.parseLong(value));
                    break;
                }
                case 's': {
                    variable = new OctetString(value);
                    break;
                }
                case 'x': {
                    variable = OctetString.fromString((String)value, (char)':', (int)16);
                    break;
                }
                case 'd': {
                    variable = OctetString.fromString((String)value, (char)'.', (int)10);
                    break;
                }
                case 'b': {
                    variable = OctetString.fromString((String)value, (char)' ', (int)2);
                    break;
                }
                case 'n': {
                    variable = new Null();
                    break;
                }
                case 'o': {
                    try {
                        variable = this.parseOID(value);
                    }
                    catch (Exception ex) {
                        Pattern p = Pattern.compile("(\\$#?\\{[^\\}]*\\})");
                        Matcher m = p.matcher(value);
                        StringBuffer result = new StringBuffer();
                        while (m.find()) {
                            String group = m.group();
                            boolean impliedLength = true;
                            if (group.charAt(1) == '#') {
                                impliedLength = false;
                            }
                            group = group.substring(group.indexOf(123) + 1, group.length() - 1);
                            Object replacementValue = this.variables == null ? new OID() : this.variables.getVariable(group);
                            if (replacementValue == null) continue;
                            OID oid = replacementValue.toSubIndex(impliedLength);
                            m.appendReplacement(result, oid.toDottedString());
                        }
                        m.appendTail(result);
                        variable = this.parseOID(result.toString());
                    }
                    break;
                }
                case 't': {
                    variable = new TimeTicks(Long.parseLong(value));
                    break;
                }
                case 'a': {
                    variable = new IpAddress(value);
                    break;
                }
                case '$': {
                    variable = this.variables == null ? null : this.variables.getVariable(varName);
                    break;
                }
                case ' ': {
                    return null;
                }
                default: {
                    throw new IllegalArgumentException("Variable type " + type + " not supported");
                }
            }
            if (!returnType.isInstance(variable)) {
                // empty if block
            }
            return variable;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    private class DataInfo<T>
    implements Iterator {
        OctetString context;
        List<T> data = new ArrayList<T>();
        Iterator<T> iterator;

        DataInfo(OctetString context) {
            this.context = context;
        }

        public void add(T element) {
            this.data.add(element);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void initIterator() {
            if (this.iterator == null) {
                this.iterator = this.data.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.initIterator();
            return this.iterator.hasNext();
        }

        public T next() {
            this.initIterator();
            return this.iterator.next();
        }

        public int size() {
            return this.data.size();
        }
    }

    private class OIDInfo
    implements Iterator {
        int numElements;
        MOInfo curOID;
        OctetString curContext;
        Iterator<MOInfo> iterator;

        OIDInfo(OctetString context, int numElements, Iterator<MOInfo> data) {
            this.numElements = numElements;
            this.iterator = data;
            this.curContext = context;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.curOID = this.iterator.next();
            return this.curOID;
        }
    }

    private class ContextInfo
    implements Iterator {
        int numContexts;
        OctetString curContext;
        Iterator iterator;

        ContextInfo(int numContexts, Iterator contexts) {
            this.numContexts = numContexts;
            this.iterator = contexts;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.curContext = (OctetString)this.iterator.next();
            return this.curContext;
        }
    }
}

