/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.ext;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class StaticMOGroup
implements ManagedObject,
MOGroup {
    private SortedMap<OID, Variable> vbs = new TreeMap<OID, Variable>();
    private OID root;
    private MOScope scope;

    public StaticMOGroup(OID root, VariableBinding[] vbs) {
        this.root = root;
        this.scope = new DefaultMOScope(root, true, root.nextPeer(), false);
        for (VariableBinding vb : vbs) {
            if (vb.getOid() == null || vb.getVariable() == null || vb.getOid().size() < root.size() || vb.getOid().leftMostCompare(root.size(), root) != 0) continue;
            this.vbs.put(vb.getOid(), vb.getVariable());
        }
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this, context);
    }

    @Override
    public MOScope getScope() {
        return this.scope;
    }

    @Override
    public OID find(MOScope range) {
        SortedMap<OID, Variable> tail = this.vbs.tailMap(range.getLowerBound());
        OID first = tail.firstKey();
        if (range.getLowerBound().equals((Object)first) && !range.isLowerIncluded()) {
            if (tail.size() > 1) {
                Iterator<OID> it = tail.keySet().iterator();
                it.next();
                return it.next();
            }
        } else {
            return first;
        }
        return null;
    }

    @Override
    public void get(SubRequest request) {
        OID oid = request.getVariableBinding().getOid();
        Variable vb = (Variable)this.vbs.get(oid);
        if (vb == null) {
            request.getVariableBinding().setVariable((Variable)Null.noSuchInstance);
        } else {
            request.getVariableBinding().setVariable(vb);
        }
        request.completed();
    }

    @Override
    public boolean next(SubRequest request) {
        MOContextScope scope = request.getQuery().getScope();
        SortedMap<OID, Variable> tail = this.vbs.tailMap(scope.getLowerBound());
        OID first = tail.firstKey();
        if (scope.getLowerBound().equals((Object)first) && !scope.isLowerIncluded()) {
            if (tail.size() > 1) {
                Iterator<OID> it = tail.keySet().iterator();
                it.next();
                first = it.next();
            } else {
                return false;
            }
        }
        if (first != null) {
            Variable vb = (Variable)this.vbs.get(first);
            if (vb == null) {
                request.getVariableBinding().setVariable((Variable)Null.noSuchInstance);
            }
            request.getVariableBinding().setOid(first);
            request.getVariableBinding().setVariable(vb);
            request.completed();
            return true;
        }
        return false;
    }

    @Override
    public void prepare(SubRequest request) {
        request.setErrorStatus(17);
    }

    @Override
    public void commit(SubRequest request) {
        request.setErrorStatus(14);
    }

    @Override
    public void undo(SubRequest request) {
        request.setErrorStatus(15);
    }

    @Override
    public void cleanup(SubRequest request) {
    }

    public String toString() {
        return "StaticMOGroup[root=" + this.root + ",vbs=" + this.vbs + "]";
    }
}

