/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.xpath.predicate;

import java.util.Arrays;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.expr.Expr;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.resource.config.xpath.PredicateEvaluator;
import org.smooks.engine.resource.config.xpath.ElementPositionCounter;
import org.smooks.support.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PositionPredicateEvaluator
implements PredicateEvaluator {
    private final Expr expr;
    private final String elementName;
    private final String elementNS;
    private ElementPositionCounter counter;

    public PositionPredicateEvaluator(Expr expr, String elementName, String elementNS) {
        this.expr = expr;
        this.elementName = elementName;
        this.elementNS = elementNS;
    }

    public void setCounter(ElementPositionCounter positionCounter) {
        this.counter = positionCounter;
    }

    public boolean evaluate(Fragment<?> fragment, ExecutionContext executionContext) {
        Node childNode;
        Element element = (Element)fragment.unwrap();
        int count = this.counter == null ? 1 : this.counter.getCount((Element)fragment.unwrap(), executionContext);
        Node parent = element.getParentNode();
        NodeList childNodes = parent.getChildNodes();
        int childNodeCount = childNodes.getLength();
        for (int i = 0; i < childNodeCount && (childNode = childNodes.item(i)) != element; ++i) {
            if (childNode.getNodeType() != 1 || !DomUtils.getName((Element)childNode).equalsIgnoreCase(this.elementName) || !this.elementNS.equals("") && !this.elementNS.equals(childNode.getNamespaceURI())) continue;
            ++count;
        }
        Context context = new Context(new ContextSupport((NamespaceContext)new SimpleNamespaceContext(), XPathFunctionContext.getInstance(), (VariableContext)new SimpleVariableContext(), DocumentNavigator.getInstance()));
        Node unwrap = (Node)fragment.unwrap();
        context.setNodeSet(Arrays.asList(unwrap));
        try {
            return (Double)this.expr.evaluate(context) == (double)count;
        }
        catch (JaxenException e) {
            throw new SmooksException((Throwable)e);
        }
    }
}

