/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.loader.xml.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.smooks.api.TypedKey;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.api.resource.config.ConfigSearch;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigChangeListener;
import org.smooks.engine.resource.config.loader.xml.XmlResourceConfigLoader;

public class ExtensionContext {
    public static final TypedKey<ExtensionContext> EXTENSION_CONTEXT_TYPED_KEY = TypedKey.of();
    private final XmlResourceConfigLoader xmlResourceConfigLoader;
    private final String defaultProfile;
    private final ExpressionEvaluator defaultConditionEvaluator;
    private final Stack<ResourceConfig> resourceStack = new Stack<ResourceConfig>(){

        @Override
        public ResourceConfig push(ResourceConfig resourceConfiguration) {
            if (!this.isEmpty()) {
                resourceConfiguration.addChangeListener(ExtensionContext.this.resChangeListener);
            }
            return super.push(resourceConfiguration);
        }

        @Override
        public ResourceConfig pop() {
            ResourceConfig resourceConfig = (ResourceConfig)super.pop();
            if (!this.isEmpty()) {
                resourceConfig.removeChangeListener(ExtensionContext.this.resChangeListener);
            }
            return resourceConfig;
        }
    };
    private final ResourceConfigChangeListener resChangeListener = resourceConfig -> {
        String selector = resourceConfig.getSelectorPath().getSelector();
        if (selector != null && selector.startsWith("#/")) {
            ResourceConfig parentResource = (ResourceConfig)this.resourceStack.get(this.resourceStack.size() - 2);
            resourceConfig.setSelector(parentResource.getSelectorPath().getSelector() + selector.substring(1), new Properties());
        }
    };
    private final List<ResourceConfig> resources = new ArrayList<ResourceConfig>();

    public ExtensionContext(XmlResourceConfigLoader xmlResourceConfigLoader, String defaultProfile, ExpressionEvaluator defaultConditionEvaluator) {
        this.xmlResourceConfigLoader = xmlResourceConfigLoader;
        this.defaultProfile = defaultProfile;
        this.defaultConditionEvaluator = defaultConditionEvaluator;
    }

    public void addResourceConfig(ResourceConfig resourceConfig) {
        this.resourceStack.push(resourceConfig);
        this.resources.add(resourceConfig);
    }

    public void addResourceTemplate(ResourceConfig resourceConfig) {
        this.resourceStack.push(resourceConfig);
    }

    public Stack<ResourceConfig> getResourceStack() {
        return this.resourceStack;
    }

    public List<ResourceConfig> getResources() {
        return this.resources;
    }

    public XmlResourceConfigLoader getXmlResourceConfigLoader() {
        return this.xmlResourceConfigLoader;
    }

    public String getDefaultProfile() {
        return this.defaultProfile;
    }

    public ExpressionEvaluator getDefaultConditionEvaluator() {
        return this.defaultConditionEvaluator;
    }

    public ResourceConfig getResourceConfigsByName(String name) {
        for (int i = this.resourceStack.size() - 1; i >= 0; --i) {
            ResourceConfig resourceConfig = (ResourceConfig)this.resourceStack.get(i);
            String resourceName = resourceConfig.getResource();
            if (!name.equals(resourceName)) continue;
            return resourceConfig;
        }
        return null;
    }

    public List<ResourceConfig> lookupResourceConfigs(ConfigSearch searchCriteria) {
        return this.xmlResourceConfigLoader.getResourceConfigSeq().lookupResource(searchCriteria);
    }
}

