/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.plugin;

import org.smooks.api.io.Sink;
import org.smooks.engine.plugin.SinkType;
import org.smooks.io.sink.ByteSink;
import org.smooks.io.sink.JavaSink;
import org.smooks.io.sink.NullSink;
import org.smooks.io.sink.StringSink;

public class SinkFactory {
    private static final SinkFactory factory = new SinkFactory();

    private SinkFactory() {
    }

    public static SinkFactory getInstance() {
        return factory;
    }

    public Sink createSink(SinkType type) {
        Sink sink = null;
        switch (type) {
            case STRING: {
                sink = new StringSink();
                break;
            }
            case BYTES: {
                sink = new ByteSink();
                break;
            }
            case JAVA: {
                sink = new JavaSink(true);
                break;
            }
            case NO_SINK: {
                sink = new NullSink();
                break;
            }
        }
        return sink;
    }
}

