/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.lookup;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.engine.lookup.ResourceConfigSeqsLookup;

public class GlobalParamsLookup
implements Function<Map<Object, Object>, ParameterAccessor> {
    @Override
    public ParameterAccessor apply(Map<Object, Object> registryEntries) {
        ConcurrentHashMap<String, Object> globalParams = new ConcurrentHashMap<String, Object>();
        List<ResourceConfigSeq> resourceConfigSeqs = new ResourceConfigSeqsLookup().apply(Collections.unmodifiableMap(registryEntries));
        for (ResourceConfigSeq resourceConfigSeq : resourceConfigSeqs) {
            for (int i = 0; i < resourceConfigSeq.size(); ++i) {
                ResourceConfig nextResourceConfig = resourceConfigSeq.get(i);
                if (!"global-parameters".equals(nextResourceConfig.getSelectorPath().getSelector())) continue;
                for (Map.Entry globalParameter : nextResourceConfig.getParameters().entrySet()) {
                    if (globalParams.get(globalParameter.getKey()) == null) {
                        String systemProperty = System.getProperty((String)globalParameter.getKey());
                        if (systemProperty == null) {
                            globalParams.put((String)globalParameter.getKey(), nextResourceConfig.getParameterValue((String)globalParameter.getKey()));
                            continue;
                        }
                        globalParams.put((String)globalParameter.getKey(), systemProperty);
                        continue;
                    }
                    if (nextResourceConfig.isSystem()) continue;
                    globalParams.put((String)globalParameter.getKey(), nextResourceConfig.getParameterValue((String)globalParameter.getKey()));
                }
            }
        }
        return new ParameterAccessor(globalParams);
    }

    public static class ParameterAccessor {
        private final Map<String, Object> globalParams;

        private ParameterAccessor(Map<String, Object> globalParams) {
            this.globalParams = new ConcurrentHashMap<String, Object>(globalParams);
        }

        public <T> T getParameterValue(String name) {
            return this.getParameterValue(name, null);
        }

        public <T> T getParameterValue(String name, T defaultValue) {
            Object globalParam = this.globalParams.get(name);
            if (globalParam == null) {
                globalParam = System.getProperty(name);
            }
            return (T)(globalParam != null ? globalParam : defaultValue);
        }

        public Map<String, Object> getParameters() {
            return new HashMap<String, Object>(this.globalParams);
        }
    }
}

