/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng;

import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.io.Sink;
import org.smooks.api.io.Source;
import org.smooks.engine.delivery.AbstractFilter;
import org.smooks.engine.delivery.sax.ng.SaxNgParser;
import org.smooks.engine.delivery.sax.ng.terminate.TerminateException;
import org.smooks.io.Stream;
import org.smooks.io.sink.DOMSink;
import org.smooks.io.sink.JavaSink;
import org.smooks.io.sink.StreamSink;
import org.smooks.io.sink.WriterSink;
import org.smooks.io.source.DOMSource;
import org.smooks.io.source.JavaSource;
import org.smooks.io.source.ReaderSource;
import org.smooks.io.source.StreamSource;
import org.smooks.io.source.URLSource;
import org.smooks.support.DomUtils;
import org.smooks.support.XmlUtils;

public class SaxNgFilter
extends AbstractFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaxNgFilter.class);
    protected final ExecutionContext executionContext;
    protected final boolean closeSource;
    protected final boolean closeSink;
    protected final SaxNgParser parser;

    public SaxNgFilter(ExecutionContext executionContext, DocumentBuilder documentBuilder, boolean closeSource, boolean closeSink) {
        this.executionContext = executionContext;
        this.closeSource = closeSource;
        this.closeSink = closeSink;
        this.parser = new SaxNgParser(executionContext, documentBuilder);
    }

    public void doFilter() throws SmooksException {
        Source source = (Source)this.executionContext.get(Source.SOURCE_TYPED_KEY);
        Sink sink = this.getSink(this.executionContext, StreamSink.class);
        if (sink == null && (sink = this.getSink(this.executionContext, WriterSink.class)) == null) {
            sink = this.getSink(this.executionContext, DOMSink.class);
        }
        this.doFilter(source, sink);
    }

    protected void doFilter(Source source, Sink sink) {
        if (!(source instanceof StreamSource || source instanceof ReaderSource || source instanceof JavaSource || source instanceof DOMSource || source instanceof URLSource)) {
            throw new SmooksException(String.format("Unsupported [%s] source type: SAX NG filter supports StreamSource, JavaSource, DOMSource, and URLSource", source.getClass().getName()));
        }
        if (!(sink == null || sink instanceof StreamSink || sink instanceof WriterSink || sink instanceof DOMSink || sink instanceof JavaSink)) {
            throw new SmooksException(String.format("Unsupported [%s] sink type: SAX NG filter supports either StreamSink, DOMSink, or JavaSink", sink.getClass().getName()));
        }
        try {
            Writer writer = this.getWriter(sink, this.executionContext);
            this.executionContext.put(Stream.STREAM_WRITER_TYPED_KEY, (Object)writer);
            this.parser.parse(source, this.executionContext);
            if (sink instanceof DOMSink) {
                ((DOMSink)sink).setNode(XmlUtils.parseStream((Reader)new StringReader(writer.toString())));
            } else {
                writer.flush();
            }
        }
        catch (TerminateException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Terminated filtering on element {}", (Object)DomUtils.getXPath(e.getElement()));
            }
        }
        catch (Exception e) {
            throw new SmooksException("Failed to filter source", (Throwable)e);
        }
        finally {
            if (this.closeSource) {
                this.close(source);
            }
            if (this.closeSink) {
                this.close(sink);
            }
        }
    }

    public void close() {
        this.parser.close();
    }
}

