/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.event;

import java.util.Arrays;
import org.smooks.api.delivery.event.ResourceAwareEvent;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.engine.delivery.event.FragmentExecutionEvent;
import org.smooks.engine.delivery.event.VisitSequence;

public class ResourceTargetingExecutionEvent<T>
extends FragmentExecutionEvent<T>
implements ResourceAwareEvent {
    private final ResourceConfig resourceConfig;
    private Object[] metadata;
    private VisitSequence sequence;

    public ResourceTargetingExecutionEvent(Fragment<T> fragment, ResourceConfig resourceConfig, Object ... metadata) {
        super(fragment);
        this.resourceConfig = resourceConfig;
        this.metadata = metadata;
    }

    public ResourceTargetingExecutionEvent(Fragment<T> fragment, ResourceConfig resourceConfig, VisitSequence sequence, Object ... metadata) {
        this(fragment, resourceConfig, metadata);
        this.sequence = sequence;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public void setMetadata(Object ... metadata) {
        this.metadata = metadata;
    }

    public Object[] getMetadata() {
        return this.metadata;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Target: ").append(this.getFragment().unwrap()).append(". ");
        builder.append("Resource: ").append(this.resourceConfig).append(". ");
        if (this.metadata != null) {
            builder.append("Event Metadata: ").append(Arrays.asList(this.metadata)).append(".");
        }
        return builder.toString();
    }

    public VisitSequence getSequence() {
        return this.sequence;
    }
}

