/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.smooks.api.delivery.ReaderPool;
import org.xml.sax.XMLReader;

@Resource(name="DefaultReaderPool")
public class DefaultReaderPool
implements ReaderPool {
    private final AtomicReferenceArray<Optional<XMLReader>> xmlReaderPool;
    private final int maxReaderPoolSize;

    public DefaultReaderPool(int maxReaderPoolSize) {
        this.maxReaderPoolSize = maxReaderPoolSize;
        this.xmlReaderPool = new AtomicReferenceArray(maxReaderPoolSize);
    }

    public XMLReader borrowXMLReader() {
        for (int i = 0; i < this.xmlReaderPool.length(); ++i) {
            Optional<XMLReader> xmlReader = this.xmlReaderPool.get(i);
            if (xmlReader == null || !(xmlReader = this.xmlReaderPool.getAndSet(i, Optional.empty())).isPresent()) continue;
            return xmlReader.get();
        }
        return null;
    }

    public void returnXMLReader(XMLReader xmlReader) {
        for (int i = 0; i < this.xmlReaderPool.length(); ++i) {
            Optional<XMLReader> optionalXMLReader = Optional.of(xmlReader);
            if (!this.xmlReaderPool.compareAndSet(i, Optional.empty(), optionalXMLReader) && !this.xmlReaderPool.compareAndSet(i, null, optionalXMLReader)) continue;
            return;
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>(3);
        properties.put("maxReadersSize", String.valueOf(this.maxReaderPoolSize));
        int unallocatedReaders = 0;
        int activeReaders = 0;
        for (int i = 0; i < this.xmlReaderPool.length(); ++i) {
            Optional<XMLReader> xmlReader = this.xmlReaderPool.get(i);
            if (xmlReader == null || xmlReader.isPresent()) {
                ++unallocatedReaders;
                continue;
            }
            ++activeReaders;
        }
        properties.put("unallocatedReaders", String.valueOf(unallocatedReaders));
        properties.put("activeReaders", String.valueOf(activeReaders));
        return properties;
    }

    public int getMaxReaderPoolSize() {
        return this.maxReaderPoolSize;
    }
}

