/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.Filter;
import org.smooks.api.io.Sink;
import org.smooks.api.io.Source;
import org.smooks.io.NullReader;
import org.smooks.io.NullWriter;
import org.smooks.io.Stream;
import org.smooks.io.sink.DOMSink;
import org.smooks.io.sink.StreamSink;
import org.smooks.io.sink.WriterSink;
import org.smooks.io.source.ReaderSource;
import org.smooks.io.source.StreamSource;

public abstract class AbstractFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFilter.class);

    protected Reader getReader(Source source, ExecutionContext executionContext) {
        if (source instanceof ReaderSource) {
            ReaderSource readerSource = (ReaderSource)source;
            if (readerSource.getReader() != null) {
                return readerSource.getReader();
            }
            throw new SmooksException(String.format("Invalid [%s]. No reader instance", ReaderSource.class.getName()));
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (streamSource.getInputStream() != null) {
                try {
                    if (executionContext != null) {
                        return new InputStreamReader((InputStream)streamSource.getInputStream(), executionContext.getContentEncoding());
                    }
                    return new InputStreamReader((InputStream)streamSource.getInputStream(), StandardCharsets.UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SmooksException("Unable to decode input stream.", (Throwable)e);
                }
            }
            throw new SmooksException(String.format("Invalid [%s]. No reader instance", StreamSource.class.getName()));
        }
        return new NullReader();
    }

    protected Writer getWriter(Sink sink, ExecutionContext executionContext) {
        if (sink instanceof WriterSink) {
            WriterSink writerSink = (WriterSink)sink;
            Object writer = writerSink.getWriter();
            if (writer != null) {
                return writerSink.getWriter();
            }
            throw new SmooksException(String.format("Invalid [%s]. No Writer instance.", sink.getClass().getName()));
        }
        if (sink instanceof StreamSink) {
            StreamSink streamSink = (StreamSink)sink;
            Object outputStream = streamSink.getOutputStream();
            if (outputStream != null) {
                try {
                    if (executionContext != null) {
                        return new OutputStreamWriter((OutputStream)streamSink.getOutputStream(), executionContext.getContentEncoding());
                    }
                    return new OutputStreamWriter((OutputStream)streamSink.getOutputStream(), StandardCharsets.UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SmooksException("Unable to encode output stream.", (Throwable)e);
                }
            }
            throw new SmooksException(String.format("Invalid [%s]. No OutputStream instance.", sink.getClass().getName()));
        }
        if (sink instanceof DOMSink) {
            return new StringWriter();
        }
        Writer writer = Stream.out(executionContext);
        if (writer != null) {
            return writer;
        }
        return new NullWriter();
    }

    protected void close(Source source) {
        block7: {
            try {
                ReaderSource readerSource;
                if (source instanceof StreamSource) {
                    StreamSource streamSource = (StreamSource)source;
                    try {
                        Object inputStream;
                        if (streamSource.getInputStream() != null && (inputStream = streamSource.getInputStream()) != System.in) {
                            ((InputStream)inputStream).close();
                        }
                        break block7;
                    }
                    catch (Throwable throwable) {
                        LOGGER.debug("Failed to close input stream/reader.", throwable);
                    }
                    break block7;
                }
                if (source instanceof ReaderSource && (readerSource = (ReaderSource)source).getReader() != null) {
                    ((Reader)readerSource.getReader()).close();
                }
            }
            catch (Throwable throwable) {
                LOGGER.debug("Failed to close input stream/reader.", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(Sink sink) {
        block13: {
            try {
                if (sink instanceof StreamSink) {
                    StreamSink streamSink = (StreamSink)sink;
                    if (streamSink.getOutputStream() == null) break block13;
                    Object outputStream = streamSink.getOutputStream();
                    try {
                        ((OutputStream)outputStream).flush();
                        break block13;
                    }
                    finally {
                        if (outputStream != System.out && outputStream != System.err) {
                            ((OutputStream)outputStream).close();
                        }
                    }
                }
                if (!(sink instanceof WriterSink)) break block13;
                WriterSink writerSink = (WriterSink)sink;
                try (Object writer = writerSink.getWriter();){
                    ((Writer)writer).flush();
                }
            }
            catch (Throwable throwable) {
                LOGGER.debug("Failed to close output stream/writer.  May already be closed.", throwable);
            }
        }
    }

    protected Sink getSink(ExecutionContext executionContext, Class<? extends Sink> sinkType) {
        List sinks = (List)executionContext.get(Sink.SINKS_TYPED_KEY);
        if (sinks != null) {
            for (Sink sink : sinks) {
                if (sink == null || !sinkType.isAssignableFrom(sink.getClass())) continue;
                return sink;
            }
        }
        return null;
    }
}

