/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import jakarta.annotation.Resource;
import java.text.ParseException;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.NumberTypeConverter;

@Resource(name="Long")
public class StringToLongConverterFactory
implements TypeConverterFactory<String, Long>,
Configurable {
    private Properties properties = new Properties();

    public TypeConverter<String, Long> createTypeConverter() {
        NumberTypeConverter<String, Long> numberTypeConverter = new NumberTypeConverter<String, Long>(){

            @Override
            protected Long doConvert(String value) {
                if (this.numberFormat != null) {
                    try {
                        Number number = this.numberFormat.parse(value.trim());
                        if (this.isPercentage()) {
                            return (long)(number.doubleValue() * 100.0);
                        }
                        return number.longValue();
                    }
                    catch (ParseException e) {
                        throw new TypeConverterException("Failed to decode Long value '" + value + "' using NumberFormat instance " + this.numberFormat + ".", (Throwable)e);
                    }
                }
                try {
                    return Long.parseLong(value.trim());
                }
                catch (NumberFormatException e) {
                    throw new TypeConverterException("Failed to decode Long value '" + value + "'.", (Throwable)e);
                }
            }
        };
        numberTypeConverter.setConfiguration(this.properties);
        return numberTypeConverter;
    }

    public TypeConverterDescriptor<Class<String>, Class<Long>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Long>>(String.class, Long.class);
    }

    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    public Properties getConfiguration() {
        return this.properties;
    }
}

