/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.StringToDateLocaleAwareConverter;

public class SqlTimestampConverterFactory
implements TypeConverterFactory<String, Timestamp>,
Configurable {
    private Properties properties = new Properties();

    public TypeConverter<String, Timestamp> createTypeConverter() {
        StringToDateLocaleAwareConverter<Timestamp> stringToDateLocaleAwareConverter = new StringToDateLocaleAwareConverter<Timestamp>(){

            @Override
            protected Timestamp doConvert(Date date) {
                return new Timestamp(date.getTime());
            }
        };
        stringToDateLocaleAwareConverter.setConfiguration(this.properties);
        return stringToDateLocaleAwareConverter;
    }

    public TypeConverterDescriptor<Class<String>, Class<Timestamp>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Timestamp>>(String.class, Timestamp.class);
    }

    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    public Properties getConfiguration() {
        return this.properties;
    }
}

