/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import jakarta.annotation.Resource;
import java.sql.Time;
import java.util.Date;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.StringToDateLocaleAwareConverter;

@Resource(name="Time")
public class SqlTimeConverterFactory
implements TypeConverterFactory<String, Time>,
Configurable {
    private Properties properties = new Properties();

    public TypeConverter<String, Time> createTypeConverter() {
        SqlTimeTypeConverter sqlTimeTypeConverter = new SqlTimeTypeConverter();
        sqlTimeTypeConverter.setConfiguration(this.properties);
        return sqlTimeTypeConverter;
    }

    public TypeConverterDescriptor<Class<String>, Class<Time>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Time>>(String.class, Time.class);
    }

    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    public Properties getConfiguration() {
        return this.properties;
    }

    public static class SqlTimeTypeConverter
    extends StringToDateLocaleAwareConverter<Time> {
        @Override
        protected Time doConvert(Date date) {
            return new Time(date.getTime());
        }
    }
}

