/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.engine.converter.LocaleAwareTypeConverter;

public abstract class NumberTypeConverter<S, T>
extends LocaleAwareTypeConverter<S, T> {
    public static final String FORMAT = "format";
    public static final String TYPE = "type";
    protected NumberFormat numberFormat;
    private NumberType type;

    public T convert(S value) {
        return this.doConvert(value);
    }

    protected abstract T doConvert(S var1);

    @Override
    public void setConfiguration(Properties properties) throws SmooksConfigException {
        super.setConfiguration(properties);
        if (properties != null) {
            String pattern = properties.getProperty(FORMAT);
            String typeConfig = properties.getProperty(TYPE);
            Locale locale = this.getLocale();
            if (locale == null && pattern == null) {
                return;
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (typeConfig == null) {
                this.type = NumberType.RAW;
            } else {
                try {
                    this.type = NumberType.valueOf(typeConfig);
                }
                catch (Exception e) {
                    throw new SmooksConfigException("Unsupported Number type specification '" + typeConfig + "'.  Must be one of '" + NumberType.values() + "'.");
                }
            }
            if (this.type == NumberType.PERCENTAGE || pattern != null && pattern.indexOf(37) != -1) {
                this.type = NumberType.PERCENTAGE;
                this.numberFormat = NumberFormat.getPercentInstance(locale);
            } else if (this.type == NumberType.CURRENCY) {
                this.numberFormat = NumberFormat.getCurrencyInstance(locale);
            } else {
                this.numberFormat = NumberFormat.getInstance(locale);
                this.numberFormat.setGroupingUsed(false);
                if (pattern != null && this.numberFormat instanceof DecimalFormat) {
                    ((DecimalFormat)this.numberFormat).applyPattern(pattern);
                }
            }
        }
    }

    public NumberFormat getNumberFormat() {
        if (this.numberFormat != null) {
            return (NumberFormat)this.numberFormat.clone();
        }
        return null;
    }

    public NumberType getType() {
        return this.type;
    }

    public boolean isPercentage() {
        return this.type == NumberType.PERCENTAGE;
    }

    public static enum NumberType {
        RAW,
        PERCENTAGE,
        CURRENCY;

    }
}

